/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.linkviewcontribution;

import com.arcway.cockpit.frame.client.global.gui.views.linkview.IndirectLinksContainer;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMLinkItems;
import com.arcway.cockpit.genericmodule.client.gui.linkviewcontribution.GenericModuleLinkViewContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractLinkContentProvider;
import com.arcway.cockpit.modulelib2.client.gui.IModuleLinkViewContent;
import com.arcway.cockpit.modulelib2.client.gui.IUserInterface;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public class LinkContentProvider
extends AbstractLinkContentProvider {
    private final String moduleID;
    private final ModuleSpecification moduleSpecification;
    private final Map<String, String> map_linkedObjectCockpitTypeID_linkTypeID;
    private String currentProjectId = null;

    public LinkContentProvider(String moduleID, ModuleSpecification moduleSpecification, IUserInterface UI) {
        super(UI);
        this.moduleID = moduleID;
        this.moduleSpecification = moduleSpecification;
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(moduleID);
        this.map_linkedObjectCockpitTypeID_linkTypeID = new HashMap<String, String>();
        for (ModelElementLinkType modelElementLinkType : moduleSpecification.getModuleDataSpecification().getRelationTypeListOfType(ModelElementLinkType.class)) {
            this.map_linkedObjectCockpitTypeID_linkTypeID.put(ClientDataFactory_TypesHelper.getDataTypeID(moduleID, modelElementLinkType.getLinkedObjectTypeID()), linkTypeHelper.getModelElementLinkTypeID_forShortTypeID(modelElementLinkType.getLinkedObjectTypeID()));
        }
    }

    public boolean hasLinks(IUniqueElement element, Collection<IUniqueElement> containedElements, Collection<IUniqueElement> containerElements) {
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(element.getProjectUID());
        return LinkContentProvider.hasLinkedInformation((IUniqueElement)element, containedElements, containerElements, (IModelController)modelController, this.map_linkedObjectCockpitTypeID_linkTypeID.values());
    }

    public boolean hasChildren(Object element) {
        if (element instanceof GenericModuleLinkViewContent) {
            return ((GenericModuleLinkViewContent)element).getModuleID().equals(this.moduleID);
        }
        if (element instanceof GenericModuleData) {
            GenericModuleData item = (GenericModuleData)((Object)element);
            IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
            Collection children = modelController.getChildren((IModuleData)item);
            if (children.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GenericModuleLinkViewContent && ((GenericModuleLinkViewContent)parentElement).getModuleID().equals(this.moduleID)) {
            return ((GenericModuleLinkViewContent)parentElement).toArray();
        }
        if (parentElement instanceof GenericModuleData) {
            GenericModuleData item = (GenericModuleData)((Object)parentElement);
            IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
            Collection children = modelController.getChildren((IModuleData)item);
            if (children.size() > 0) {
                return children.toArray();
            }
        }
        return null;
    }

    public String getTypeName() {
        return new LabelProvider(this.moduleSpecification.getModuleDataName()).getLabel(Locale.getDefault());
    }

    public ImageDescriptor getIcon() {
        return ResourceManager.getDefault().getImageDescriptor(this.moduleID, this.moduleSpecification.getModuleIcon());
    }

    public boolean canDeleteInfoLink(ICockpitProjectData uniqueElement, ICockpitProjectData moduleDataItem) {
        String projectUID = uniqueElement.getProjectUID();
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
        if (moduleDataItem instanceof GenericModuleData) {
            String linkTypeID = this.map_linkedObjectCockpitTypeID_linkTypeID.get(((GenericModuleData)moduleDataItem).getTypeID());
            return linkTypeID != null && modelController.getModuleData(uniqueElement.getUID(), linkTypeID).contains(moduleDataItem);
        }
        return false;
    }

    public void deleteInfoLink(final ICockpitProjectData uniqueElement, final ICockpitProjectData moduleDataItem) {
        String linkTypeID;
        String projectUID = uniqueElement.getProjectUID();
        final IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
        if (moduleDataItem instanceof GenericModuleData && (linkTypeID = this.map_linkedObjectCockpitTypeID_linkTypeID.get(((GenericModuleData)moduleDataItem).getTypeID())) != null) {
            modelController.executeTransaction(new Runnable(){

                @Override
                public void run() {
                    modelController.deleteLink(uniqueElement.getUID(), moduleDataItem.getUID(), linkTypeID);
                }
            });
        }
    }

    public Collection<String> getUIDsOfLinkedUniqueElement(ICockpitProjectData data) {
        return Collections.emptySet();
    }

    public boolean isLinkedModuleDataLinkType(String linkTypeID) {
        for (String cockpitType : this.map_linkedObjectCockpitTypeID_linkTypeID.keySet()) {
            String linkTypeIDCandidate = this.map_linkedObjectCockpitTypeID_linkTypeID.get(cockpitType);
            if (!linkTypeIDCandidate.equals(linkTypeID)) continue;
            return true;
        }
        return false;
    }

    protected List<? extends IModuleLinkViewContent> doGetLinkedModuleData(IUniqueElement element, Collection<? extends IUniqueElement> containedElements, Collection<? extends IUniqueElement> containerElements) {
        String newProjectId;
        this.currentProjectId = newProjectId = element.getProjectUID();
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(this.currentProjectId);
        ArrayList<GenericModuleLinkViewContent> currentLinkViewContent = new ArrayList<GenericModuleLinkViewContent>();
        for (String cockpitType : this.map_linkedObjectCockpitTypeID_linkTypeID.keySet()) {
            String objectType = ClientDataFactory_TypesHelper.getShortTypeID(cockpitType);
            String linkTypeID = this.map_linkedObjectCockpitTypeID_linkTypeID.get(cockpitType);
            ArrayList<IndirectLinksContainer> allLinkedItems = new ArrayList<IndirectLinksContainer>(modelController.getModuleData(element.getUID(), linkTypeID));
            HashSet containedLinks = new HashSet();
            for (IUniqueElement iUniqueElement : containedElements) {
                Collection linkedItems = modelController.getModuleData(iUniqueElement.getUID(), linkTypeID);
                containedLinks.addAll(linkedItems);
            }
            if (!containedLinks.isEmpty()) {
                IndirectLinksContainer indirectLinksContainer = new IndirectLinksContainer(true);
                indirectLinksContainer.setLinkedModuleData(new ArrayList(containedLinks));
                allLinkedItems.add(indirectLinksContainer);
            }
            HashSet hashSet = new HashSet();
            for (IUniqueElement iUniqueElement : containerElements) {
                Collection linkedItems = modelController.getModuleData(iUniqueElement.getUID(), linkTypeID);
                hashSet.addAll(linkedItems);
            }
            if (!hashSet.isEmpty()) {
                IndirectLinksContainer indirectLinksContainer = new IndirectLinksContainer(false);
                indirectLinksContainer.setLinkedModuleData(new ArrayList(hashSet));
                allLinkedItems.add(indirectLinksContainer);
            }
            if (allLinkedItems.isEmpty()) continue;
            GenericModuleLinkViewContent genericModuleLinkViewContent = new GenericModuleLinkViewContent(this.moduleID, objectType, allLinkedItems);
            currentLinkViewContent.add(genericModuleLinkViewContent);
        }
        return currentLinkViewContent;
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForUnlinking() {
        return ClientFunctionLicenseTypeGMLinkItems.getInstance(this.moduleID);
    }
}

