/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractDateValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DateFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.FilterHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.gui.AttributeUIHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Filters;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleUISpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.messages.AttributeHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.ModuleDataTreeListFilterItem;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class GenericModuleFilters
implements IModuleProjectSwitchListener {
    public static final int OPERATIONALMODE_MODELBOUND = 1;
    public static final int OPERATIONALMODE_UIBOUND = 2;
    private final int operationalMode;
    private IModelController model;
    private IModuleProjectSwitchListenerManager projectSwitchListenerManager;
    private final String moduleID;
    private final String moduleDataName;
    private final ModuleUISpecification moduleUISpecification;
    private final ModuleDataSpecification moduleDataSpecification;
    private final Set<String> relevantObjectTypes;

    public GenericModuleFilters(String moduleID, ModuleSpecification moduleSpecification, Set<String> relevantObjectTypes, IModuleProjectSwitchListenerManager projectSwitchListenerManager) {
        assert (projectSwitchListenerManager != null) : "Workbench facade must not be null.";
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
        this.projectSwitchListenerManager = projectSwitchListenerManager;
        this.operationalMode = 2;
        this.moduleID = moduleID;
        this.moduleDataName = moduleSpecification.getModuleDataName();
        this.moduleUISpecification = moduleSpecification.getModuleUISpecification();
        this.moduleDataSpecification = moduleSpecification.getModuleDataSpecification();
        this.relevantObjectTypes = relevantObjectTypes;
    }

    public GenericModuleFilters(String moduleID, ModuleSpecification moduleSpecification, IModelController model) {
        assert (model != null) : "Model must not be null.";
        this.model = model;
        this.operationalMode = 1;
        this.moduleID = moduleID;
        this.moduleDataName = moduleSpecification.getModuleDataName();
        this.moduleUISpecification = moduleSpecification.getModuleUISpecification();
        this.moduleDataSpecification = moduleSpecification.getModuleDataSpecification();
        this.relevantObjectTypes = null;
    }

    public String getFilterTitle() {
        return Messages.getString("GenericModuleFilters.FilterTitle");
    }

    public String getFilterDescription() {
        return String.valueOf(Messages.getString("GenericModuleFilters.FilterDescription")) + new LabelProvider(this.moduleDataName).getLabel(Locale.getDefault());
    }

    public List<IFilterItem> createFilters(boolean selectAncestorsInTreeFiltersAutomatically) {
        ArrayList<IFilterItem> filterItems = new ArrayList<IFilterItem>();
        for (Filters filterSpec : this.moduleUISpecification.getFiltersList()) {
            if (this.relevantObjectTypes != null && !this.relevantObjectTypes.contains(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, filterSpec.getObjectTypeID()))) continue;
            ObjectType objectType = this.moduleDataSpecification.getObjectType(filterSpec.getObjectTypeID());
            final String objectsCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, filterSpec.getObjectTypeID());
            if (filterSpec.getFilterType().equals("attribute-filters")) {
                if (!objectType.isDisableObjectTypeCategories()) {
                    filterItems.add(AttributeUIHelper.getObjectTypeCategoryFilterItem(this.moduleID, objectType, this.operationalMode, this.model, this.projectSwitchListenerManager));
                }
                for (Attribute attribute : objectType.getAttributeList()) {
                    CalculatedAttribute cAttribute;
                    IFilterItem filterItem;
                    if (attribute instanceof IDAttribute) {
                        IDAttribute idAttribute = (IDAttribute)attribute;
                        filterItem = AttributeUIHelper.getFilterItem("datatype_mda_string_single", this.moduleID, objectType, idAttribute.getAttributeID());
                        if (filterItem == null) continue;
                        filterItems.add(filterItem);
                        continue;
                    }
                    if (attribute instanceof SimpleAttribute) {
                        SimpleAttribute sAttribute = (SimpleAttribute)attribute;
                        filterItem = AttributeUIHelper.getFilterItem(sAttribute.getAttributeDataType(), this.moduleID, objectType, sAttribute.getAttributeID());
                        if (filterItem == null) continue;
                        filterItems.add(filterItem);
                        continue;
                    }
                    if (attribute instanceof EnumerationAttribute) {
                        EnumerationAttribute eAttribute = (EnumerationAttribute)attribute;
                        IModuleDataAttributeDiscrete dummyAttribute = AttributeHelper.createModuleDataAttributeDiscrete(eAttribute, this.moduleID);
                        filterItems.add(AttributeUIHelper.getEnumerationAttributeFilterItem(this.moduleID, objectType, eAttribute.getAttributeID(), Arrays.asList(dummyAttribute.getValueRange())));
                        continue;
                    }
                    if (attribute instanceof LinkedModuleDataAttribute) {
                        LinkedModuleDataAttribute lAttribute = (LinkedModuleDataAttribute)attribute;
                        filterItems.add(AttributeUIHelper.getLinkedModuleDataAttributeFilterItem(this.moduleID, objectType, lAttribute.getAttributeID(), this.operationalMode, this.model, this.projectSwitchListenerManager));
                        continue;
                    }
                    if (attribute instanceof LinkedFrameDataAttribute) {
                        LinkedFrameDataAttribute lfAttribute = (LinkedFrameDataAttribute)attribute;
                        filterItems.add(AttributeUIHelper.getLinkedFrameDataAttributeFilterItem(this.moduleID, objectType, lfAttribute.getAttributeID(), this.operationalMode, this.model, this.projectSwitchListenerManager));
                        continue;
                    }
                    if (!(attribute instanceof CalculatedAttribute) || (filterItem = AttributeUIHelper.getFilterItem(AttributeHelper.getDataTypeOfCalculatedAttribute((cAttribute = (CalculatedAttribute)attribute).getCalculationTypeID()), this.moduleID, objectType, cAttribute.getAttributeID())) == null) continue;
                    filterItems.add(filterItem);
                }
                String creationDateFilterName = FilterHelper.getFilterName((String)new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault()), (String)AbstractModuleData.CDATE_NAME);
                final String creationDateFilterID = String.valueOf(objectsCockpitTypeID) + "." + "abstractmoduledata_creationDate";
                filterItems.add((IFilterItem)new DateFilterItem(creationDateFilterName, new AbstractDateValuesFilter(){

                    protected Timestamp getDateAttribute(Object element) {
                        return ((ModuleDataAttributeTimestamp)((GenericModuleData)((Object)element)).getAttribute("abstractmoduledata_creationDate")).getValueAsTimeStamp();
                    }

                    public String getFilterID() {
                        return creationDateFilterID;
                    }

                    protected boolean isValidObjectType(Object element) {
                        return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                    }
                }));
                String lastModificationDateFilterName = FilterHelper.getFilterName((String)new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault()), (String)AbstractModuleData.MDATE_NAME);
                final String lastModificationDateFilterID = String.valueOf(objectsCockpitTypeID) + "." + "abstractmoduledata_modificationDate";
                filterItems.add((IFilterItem)new DateFilterItem(lastModificationDateFilterName, new AbstractDateValuesFilter(){

                    protected Timestamp getDateAttribute(Object element) {
                        return ((ModuleDataAttributeTimestamp)((GenericModuleData)((Object)element)).getAttribute("abstractmoduledata_modificationDate")).getValueAsTimeStamp();
                    }

                    public String getFilterID() {
                        return lastModificationDateFilterID;
                    }

                    protected boolean isValidObjectType(Object element) {
                        return element instanceof GenericModuleData && ((GenericModuleData)((Object)element)).getTypeID().equals(objectsCockpitTypeID);
                    }
                }));
                continue;
            }
            if (!filterSpec.getFilterType().equals("tree-filter")) continue;
            String filterName = FilterHelper.getFilterName((String)new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault()), null);
            final String filterID = objectsCockpitTypeID;
            AbstractTextValuesFilter filter = new AbstractTextValuesFilter(false){

                protected String getStringAttribute(Object element) {
                    if (!(element instanceof GenericModuleData)) {
                        return null;
                    }
                    GenericModuleData item = (GenericModuleData)((Object)element);
                    while (item != null && !item.getTypeID().equals(objectsCockpitTypeID)) {
                        Filters filterSpecForItem = GenericModuleFilters.this.moduleUISpecification.getFilters(ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID()));
                        if (filterSpecForItem != null && filterSpecForItem.getFilterType() == "tree-filter") {
                            return null;
                        }
                        item = (GenericModuleData)GenericModuleFilters.this.model.getParent((IModuleData)item);
                    }
                    return item != null ? item.getUID() : null;
                }

                public String getFilterID() {
                    return filterID;
                }

                protected boolean isValidObjectType(Object element) {
                    if (!(element instanceof GenericModuleData)) {
                        return false;
                    }
                    GenericModuleData item = (GenericModuleData)((Object)element);
                    if (!item.getGenericModuleID().equals(GenericModuleFilters.this.moduleID)) {
                        return false;
                    }
                    ObjectType objectTypeSpec = GenericModuleFilters.this.moduleDataSpecification.getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID()));
                    for (ParentType parentType : objectTypeSpec.getParentTypeList()) {
                        if (!parentType.getParentObjectTypeID().equals("noparent")) continue;
                        return false;
                    }
                    while (item != null && !item.getTypeID().equals(objectsCockpitTypeID)) {
                        Filters filterSpecForItem = GenericModuleFilters.this.moduleUISpecification.getFilters(ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID()));
                        if (filterSpecForItem != null && filterSpecForItem.getFilterType().equals("tree-filter")) {
                            return false;
                        }
                        item = (GenericModuleData)GenericModuleFilters.this.model.getParent((IModuleData)item);
                    }
                    return true;
                }
            };
            if (this.operationalMode == 2) {
                filterItems.add((IFilterItem)new ModuleDataTreeListFilterItem(filterName, objectsCockpitTypeID, this.projectSwitchListenerManager, (IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), filter, selectAncestorsInTreeFiltersAutomatically));
                continue;
            }
            if (this.operationalMode != 1) continue;
            filterItems.add((IFilterItem)new ModuleDataTreeListFilterItem(filterName, objectsCockpitTypeID, this.model, filter, selectAncestorsInTreeFiltersAutomatically));
        }
        return filterItems;
    }

    public void projectSwitched(String projectUID) {
        this.model = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
    }

    public void dispose() {
        if (this.projectSwitchListenerManager != null) {
            this.projectSwitchListenerManager.deregisterProjectSwitchListener((IModuleProjectSwitchListener)this);
        }
        this.model = null;
    }
}

