/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.dnd;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dnd.AbstractEditorDropListener;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Collection;
import java.util.Map;

public class EditorDropListener
extends AbstractEditorDropListener {
    private static final int defaultMode = 4;
    private final String moduleID;
    private final GMLinkTypeHelper_Shared linkTypeHelper;
    private final Map<String, String> map_linkableObjectCockpitType_cardinality;

    public EditorDropListener(String moduleID, Map<String, String> map_linkableObjectCockpitType_cardinality) {
        this.moduleID = moduleID;
        this.linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(moduleID);
        this.map_linkableObjectCockpitType_cardinality = map_linkableObjectCockpitType_cardinality;
    }

    public int isDropOnUniqueElementAllowed(IUniqueElement uniqueElement, int modesAllowed, int modeWished, Object payLoad) {
        boolean cardinalityOk = true;
        if (payLoad != null && payLoad instanceof Collection) {
            for (Object payloadItem : (Collection)payLoad) {
                GenericModuleData item = (GenericModuleData)((Object)payloadItem);
                String cardinality = this.map_linkableObjectCockpitType_cardinality.get(item.getTypeID());
                Collection<? extends EOLink> existingLinks = this.getExistingLinksForModuleDataItem((Object)item);
                if (cardinality.equals("none-or-one")) {
                    if (existingLinks.size() != 1) continue;
                    cardinalityOk = false;
                } else {
                    for (EOLink eOLink : existingLinks) {
                        String linkableObjectsUID = eOLink.getLinkableObjectUID();
                        String uniqueElementsUID = uniqueElement.getUID();
                        if (!uniqueElementsUID.equals(linkableObjectsUID)) continue;
                        cardinalityOk = false;
                        break;
                    }
                    if (cardinalityOk) {
                        continue;
                    }
                }
                break;
            }
        } else {
            cardinalityOk = false;
        }
        int mode = cardinalityOk ? 4 : 0;
        return mode & modesAllowed;
    }

    protected void createLink(final IUniqueElement uniqueElement, Object moduleDataItem) {
        final GenericModuleData element = (GenericModuleData)((Object)moduleDataItem);
        final IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(element.getProjectUID());
        modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                modelController.createLink(uniqueElement.getUID(), (IModuleData)element, EditorDropListener.this.linkTypeHelper.getModelElementLinkTypeID(element.getTypeID()));
            }
        });
    }

    protected Collection<? extends EOLink> getExistingLinksForModuleDataItem(Object moduleDataItem) {
        GenericModuleData item = (GenericModuleData)((Object)moduleDataItem);
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
        return modelController.getLinksForModuleDataItem((IModuleData)item, this.linkTypeHelper.getModelElementLinkTypeID(item.getTypeID()));
    }
}

