/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.detailsviewprovider;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.CockpitProjectDataSelector;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DataViewDragSourceListener;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.gui.AttributeUIHelper;
import com.arcway.cockpit.genericmodule.client.gui.dnd.EditorDragSupport;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.AdditionalInformationElement;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.AdditionalInformationSection;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.AllChildrenEntry;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ChildrenOfTypeEntry;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CrossModuleRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.DetailsPageLayout;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ExternalCMLRelationEntry;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.FixAttributeEntry;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.FixAttributesSection;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentEntry;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationEntry;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.messages.AttributeHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.CrossModuleLinkManager;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.ICrossModuleLinkType;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.gui.detailsviewprovider.ModuleDetailsProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.lib.eclipse.transfer.dnd.IDragSourceListener;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;

public class DetailsProvider
extends ModuleDetailsProvider
implements IExecutableExtension {
    private static final String LISTENTRY_SEPARATOR = "listentry-separator";
    private String moduleID;
    private ModuleDataSpecification moduleDataSpecification;
    private ObjectType objectTypeSpecification;
    private List<Object> detailsContentDescriptions_fixAttributesSegment;
    private List<Object> detailsContentDescriptions_additionalInformationSegment;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.moduleDataSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID).getModuleDataSpecification();
        this.objectTypeSpecification = (ObjectType)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        DetailsPageLayout layout = SpecificationProvider.getDetailsPageLayoutForObjectType(SpecificationProvider.getDefault().getModuleSpecification(this.moduleID), this.objectTypeSpecification);
        this.detailsContentDescriptions_fixAttributesSegment = new ArrayList<Object>();
        if (layout != null && layout.getFixAttributesSegment() != null) {
            boolean isFirstSection = true;
            for (FixAttributesSection fixAttributesSection : layout.getFixAttributesSegment().getFixAttributesSectionList()) {
                if (isFirstSection) {
                    isFirstSection = false;
                } else {
                    this.detailsContentDescriptions_fixAttributesSegment.add(LISTENTRY_SEPARATOR);
                }
                for (FixAttributeEntry attributeEntry : fixAttributesSection.getFixAttributeEntryList()) {
                    Attribute attribute = this.objectTypeSpecification.getAttribute(attributeEntry.getIDOfAttribute());
                    this.detailsContentDescriptions_fixAttributesSegment.add(attribute);
                }
            }
        } else {
            for (Attribute attribute : this.objectTypeSpecification.getAttributeList()) {
                this.detailsContentDescriptions_fixAttributesSegment.add(attribute);
            }
        }
        this.detailsContentDescriptions_additionalInformationSegment = new ArrayList<Object>();
        if (layout != null && layout.getAdditionalInformationSegment() != null) {
            GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
            boolean bl = true;
            for (AdditionalInformationSection additionalInformationSection : layout.getAdditionalInformationSegment().getAdditionalInformationSectionList()) {
                boolean bl2;
                if (bl2) {
                    bl2 = false;
                } else {
                    this.detailsContentDescriptions_additionalInformationSegment.add(LISTENTRY_SEPARATOR);
                }
                for (AdditionalInformationElement element : additionalInformationSection.getAdditionalInformationElementList()) {
                    if (element instanceof RelationEntry || element instanceof ExternalCMLRelationEntry) {
                        AbstractModuleSpecificationPart entry;
                        String linkTypeID = null;
                        int participantIndex = 0;
                        String participantRoleName = null;
                        boolean isCrossModuleLink = false;
                        String direction = "";
                        if (element instanceof RelationEntry) {
                            entry = (RelationEntry)element;
                            direction = ((RelationEntry)entry).getDirection();
                        } else if (element instanceof ExternalCMLRelationEntry) {
                            entry = (ExternalCMLRelationEntry)element;
                            direction = ((ExternalCMLRelationEntry)entry).getDirection();
                        }
                        participantIndex = direction.equals("referring-items") ? 0 : 1;
                        if (element instanceof RelationEntry) {
                            entry = (RelationEntry)element;
                            RelationType relation = this.moduleDataSpecification.getRelationType(((RelationEntry)entry).getIDOfRelation());
                            String participantRoleNameLocalisationCode = "";
                            if (relation instanceof ModuleDataRelationType) {
                                linkTypeID = linkTypeHelper.getRelationLinkTypeID(((ModuleDataRelationType)relation).getRelationTypeID());
                                participantRoleNameLocalisationCode = ((ModuleDataRelationType)relation).getMDRelationParticipant(participantIndex).getParticipantRoleName();
                                participantRoleName = new LabelProvider(participantRoleNameLocalisationCode).getLabel(Locale.getDefault());
                                isCrossModuleLink = false;
                            } else if (relation instanceof CrossModuleRelationType) {
                                linkTypeID = linkTypeHelper.getCrossModuleLinkTypeID(((CrossModuleRelationType)relation).getRelationTypeID());
                                isCrossModuleLink = true;
                            }
                        } else if (element instanceof ExternalCMLRelationEntry) {
                            entry = (ExternalCMLRelationEntry)element;
                            GMLinkTypeHelper_Shared linkTypeHelperOfExternalModule = GMLinkTypeHelper_Shared.getDefault(((ExternalCMLRelationEntry)entry).getRelationModule());
                            if (linkTypeHelperOfExternalModule == null) continue;
                            linkTypeID = linkTypeHelperOfExternalModule.getCrossModuleLinkTypeID(((ExternalCMLRelationEntry)entry).getIDOfRelation());
                            isCrossModuleLink = true;
                        }
                        this.detailsContentDescriptions_additionalInformationSegment.add(new DetailsContentDescriptionForRelation(participantRoleName, linkTypeID, participantIndex, isCrossModuleLink));
                        continue;
                    }
                    if (element instanceof ParentEntry) {
                        this.detailsContentDescriptions_additionalInformationSegment.add(element);
                        continue;
                    }
                    if (!(element instanceof AllChildrenEntry) && !(element instanceof ChildrenOfTypeEntry)) continue;
                    this.detailsContentDescriptions_additionalInformationSegment.add(element);
                }
            }
        }
    }

    public String getID() {
        return "detailsprovider.genericmodule." + this.moduleID + "." + this.objectTypeSpecification.getObjectTypeID();
    }

    public IAction[] getToolbarActions() {
        return null;
    }

    protected List<DetailsElement> getTitleDetailsElements_internal(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof GenericModuleData) : "element to be shown must be of type GenericModuleData";
        GenericModuleData item = (GenericModuleData)itemToShow;
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
        EditorDragSupport dragSupport = new EditorDragSupport(this.moduleID, this.moduleDataSpecification, modelController);
        DataViewDragSourceListener dragListener = new DataViewDragSourceListener(DetailsProvider.createSelectionProvider((Object)itemToShow), new DragSource[]{dragSupport.getDragSource()});
        return Collections.singletonList(new DetailsElementTitle(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".title", new DetailsValueTitle(item.getDisplayRepresentation(), this.getTitleImage((ICockpitProjectData)item), (IDragSourceListener)dragListener)));
    }

    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof GenericModuleData) : "element to be shown must be of type GenericModuleData";
        GenericModuleData item = (GenericModuleData)itemToShow;
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>(this.detailsContentDescriptions_fixAttributesSegment.size());
        int index = 1;
        for (Object contentDescription : this.detailsContentDescriptions_fixAttributesSegment) {
            AbstractModuleSpecificationPart attribute;
            if (contentDescription.equals(LISTENTRY_SEPARATOR)) {
                detailsElements.add((DetailsElement)new DetailsElementSeparator(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".fas." + index + ".sep", 8, new DetailsValueSeparator()));
            } else if (contentDescription instanceof IDAttribute) {
                attribute = (IDAttribute)contentDescription;
                detailsElements.add(AttributeUIHelper.getDetailsElement(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".fas." + index + "." + ((IDAttribute)attribute).getAttributeID(), "datatype_mda_string_single", new LabelProvider(((IDAttribute)attribute).getAttributeName()).getLabel(Locale.getDefault()), item.getAttribute(((IDAttribute)attribute).getAttributeID()), this.getContainingDetailsView()));
            } else if (contentDescription instanceof SimpleAttribute) {
                attribute = (SimpleAttribute)contentDescription;
                detailsElements.add(AttributeUIHelper.getDetailsElement(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".fas." + index + "." + ((SimpleAttribute)attribute).getAttributeID(), ((SimpleAttribute)attribute).getAttributeDataType(), new LabelProvider(((SimpleAttribute)attribute).getAttributeName()).getLabel(Locale.getDefault()), item.getAttribute(((SimpleAttribute)attribute).getAttributeID()), this.getContainingDetailsView()));
            } else if (contentDescription instanceof EnumerationAttribute) {
                attribute = (EnumerationAttribute)contentDescription;
                detailsElements.add(AttributeUIHelper.getDetailsElement(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".fas." + index + "." + ((EnumerationAttribute)attribute).getAttributeID(), "datatype_meta_enumeration", new LabelProvider(((EnumerationAttribute)attribute).getAttributeName()).getLabel(Locale.getDefault()), item.getAttribute(((EnumerationAttribute)attribute).getAttributeID()), this.getContainingDetailsView()));
            } else if (contentDescription instanceof LinkedModuleDataAttribute) {
                attribute = (LinkedModuleDataAttribute)contentDescription;
                GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
                String linkTypeID = linkTypeHelper.getAttributeLinkTypeID(item.getTypeID(), ((LinkedModuleDataAttribute)attribute).getAttributeID());
                Collection linkedAttributeCollection = modelController.getLinkableObjects((IModuleData)item, linkTypeID);
                GenericModuleData linkedAttribute = null;
                if (linkedAttributeCollection.size() == 1) {
                    linkedAttribute = (GenericModuleData)((Object)linkedAttributeCollection.iterator().next());
                } else assert (linkedAttributeCollection.isEmpty());
                detailsElements.add(AttributeUIHelper.getLinkedModuleDataAttributeDetailsElement(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".fas." + index + "." + ((LinkedModuleDataAttribute)attribute).getAttributeID(), new LabelProvider(((LinkedModuleDataAttribute)attribute).getAttributeName()).getLabel(Locale.getDefault()), (IModuleData)linkedAttribute));
            } else if (contentDescription instanceof LinkedFrameDataAttribute) {
                String labelText;
                attribute = (LinkedFrameDataAttribute)contentDescription;
                if (!this.isForHistoryViewer()) {
                    IExpiringFrontendLabel label = modelController.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem((IModuleData)item, ((LinkedFrameDataAttribute)attribute).getAttributeID());
                    labelText = label != null && label.getText() != null ? label.getText() : "";
                } else {
                    Collection linkedFrameItemCollection = modelController.getLinkableObjects((IModuleData)item, GMLinkTypeHelper_Shared.getDefault(this.moduleID).getAttributeLinkTypeID(item.getTypeID(), ((LinkedFrameDataAttribute)attribute).getAttributeID()));
                    if (!linkedFrameItemCollection.isEmpty()) {
                        assert (linkedFrameItemCollection.size() == 1);
                        ICockpitProjectData linkedFrameItem = (ICockpitProjectData)linkedFrameItemCollection.iterator().next();
                        if (linkedFrameItem != null) {
                            IRepositoryObjectReference linkedFrameItemSample = modelController.getPlatformAccessAgent().getFrameDataItem(linkedFrameItem.getTypeID(), linkedFrameItem.getUID());
                            IExpiringFrontendLabel label = modelController.getPlatformAccessAgent().getLabelForPlatformObject(linkedFrameItemSample, modelController.getProjectLanguage());
                            labelText = label != null ? label.getText() : "";
                        } else {
                            labelText = com.arcway.cockpit.modulelib2.client.Messages.getString((String)"HistoryViewer.FrameItemDoesNotExistAnymore");
                        }
                    } else {
                        labelText = "";
                    }
                }
                detailsElements.add(AttributeUIHelper.getLinkedFrameDataAttributeDetailsElement(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".fas." + index + "." + ((LinkedFrameDataAttribute)attribute).getAttributeID(), new LabelProvider(((LinkedFrameDataAttribute)attribute).getAttributeName()).getLabel(Locale.getDefault()), labelText));
            } else if (contentDescription instanceof CalculatedAttribute) {
                attribute = (CalculatedAttribute)contentDescription;
                detailsElements.add(AttributeUIHelper.getDetailsElement(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".fas." + index + "." + ((CalculatedAttribute)attribute).getAttributeID(), AttributeHelper.getDataTypeOfCalculatedAttribute(((CalculatedAttribute)attribute).getCalculationTypeID()), new LabelProvider(((CalculatedAttribute)attribute).getAttributeName()).getLabel(Locale.getDefault()), item.getAttribute(((CalculatedAttribute)attribute).getAttributeID()), this.getContainingDetailsView()));
            }
            ++index;
        }
        return detailsElements;
    }

    protected List<DetailsElement> getTypeSpecificAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof GenericModuleData) : "element to be shown must be of type GenericModuleData";
        GenericModuleData item = (GenericModuleData)itemToShow;
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>(this.detailsContentDescriptions_additionalInformationSegment.size());
        boolean lastElementWasSeparator = true;
        int index = 1;
        for (Object contentDescription : this.detailsContentDescriptions_additionalInformationSegment) {
            String label;
            if (contentDescription.equals(LISTENTRY_SEPARATOR)) {
                if (!lastElementWasSeparator) {
                    detailsElements.add((DetailsElement)new DetailsElementSeparator(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".ais." + index + ".sep", 8, new DetailsValueSeparator()));
                    lastElementWasSeparator = true;
                }
            } else if (contentDescription instanceof DetailsContentDescriptionForRelation) {
                CrossModuleLinkManager crossModuleLinkManager;
                DetailsContentDescriptionForRelation relationContentDescription = (DetailsContentDescriptionForRelation)contentDescription;
                String linkTypeID = relationContentDescription.linkTypeID;
                List<IModuleData> linkedItems = Collections.emptyList();
                if (relationContentDescription.contributionType == 0) {
                    if (!relationContentDescription.isCrossModuleLinkType) {
                        linkedItems = new ArrayList<IModuleData>(CollectionUtils.getTypedCollection((Collection)modelController.getModuleData((IModuleData)item, linkTypeID), IModuleData.class));
                    } else {
                        crossModuleLinkManager = CrossModuleLinkManager.getInstance((String)item.getProjectUID());
                        if (crossModuleLinkManager.isLinkTypeRegistered(linkTypeID)) {
                            linkedItems = new ArrayList<IModuleData>(crossModuleLinkManager.getModuleDataItems((IModuleData)item, linkTypeID));
                        }
                    }
                } else if (relationContentDescription.contributionType == 1) {
                    if (!relationContentDescription.isCrossModuleLinkType) {
                        linkedItems = new ArrayList<IModuleData>(CollectionUtils.getTypedCollection((Collection)modelController.getLinkableObjects((IModuleData)item, linkTypeID), IModuleData.class));
                    } else {
                        crossModuleLinkManager = CrossModuleLinkManager.getInstance((String)item.getProjectUID());
                        if (crossModuleLinkManager.isLinkTypeRegistered(linkTypeID)) {
                            linkedItems = new ArrayList<IModuleData>(CrossModuleLinkManager.getInstance((String)item.getProjectUID()).getLinkableObjects((IModuleData)item, linkTypeID));
                        }
                    }
                }
                if (!linkedItems.isEmpty()) {
                    Collections.sort(linkedItems, new Comparator<IModuleData>(){

                        @Override
                        public int compare(IModuleData o1, IModuleData o2) {
                            int typeOrder = o1.getTypeID().compareTo(o2.getTypeID());
                            if (typeOrder != 0) {
                                return typeOrder;
                            }
                            return o1.getDisplayRepresentation().compareTo(o2.getDisplayRepresentation());
                        }
                    });
                    DetailsValueList selectableList = new DetailsValueList();
                    for (IModuleData linkedItem : linkedItems) {
                        this.addDefaultListElementToDetailsValueListForModuleDataItem(selectableList, linkedItem);
                    }
                    label = "";
                    if (relationContentDescription.isCrossModuleLinkType) {
                        ICrossModuleLinkType linkType = CrossModuleLinkManager.getInstance((String)item.getProjectUID()).getLinkTypeDescription(linkTypeID);
                        label = relationContentDescription.contributionType == 0 ? linkType.getModuleDataContributionName().getLabel(Locale.getDefault()) : linkType.getLinkableObjectContributionName().getLabel(Locale.getDefault());
                    } else {
                        label = relationContentDescription.label;
                    }
                    detailsElements.add((DetailsElement)new DetailsElementList(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".ais." + index + "." + linkTypeID + "." + relationContentDescription.contributionType, label, selectableList));
                    lastElementWasSeparator = false;
                }
            } else if (contentDescription instanceof ParentEntry) {
                ParentEntry parentEntry = (ParentEntry)contentDescription;
                IModuleData parent = modelController.getParent((IModuleData)item);
                if (parent != null) {
                    String label2 = null;
                    label2 = parentEntry.getLabel() != null && parentEntry.getLabel().length() > 0 ? new LabelProvider(parentEntry.getLabel()).getLabel(Locale.getDefault()) : Messages.getString("DetailsProvider.ParentEntry.DefaultLabel");
                    DetailsValueList detailsValue = new DetailsValueList();
                    this.addDefaultListElementToDetailsValueListForModuleDataItem(detailsValue, parent);
                    detailsElements.add((DetailsElement)new DetailsElementList(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".ais." + index + ".parent", label2, detailsValue));
                    lastElementWasSeparator = false;
                }
            } else if (contentDescription instanceof AllChildrenEntry || contentDescription instanceof ChildrenOfTypeEntry) {
                AbstractModuleSpecificationPart entry;
                String localisationCode = null;
                String defaultLabel = null;
                ArrayList relevantChildren = new ArrayList();
                String idExtension = null;
                if (contentDescription instanceof AllChildrenEntry) {
                    entry = (AllChildrenEntry)contentDescription;
                    localisationCode = ((AllChildrenEntry)entry).getLabel();
                    defaultLabel = Messages.getString("DetailsProvider.AllChildrenEntry.DefaultLabel");
                    relevantChildren.addAll(modelController.getChildren((IModuleData)item));
                    idExtension = "allchildren";
                } else if (contentDescription instanceof ChildrenOfTypeEntry) {
                    entry = (ChildrenOfTypeEntry)contentDescription;
                    localisationCode = ((ChildrenOfTypeEntry)entry).getLabel();
                    String objectTypeName = new LabelProvider(this.moduleDataSpecification.getObjectType(((ChildrenOfTypeEntry)entry).getObjectTypeID()).getObjectTypeName()).getLabel(Locale.getDefault());
                    defaultLabel = NLS.bind((String)Messages.getString("DetailsProvider.ChildrenOfTypeEntry.DefaultLabel"), (Object)objectTypeName);
                    relevantChildren.addAll(modelController.getChildren((IModuleData)item, ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, ((ChildrenOfTypeEntry)entry).getObjectTypeID())));
                    idExtension = "childrenoftype." + ((ChildrenOfTypeEntry)entry).getObjectTypeID();
                }
                if (!relevantChildren.isEmpty()) {
                    label = null;
                    label = localisationCode != null && localisationCode.length() > 0 ? new LabelProvider(localisationCode).getLabel(Locale.getDefault()) : defaultLabel;
                    DetailsValueList detailsValue = new DetailsValueList();
                    Comparator naturalOrderComparator = StandardTreeDataViewSorter.getComparatorForNaturalOrder((IModelController)modelController);
                    Collections.sort(relevantChildren, naturalOrderComparator);
                    for (IModuleData child : relevantChildren) {
                        this.addDefaultListElementToDetailsValueListForModuleDataItem(detailsValue, child);
                    }
                    detailsElements.add((DetailsElement)new DetailsElementList(String.valueOf(this.moduleID) + "." + this.objectTypeSpecification.getObjectTypeID() + ".ais." + index + "." + idExtension, label, detailsValue));
                    lastElementWasSeparator = false;
                }
            }
            ++index;
        }
        if (lastElementWasSeparator && !detailsElements.isEmpty()) {
            detailsElements.remove(detailsElements.size() - 1);
        }
        return detailsElements;
    }

    private void addDefaultListElementToDetailsValueListForModuleDataItem(DetailsValueList detailsValue, IModuleData item) {
        detailsValue.addListElement(item.getDisplayRepresentation(), item.getStatusDependentIcon().getImage(), new ListEntryParameter((Runnable)new CockpitProjectDataSelector((ICockpitProjectData)item, this.getContainingDetailsView()), null, null));
    }

    public boolean canBeDisplayed(ICockpitProjectData elementToShow) {
        if (!(elementToShow instanceof GenericModuleData)) {
            return false;
        }
        GenericModuleData item = (GenericModuleData)elementToShow;
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
        return modelController.itemExists(item.getTypeID(), item.getUID());
    }

    public Collection<Class<?>> getDataTypesThatTriggerRefresh() {
        Collection types = super.getDataTypesThatTriggerRefresh();
        types.addAll(Arrays.asList(GenericModuleData.class));
        return types;
    }

    protected IModelController getModelController(String projectUID) {
        return GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
    }

    private static class DetailsContentDescriptionForRelation {
        String label;
        String linkTypeID;
        int contributionType;
        boolean isCrossModuleLinkType;

        public DetailsContentDescriptionForRelation(String label, String linkTypeID, int contributionType, boolean isCrossModuleLinkType) {
            this.label = label;
            this.linkTypeID = linkTypeID;
            this.contributionType = contributionType;
            this.isCrossModuleLinkType = isCrossModuleLinkType;
        }
    }
}

