/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMModifyItems;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.actions.GenericModuleActionDelegate;
import com.arcway.cockpit.genericmodule.client.gui.actions.ParentSelectionDialogueContentProvider;
import com.arcway.cockpit.genericmodule.client.gui.actions.ParentSelectionDialogueLabelProvider;
import com.arcway.cockpit.genericmodule.client.gui.actions.ParentSelectionDialogueSelectionValidator;
import com.arcway.cockpit.genericmodule.client.gui.dataview.DataView;
import com.arcway.cockpit.genericmodule.client.gui.dataview.ViewIDCreator;
import com.arcway.cockpit.genericmodule.client.gui.dialogues.PropertiesSupport;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.TableTreeDataView;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.itemeditors.ItemEditorManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ActionDelegateNewItemViaModelElement
extends GenericModuleActionDelegate
implements IExecutableExtension {
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private ModelElementLinkType modelElementLinkSpec;
    private ObjectType linkedObjectType;
    private PropertiesSupport propertiesSupport;
    private IModelController modelController;
    private ArrayList<IUniqueElement> selectedModelElements;
    private boolean enablement = false;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        this.modelElementLinkSpec = (ModelElementLinkType)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        this.linkedObjectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(this.modelElementLinkSpec.getLinkedObjectTypeID());
        this.propertiesSupport = new PropertiesSupport();
        this.propertiesSupport.construct(this.moduleID, this.linkedObjectType);
    }

    public boolean determineEnabledStatus(ISelection selection) {
        this.selectedModelElements = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                if (!(selectedObject instanceof IUniqueElement)) continue;
                this.selectedModelElements.add((IUniqueElement)selectedObject);
            }
            if (this.selectedModelElements.size() > 0) {
                String projectUid = this.selectedModelElements.get(0).getProjectUID();
                this.modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUid);
                this.enablement = true;
            } else {
                this.enablement = false;
            }
        } else {
            this.enablement = false;
        }
        return this.enablement;
    }

    public void run(IAction action) {
        assert (this.modelController != null);
        DataView dataView = null;
        for (TableTreeDataView view : this.moduleSpecification.getModuleUISpecification().getViewListOfType(TableTreeDataView.class)) {
            dataView = (DataView)this.getIssuingPart().getSite().getPage().findView(ViewIDCreator.getViewID(this.moduleID, view));
        }
        ModuleLockManager lockManager = (ModuleLockManager)this.modelController.getLockMgr();
        PermissionManager permissionManager = (PermissionManager)this.modelController.getPermissionMgr();
        ParentSelectionDialogueContentProvider contentProvider = new ParentSelectionDialogueContentProvider(this.modelController, dataView, this.linkedObjectType);
        ParentSelectionDialogueLabelProvider labelProvider = new ParentSelectionDialogueLabelProvider();
        ParentSelectionDialogueSelectionValidator validator = new ParentSelectionDialogueSelectionValidator(this.linkedObjectType, lockManager, permissionManager);
        ElementTreeSelectionDialog parentSelectionDialogue = new ElementTreeSelectionDialog(this.getIssuingShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        parentSelectionDialogue.setValidator((ISelectionStatusValidator)validator);
        parentSelectionDialogue.setAllowMultiple(false);
        parentSelectionDialogue.setDoubleClickSelects(true);
        parentSelectionDialogue.setMessage(Messages.getString("ActionDelegateNewItemViaModelElement.DialogMessage"));
        parentSelectionDialogue.setTitle(Messages.getString("ActionDelegateNewItemViaModelElement.DialogTitle"));
        parentSelectionDialogue.setInput(ParentSelectionDialogueContentProvider.INPUT);
        if (parentSelectionDialogue.open() == 0) {
            ArrayList<String> modelElementUIDs = new ArrayList<String>();
            for (IUniqueElement uniqueElement : this.selectedModelElements) {
                modelElementUIDs.add(uniqueElement.getUID());
            }
            if (parentSelectionDialogue.getFirstResult() != ParentSelectionDialogueContentProvider.ROOT) {
                GenericModuleData newParent = (GenericModuleData)((Object)parentSelectionDialogue.getFirstResult());
                ItemEditorManager.openEditorForCreatingChildItem((IModelController)this.modelController, (String)ModuleIdentification.getModuleIDForPlatform(this.moduleID), (String)ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.linkedObjectType.getObjectTypeID()), (IModuleData)newParent, modelElementUIDs);
            } else {
                ItemEditorManager.openEditorForCreatingRootItem((IModelController)this.modelController, (String)ModuleIdentification.getModuleIDForPlatform(this.moduleID), (String)ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.linkedObjectType.getObjectTypeID()), modelElementUIDs);
            }
        }
    }

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enablement;
    }

    protected <T> boolean determineEnabledStatus(IPropertyChanges<T> changes, Class<T> clazz) {
        return this.enablement;
    }

    @Override
    protected String getModuleID() {
        return this.moduleID;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID);
    }
}

