/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMModifyItems;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.actions.GenericModuleActionDelegate;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.itemeditors.ItemEditorManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ActionDelegateNewChildItem
extends GenericModuleActionDelegate
implements IExecutableExtension {
    private String moduleID;
    private ParentType parentType;
    private ObjectType childObjectType;
    private IModelController modelCtrl;
    private GenericModuleData currentlySelectedItem;
    private boolean enable = false;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        ModuleSpecification specification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        this.parentType = (ParentType)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        this.childObjectType = SpecificationProvider.getObjectTypeForParentType(specification, this.parentType);
    }

    public void run(IAction action) {
        assert (action != null);
        assert (this.currentlySelectedItem != null);
        assert (this.modelCtrl != null);
        ItemEditorManager.openEditorForCreatingChildItem((IModelController)this.modelCtrl, (String)ModuleIdentification.getModuleIDForPlatform(this.moduleID), (String)ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.childObjectType.getObjectTypeID()), (IModuleData)this.currentlySelectedItem, (Collection)Collections.EMPTY_LIST);
    }

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enable;
    }

    public boolean determineEnabledStatus(ISelection selection) {
        this.enable = false;
        if (selection != null) {
            IStructuredSelection selectionContent = (IStructuredSelection)selection;
            String projectUid = ProjectSelectionAnalyser.extractProjectUID((ISelection)selectionContent);
            if (selectionContent.size() == 1 && selectionContent.getFirstElement() instanceof GenericModuleData && projectUid != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUid).isOpened()) {
                this.modelCtrl = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUid);
                this.currentlySelectedItem = (GenericModuleData)((Object)selectionContent.getFirstElement());
                PermissionManager permissionManager = (PermissionManager)this.modelCtrl.getPermissionMgr();
                this.enable = permissionManager.mayCreateChildItemsBelow(this.currentlySelectedItem, this.childObjectType.getObjectTypeID());
            } else {
                this.currentlySelectedItem = null;
                this.enable = false;
            }
        }
        return this.enable;
    }

    protected <T> boolean determineEnabledStatus(IPropertyChanges<T> changes, Class<T> clazz) {
        return this.enable;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID);
    }

    @Override
    protected String getModuleID() {
        return this.moduleID;
    }
}

