/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMModifyItems;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.actions.GenericModuleAction;
import com.arcway.cockpit.genericmodule.client.gui.dialogues.AdministrateAttributeObjectsDialog;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class ActionAdministrateAttributeObjects
extends GenericModuleAction
implements IPropertyChangesListener {
    private final String moduleID;
    private final ObjectType objectType;
    private final Collection<String> linkTypeIDs;
    private IModelController modelController;

    public ActionAdministrateAttributeObjects(String moduleID, ObjectType objectType, Collection<String> linkTypeIDs) {
        this.moduleID = moduleID;
        this.objectType = objectType;
        this.linkTypeIDs = linkTypeIDs;
        this.setEnabled(false);
    }

    public void run() {
        AdministrateAttributeObjectsDialog dialog = new AdministrateAttributeObjectsDialog(this.moduleID, this.objectType, this.linkTypeIDs, this.getContainingShell(), this.modelController);
        dialog.open();
    }

    protected void handleSelectionChanged(IWorkbenchPart workbench, ISelection selection) {
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        if (this.modelController != null) {
            this.setEnabled(this.hasPermission());
        } else {
            this.setEnabled(false);
        }
    }

    protected void handleProjectChanged(String newProjectUID) {
        this.modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(newProjectUID);
        if (this.modelController != null) {
            this.setEnabled(this.hasPermission());
        } else {
            this.setEnabled(false);
        }
    }

    private boolean hasPermission() {
        if (this.modelController != null) {
            PermissionManager permissionMgr = (PermissionManager)this.modelController.getPermissionMgr();
            return permissionMgr.mayAdministrateLinkedModuleDataAttributeValueRange(this.objectType.getObjectTypeID());
        }
        return false;
    }

    @Override
    protected String getModuleID() {
        return this.moduleID;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID);
    }
}

