/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.exceladapter.importer;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.genericmodule.client.exceladapter.importer.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.IconResource;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.ModuleFileSelectionPage;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.eclipse.adapter.excel.ExcelConstants;
import com.arcway.lib.eclipse.gui.dialogs.wizardpages.FileSelectionPage;
import com.arcway.lib.eclipse.ole.excel.util.MSExcelVersionAndSettingsHelper;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

public class ImportWizardContribution
implements IImportWizardContribution {
    private final String moduleID;
    private final ModuleSpecification moduleSpecification;
    private final ObjectType objectTypeSpecification;
    private FileSelectionPage fileSelectionPage;

    public ImportWizardContribution(String moduleID_, ModuleSpecification moduleSpecification_, ObjectType objectType) {
        this.moduleID = moduleID_;
        this.moduleSpecification = moduleSpecification_;
        this.objectTypeSpecification = objectType;
    }

    public String getName() {
        return String.valueOf(Messages.getString("ImportWizardContribution.Name.Pre")) + " " + new LabelProvider(this.objectTypeSpecification.getObjectTypeName()).getLabel(Locale.getDefault()) + " " + Messages.getString("ImportWizardContribution.Name.Post");
    }

    public String getDescription() {
        return String.valueOf(Messages.getString("ImportWizardContribution.Description.Pre")) + " " + new LabelProvider(this.objectTypeSpecification.getObjectTypeName()).getLabel(Locale.getDefault()) + " " + Messages.getString("ImportWizardContribution.Description.InBetween") + " " + new LabelProvider(this.moduleSpecification.getModuleDataName()).getLabel(Locale.getDefault()) + " " + Messages.getString("ImportWizardContribution.Description.Post");
    }

    public ImageDescriptor getImage() {
        if (this.objectTypeSpecification.getObjectTypeIcon() != null && this.objectTypeSpecification.getObjectTypeIcon().length() > 0) {
            return new IconResource(this.moduleID, this.objectTypeSpecification.getObjectTypeIcon()).getImageDescriptor();
        }
        return null;
    }

    public List<IWizardPage> getExporterOrImporterSpecificWizardPages(String configuration) {
        String title = String.valueOf(Messages.getString("ImportWizardContribution.SelectFileWizardPage.Title")) + " " + new LabelProvider(this.objectTypeSpecification.getObjectTypeName()).getLabel(Locale.getDefault());
        String instruction = Messages.getString("ImportWizardContribution.SelectFileWizardPage.Instruction");
        List supportedExtensions = MSExcelVersionAndSettingsHelper.getInstalledVersionOfMSExcel() >= 12 ? ExcelConstants.EXCEL_SUPPORTED_FILE_EXTENSIONS_POST2007 : ExcelConstants.EXCEL_SUPPORTED_FILE_EXTENSIONS_PRE2007;
        this.fileSelectionPage = new ModuleFileSelectionPage(title, instruction, supportedExtensions, true, false, true, "genericmodule.exceladapter.importer.fileselection");
        return Collections.singletonList(this.fileSelectionPage);
    }

    public IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }
}

