/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.lib;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.ILockTypeProvider;
import com.arcway.cockpit.frame.client.project.sequences.ISequencer;
import com.arcway.cockpit.frame.client.project.sequences.ISequencerManager;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.clientadapter.interFace.IParentRelationshipAdapter;
import com.arcway.repository.clientadapter.lib.LockHelper;
import com.arcway.repository.clientadapter.lib.Messages;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractParentRelationshipAdapter
implements IParentRelationshipAdapter {
    private final IFrameProjectAgent projectAgent;
    private final IRepositoryObjectTypeID repositoryParentObjectTypeID;
    private final ICockpitDataType dataTypeForNaturalOrdering;

    public AbstractParentRelationshipAdapter(IFrameProjectAgent projectAgent, IRepositoryObjectTypeID repositoryParentObjectTypeID, ICockpitDataType dataTypeForNaturalOrdering) {
        assert (projectAgent != null);
        assert (repositoryParentObjectTypeID != null);
        this.projectAgent = projectAgent;
        this.repositoryParentObjectTypeID = repositoryParentObjectTypeID;
        this.dataTypeForNaturalOrdering = dataTypeForNaturalOrdering;
    }

    @Override
    public final IRepositoryObjectTypeID getRepositoryParentObjectTypeID() {
        return this.repositoryParentObjectTypeID;
    }

    @Override
    public final CardinalityType getCardinality() {
        return CardinalityType.C0_n_NOT_CONFLICTING;
    }

    @Override
    public final ICockpitDataID getFirstObject(ICockpitDataID parent) {
        ISequencer sequencer = this.retrieveSequencer(parent);
        ICockpitProjectData firstItem = sequencer.getFirstElement();
        if (firstItem != null) {
            return new CockpitDataID(firstItem);
        }
        return null;
    }

    @Override
    public final ICockpitDataID getLastObject(ICockpitDataID parent) {
        ISequencer sequencer = this.retrieveSequencer(parent);
        ICockpitProjectData lastItem = sequencer.getLastElement();
        if (lastItem != null) {
            return new CockpitDataID(lastItem);
        }
        return null;
    }

    @Override
    public final ICockpitDataID getPredecessor(ICockpitDataID successor) {
        ICockpitProjectData successorItem = this.getCockpitProjectData(successor);
        ISequencer sequencer = this.retrieveSequencer(new CockpitDataID(this.getParent(successor)));
        ICockpitProjectData predecessor = sequencer.getPredecessor(successorItem);
        if (predecessor != null) {
            return new CockpitDataID(predecessor);
        }
        return null;
    }

    @Override
    public final ICockpitDataID getSuccessor(ICockpitDataID predecessor) {
        ICockpitProjectData predecessorItem = this.getCockpitProjectData(predecessor);
        ISequencer sequencer = this.retrieveSequencer(new CockpitDataID(this.getParent(predecessor)));
        ICockpitProjectData successor = sequencer.getSuccessor(predecessorItem);
        if (successor != null) {
            return new CockpitDataID(successor);
        }
        return null;
    }

    @Override
    public final void checkPermissionForSequenceModification(ICockpitDataID parent) throws EXCockpitPermissionDenied {
        IClientFunctionLicenseType licenseType = this.getRequiredLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed(licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        ISequencer sequencer = this.retrieveSequencer(parent);
        sequencer.requestSequenceChangePermission(transactionController);
        Collection<IModificationProblem> modificationProblems = transactionController.checkConditions(false, true);
        try {
            ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        }
        catch (EXCockpitLockDenied ePD) {
            throw new RuntimeException(ePD);
        }
    }

    @Override
    public final ILock getLockForSequenceModification(ICockpitDataID parent) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        ISequencer sequencer = this.retrieveSequencer(parent);
        sequencer.requestSequenceChangePermission(transactionController);
        Collection<IModificationProblem> modificationProblems = transactionController.execute();
        ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        return LockHelper.getILock(transactionController);
    }

    @Override
    public final void insertAfter(ICockpitDataID predecessor, ICockpitDataID objectToInsert) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        ICockpitProjectData itemToInsert = this.getCockpitProjectData(objectToInsert);
        ICockpitProjectData parentItem = this.getParent(objectToInsert);
        CockpitDataID parentID = new CockpitDataID(parentItem);
        this.checkPermissionForSequenceModification(parentID);
        this.getLockForSequenceModification(parentID);
        ISequencer sequencer = this.retrieveSequencer(parentID);
        if (predecessor != null) {
            ICockpitProjectData predecessorItem = this.getCockpitProjectData(predecessor);
            sequencer.insertElement(itemToInsert, predecessorItem);
        } else {
            sequencer.setFirstElement(itemToInsert);
        }
        this.dataInserted(parentItem, itemToInsert);
        PropertyChanges propertyChanges = new PropertyChanges(null, (Object)parentItem, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)propertyChanges, parentItem.getClass());
    }

    @Override
    public final void remove(ICockpitDataID objectToRemove) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        ICockpitProjectData itemToRemove = this.getCockpitProjectData(objectToRemove);
        ICockpitProjectData parentItem = this.getParent(objectToRemove);
        CockpitDataID parentID = new CockpitDataID(parentItem);
        this.checkPermissionForSequenceModification(parentID);
        this.getLockForSequenceModification(parentID);
        ISequencer sequencer = this.retrieveSequencer(parentID);
        sequencer.removeElement(itemToRemove);
        this.dataRemoved(parentItem, itemToRemove);
        PropertyChanges propertyChanges = new PropertyChanges(null, (Object)parentItem, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)propertyChanges, parentItem.getClass());
    }

    private ISequencer retrieveSequencer(ICockpitDataID parent) {
        IAttributeOwnerRW parentAttributeOwner = this.getAttributeOwnerRW(parent);
        ISequencerManager sequencerManager = this.projectAgent.getSequencerManager();
        ISequencer sequencer = sequencerManager.getSequencer(parentAttributeOwner, new ArrayList<ILockTypeProvider>(), this.dataTypeForNaturalOrdering);
        return sequencer;
    }

    private ICockpitProjectData getCockpitProjectData(ICockpitDataID cockpitDataID) {
        ICockpitProjectData cockpitProjectData = this.projectAgent.getRepositoryPlattformController().findCockpitProjectData(cockpitDataID);
        Assert.checkArgumentBeeingNotNull((Object)cockpitProjectData);
        return cockpitProjectData;
    }

    private IAttributeOwnerRW getAttributeOwnerRW(ICockpitDataID cockpitDataID) {
        IAttributeOwnerRW attributeOwnerRW = this.projectAgent.getRepositoryPlattformController().findAttributeOwnerRW(cockpitDataID);
        Assert.checkArgumentBeeingNotNull((Object)attributeOwnerRW);
        return attributeOwnerRW;
    }

    private ICockpitProjectData getParent(ICockpitDataID anyChild) {
        ICockpitProjectData cockpitProjectData = this.projectAgent.getRepositoryPlattformController().getParentCockpitProjectData(anyChild);
        Assert.checkArgumentBeeingNotNull((Object)cockpitProjectData);
        return cockpitProjectData;
    }

    protected abstract void dataInserted(ICockpitProjectData var1, ICockpitProjectData var2);

    protected abstract void dataRemoved(ICockpitProjectData var1, ICockpitProjectData var2);

    protected abstract IClientFunctionLicenseType getRequiredLicenseType();
}

