/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.clientadapter.implementation.adapter.CustomPropertyTypeID;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterAttributeSet;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterItem;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterOccurrenceRelation;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.implementation.adapter.project.PlatformAdapterModuleProject;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IOccurrence;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.clientadapter.interFace.IProperty;
import com.arcway.repository.clientadapter.interFace.Occurrence;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsCockpitData;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IOccurringRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.util.Collection;

public class PlatformAdapterProperty
extends PlatformAdapterItem
implements IRepositoryProperty {
    private final PlatformAdapterAttributeSet attributeSet;
    private final IRepositoryPropertyType propertyType;
    private IRepositoryData repositoryDataCache = null;

    public PlatformAdapterProperty(PlatformAdapterAttributeSet attributeSet, IRepositoryPropertyType propertyType) {
        super(attributeSet.getSnapshotImplementation());
        Assert.checkArgumentBeeingNotNull((Object)propertyType);
        Assert.checkArgumentBeeingNotNull((Object)attributeSet);
        this.propertyType = propertyType;
        this.attributeSet = attributeSet;
    }

    public IRepositoryDeclarationItem getType() {
        return this.getPropertyType();
    }

    public IRepositoryPropertyType getPropertyType() {
        return this.propertyType;
    }

    public IRepositoryAttributeSet getAttributeSet() throws EXNotReproducibleSnapshot {
        return this.getAttributeSetImplementation();
    }

    public IRepositoryData getValue() throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        IRepositoryData fetchedRepositoryData = this.fetchRepositoryValue();
        return fetchedRepositoryData;
    }

    private synchronized IRepositoryData fetchRepositoryValue() {
        if (this.repositoryDataCache == null) {
            IRepositoryPropertyTypeID propertyTypeID = this.propertyType.getRepositoryPropertyTypeID();
            if (IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)propertyTypeID, (Object)COTIDsCockpitData.PROPERTY_TYPE_ID_UID)) {
                ICockpitProjectData cockpitData = this.getCockpitData();
                String uidString = cockpitData.getUID();
                try {
                    RDTUID rtduid = (RDTUID)this.propertyType.getDataType();
                    IRepositoryData uncheckedData = rtduid.createData(uidString);
                    rtduid.snapAndCheckData(uncheckedData, PlatformAdapterModuleProject.DATA_TYPE_PARAMETERS_UID);
                    this.repositoryDataCache = uncheckedData;
                }
                catch (AbstractRepositoryDataType.EXValueNotSet e) {
                    throw new RuntimeException(e);
                }
                catch (EXValueInvalid e) {
                    throw new RuntimeException(e);
                }
            } else if (propertyTypeID instanceof CustomPropertyTypeID) {
                CustomPropertyTypeID customPropertyTypeID = (CustomPropertyTypeID)propertyTypeID;
                IAttributeTypeID attributeTypeID = customPropertyTypeID.getAttributeTypeID();
                IAttributeOwnerRW attributeOwner = this.getWorkstationImplementation().findAttributeOwnerRW(this.getObjectImplementation());
                IAttributeType attributeType = attributeOwner.getAttributeType(attributeTypeID);
                IAttribute attribute = attributeOwner.getAttribute(attributeTypeID);
                IAttributeTypeDataType sourceAttributeTypeDataType = attributeType.getDataType();
                IValueRange sourceValueRange = attributeType.getValueRange();
                Object sourceValue = attribute.getAttributeValue();
                IRepositoryDataType targetDataType = this.getDataType();
                IRepositoryDataTypeParameters targetDataTypeParameters = this.getDataTypeParameters();
                this.repositoryDataCache = FrameDataConverter.convertCockpitAttributeToRepositoryData(sourceAttributeTypeDataType, sourceValueRange, sourceValue, targetDataType, targetDataTypeParameters);
            } else {
                IDataManagerAdapter dataManagerAdapter = this.getSnapshotImplementation().getDataManagerAdapter(this.getObjectImplementation().getObjectType());
                ICockpitProjectData cockpitData = this.getCockpitData();
                IProperty property = dataManagerAdapter.getCockpitDataProperty(cockpitData, this.propertyType.getRepositoryPropertyTypeID());
                this.repositoryDataCache = property.getValue();
                Assert.checkArgumentBeeingNotNull((Object)this.repositoryDataCache);
            }
        }
        return this.repositoryDataCache;
    }

    public IRepositoryPropertySample sample() throws EXNotReproducibleSnapshot {
        return new RepositoryPropertySample((IRepositoryProperty)this);
    }

    public String toString() {
        String valueString;
        try {
            valueString = this.getValue().toString();
        }
        catch (EXNotReproducibleSnapshot e) {
            valueString = "NOT REPRODUCIBLE";
        }
        return "Property " + valueString;
    }

    private PlatformAdapterObject getObjectImplementation() {
        return this.getAttributeSetImplementation().getObjectImplementation();
    }

    public ICockpitProjectData getCockpitData() {
        return this.getObjectImplementation().getCockpitData();
    }

    private PlatformAdapterAttributeSet getAttributeSetImplementation() {
        return this.attributeSet;
    }

    private IRepositoryDataType getDataType() {
        return this.getPropertyType().getDataType();
    }

    private IRepositoryDataTypeParameters getDataTypeParameters() {
        return this.getPropertyType().getDataTypeParameters();
    }

    public ICollection_<? extends IOccurrenceRepositoryRelation> getOccurrenceRelations() throws EXNotReproducibleSnapshot {
        ICollection_<PlatformAdapterOccurrenceRelation> occurenceRelations;
        IOccurringRepositoryRelationContributionType occuringRepositoryRelationContributionType = this.getPropertyType().getOccuringRelationContributionType();
        if (occuringRepositoryRelationContributionType != null) {
            IOccurrenceRepositoryRelationType occurenceRelationType = occuringRepositoryRelationContributionType.getRelatedRelationType();
            IOccurrenceManager occurenceManager = this.getOccurrenceManager(occurenceRelationType);
            if (occurenceManager != null) {
                Collection<IOccurrence> occurences = occurenceManager.getOccurrencesOfOccurrenceContainingData(this.getCockpitData().getUID());
                occurenceRelations = this.getSnapshotImplementation().fetchRelations(occurenceRelationType, occurences);
            } else {
                occurenceRelations = new ArrayList_();
            }
        } else {
            occurenceRelations = new ICollection_<PlatformAdapterOccurrenceRelation>();
        }
        return occurenceRelations;
    }

    public IOccurrenceRepositoryRelation getOccurrenceRelation(String occurenceID) throws EXNotReproducibleSnapshot {
        String cockpitDataUIDOfOccurenceContainingData = this.getCockpitData().getUID();
        IOccurrenceRepositoryRelationType occurenceRelationType = this.getPropertyType().getOccuringRelationContributionType().getRelatedRelationType();
        IOccurrenceManager occurenceManager = this.getOccurrenceManager(occurenceRelationType);
        String cockpitDataUIDOfOccuringData = occurenceManager.getCockpitDataUIDOfOccurringData(cockpitDataUIDOfOccurenceContainingData, occurenceID);
        PlatformAdapterOccurrenceRelation occurenceRepositoryRelation = cockpitDataUIDOfOccuringData == null ? null : this.getSnapshotImplementation().fetchRelation(occurenceRelationType, new Occurrence(cockpitDataUIDOfOccuringData, cockpitDataUIDOfOccurenceContainingData, occurenceID));
        return occurenceRepositoryRelation;
    }
}

