/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PlatformAdapterCockpitObjectIterator
implements IRepositoryIterator_IRepositoryObject {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterCockpitObjectIterator.class);
    private final Iterator<? extends IRepositoryObject> javaIterator;
    private boolean isDisposed = false;

    public PlatformAdapterCockpitObjectIterator(Collection<PlatformAdapterObject> objects) {
        this.javaIterator = objects.iterator();
    }

    public PlatformAdapterCockpitObjectIterator(IRepositoryObjectType repObjectType, PlatformAdapterSnapshot snapshot) {
        ICollection_ concreteObjectTypes = repObjectType.getAllInstanciableObjectTypesOfThisType();
        IIterator_ concreteObjectTypesIterator = concreteObjectTypes.iterator();
        ArrayList<PlatformAdapterObject> allObjectsOfWishedType = new ArrayList<PlatformAdapterObject>();
        IIterator_ Iterator2 = concreteObjectTypesIterator;
        while (Iterator2.hasNext()) {
            ICockpitProjectData[] cockpitObjects;
            IDataManagerAdapter dataManagerAdapter = snapshot.getDataManagerAdapter((IRepositoryObjectType)Iterator2.next());
            ICockpitProjectData[] iCockpitProjectDataArray = cockpitObjects = dataManagerAdapter.getAllData();
            int n = cockpitObjects.length;
            int n2 = 0;
            while (n2 < n) {
                ICockpitProjectData element = iCockpitProjectDataArray[n2];
                PlatformAdapterObject paObject = new PlatformAdapterObject(snapshot, dataManagerAdapter, element);
                allObjectsOfWishedType.add(paObject);
                ++n2;
            }
        }
        this.javaIterator = allObjectsOfWishedType.iterator();
    }

    public void abortIteration() {
        Assert.checkState((!this.isDisposed ? 1 : 0) != 0);
        this.isDisposed = true;
    }

    public boolean hasNext() throws EXNotReproducibleSnapshot {
        boolean hasNext;
        if (this.isDisposed) {
            hasNext = false;
        } else {
            hasNext = this.javaIterator.hasNext();
            this.isDisposed |= !hasNext;
        }
        return hasNext;
    }

    public IRepositoryObject nextIRepositoryObject() {
        Assert.checkState((!this.isDisposed ? 1 : 0) != 0);
        return this.javaIterator.next();
    }

    protected void finalize() throws Throwable {
        if (!this.isDisposed) {
            logger.error("Iterator was finalized, but not disposed.");
        }
        super.finalize();
    }
}

