/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.CreatePlanElementDialog;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementCategory;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.constructionelements.PlanElementConstructionElementAssignment;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommand;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElementToOccurrenceMapping;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.NameAndDescriptionAndCommentAndAspectID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FMCAEditorMgrCommandCreatePlanElements
extends FMCAEditorMgrCommand {
    private static final ILogger logger = Logger.getLogger(FMCAEditorMgrCommandCreatePlanElements.class);
    private final Collection<IPlanElement> createdPlanElements;
    private final Collection<PlanElementToOccurrenceMapping> planElementMappingOrNullForNoMapping;
    private IPlanElement elementToName;
    private boolean makeElementtoNameUnique = false;
    private String uniqueMadeElementName;
    private IConstructionElementTypeDescription ceTypeDescription;
    private Collection<String> planElementUIDsOfCreatedUniqueElementOccurrences;
    private ObjectTypeCategoryID categoryID;

    protected FMCAEditorMgrCommandCreatePlanElements(IExternalPlanEditorControllerExtension controller, Collection<IPlanElement> planElements, Collection<PlanElementToOccurrenceMapping> planElementMappingOrNullForNoMapping) {
        super(controller);
        this.createdPlanElements = planElements;
        this.planElementMappingOrNullForNoMapping = planElementMappingOrNullForNoMapping;
    }

    public boolean canExecuteInGeneral() {
        return true;
    }

    public boolean canExecuteNow() {
        boolean canExecute = true;
        Shell parentShell = this.getPlanEditorControllerExtension().getWorkbenchPage().getWorkbenchWindow().getShell();
        String defaultName = null;
        if (this.planElementMappingOrNullForNoMapping == null) {
            for (IPlanElement planElement : this.createdPlanElements) {
                IConstructionElementCategory constructionElementCategory;
                if (planElement.getPlanElementName().trim().equals("")) continue;
                String planElementTypeID = planElement.getPlanElementTypeID();
                PlanElementConstructionElementAssignment assignment = ExtensionMgr.getDefault().getDefaultPlanElementConstructionElementAssignmentsForPlanElement(planElementTypeID);
                if (assignment != null) {
                    constructionElementCategory = assignment;
                } else {
                    IConstructionElementTypeDescription constructionElementTypeDescription = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElementTypeID);
                    constructionElementCategory = constructionElementTypeDescription;
                }
                if (!constructionElementCategory.isOfCategoryAlwaysUnique() && !constructionElementCategory.isOfCategoryPreferredUnique() || this.getMappedOccurence(planElement) != null) continue;
                if (this.elementToName == null) {
                    IConstructionElementTypeDescription td;
                    this.elementToName = planElement;
                    defaultName = planElement.getPlanElementName();
                    this.ceTypeDescription = td = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElement.getPlanElementTypeID());
                    continue;
                }
                this.elementToName = null;
                break;
            }
        }
        if (this.elementToName != null) {
            IUniqueElement existingUE;
            CreatePlanElementDialog createPlanElementDialog = new CreatePlanElementDialog(parentShell, null, this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElements(this.ceTypeDescription.getConstructionElementTypeID()), this.ceTypeDescription, defaultName, this.getProjectAgent(), 1);
            int result = createPlanElementDialog.open();
            if (result == 1) {
                return false;
            }
            this.uniqueMadeElementName = createPlanElementDialog.getElementName();
            this.makeElementtoNameUnique = createPlanElementDialog.makeUnique();
            this.categoryID = null;
            if (createPlanElementDialog.getObjectTypeCategory() != null) {
                this.categoryID = createPlanElementDialog.getObjectTypeCategory().getObjectTypeCategoryID();
            }
            if (this.makeElementtoNameUnique && (existingUE = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(this.uniqueMadeElementName, this.ceTypeDescription.getConstructionElementTypeID())) == null) {
                try {
                    this.getProjectAgent().getPlanAgentUniqueElementManager().requestUniqueElementCreationPermission(this.uniqueMadeElementName, this.ceTypeDescription.getConstructionElementTypeID());
                }
                catch (EXModificationProblem e) {
                    ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(e.getModificationProblems(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    problemsDialog.open();
                    canExecute = false;
                }
            }
        }
        return canExecute;
    }

    public boolean makesPlanRelatedChanges() {
        return !this.createdPlanElements.isEmpty();
    }

    public void execute() {
        final EXModificationProblem[] es = new EXModificationProblem[1];
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                FMCAEditorMgrCommandCreatePlanElements.this.planElementUIDsOfCreatedUniqueElementOccurrences = new ArrayList(FMCAEditorMgrCommandCreatePlanElements.this.createdPlanElements.size());
                if (FMCAEditorMgrCommandCreatePlanElements.this.elementToName != null) {
                    String description;
                    if (FMCAEditorMgrCommandCreatePlanElements.this.makeElementtoNameUnique) {
                        try {
                            IUniqueElement ue = FMCAEditorMgrCommandCreatePlanElements.this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(FMCAEditorMgrCommandCreatePlanElements.this.uniqueMadeElementName, FMCAEditorMgrCommandCreatePlanElements.this.ceTypeDescription.getConstructionElementTypeID());
                            if (ue == null) {
                                ue = FMCAEditorMgrCommandCreatePlanElements.this.getProjectAgent().getPlanAgentUniqueElementManager().createUniqueElement(FMCAEditorMgrCommandCreatePlanElements.this.uniqueMadeElementName, FMCAEditorMgrCommandCreatePlanElements.this.ceTypeDescription.getConstructionElementTypeID(), FMCAEditorMgrCommandCreatePlanElements.this.categoryID);
                            }
                            FMCAEditorMgrCommandCreatePlanElements.this.getProjectAgent().getPlanAgentUniqueElementManager().createUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandCreatePlanElements.this.getPlanEditorControllerExtension(), Collections.singletonMap(FMCAEditorMgrCommandCreatePlanElements.this.elementToName.getPlanElementUID(), ue.getUID()));
                            FMCAEditorMgrCommandCreatePlanElements.this.planElementUIDsOfCreatedUniqueElementOccurrences.add(FMCAEditorMgrCommandCreatePlanElements.this.elementToName.getPlanElementUID());
                            description = ue.getDescription();
                        }
                        catch (EXModificationProblem e) {
                            FMCAEditorMgrCommandCreatePlanElements.this.makeElementtoNameUnique = false;
                            es[0] = e;
                            description = null;
                        }
                    } else {
                        description = null;
                    }
                    FMCAEditorMgrCommandCreatePlanElements.this.getPlanEditorControllerExtension().setPlanElementName(Collections.singletonMap(FMCAEditorMgrCommandCreatePlanElements.this.elementToName.getPlanElementUID(), new NameAndDescriptionAndCommentAndAspectID(FMCAEditorMgrCommandCreatePlanElements.this.uniqueMadeElementName, description, null, null)));
                }
                if (es[0] == null) {
                    HashMap<String, String> planElementUIDs2uniqueElementUID = new HashMap<String, String>(2 * FMCAEditorMgrCommandCreatePlanElements.this.createdPlanElements.size());
                    for (IPlanElement planElement : FMCAEditorMgrCommandCreatePlanElements.this.createdPlanElements) {
                        IUniqueElementOccurrence occurrence;
                        if (planElement == FMCAEditorMgrCommandCreatePlanElements.this.elementToName || (occurrence = FMCAEditorMgrCommandCreatePlanElements.this.getMappedOccurence(planElement)) == null) continue;
                        IUniqueElementOccurrence oc = occurrence;
                        IUniqueElement ue = FMCAEditorMgrCommandCreatePlanElements.this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(oc.getElementUID());
                        planElementUIDs2uniqueElementUID.put(planElement.getPlanElementUID(), ue.getUID());
                    }
                    try {
                        FMCAEditorMgrCommandCreatePlanElements.this.getProjectAgent().getPlanAgentUniqueElementManager().createUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandCreatePlanElements.this.getPlanEditorControllerExtension(), planElementUIDs2uniqueElementUID);
                        FMCAEditorMgrCommandCreatePlanElements.this.planElementUIDsOfCreatedUniqueElementOccurrences.addAll(planElementUIDs2uniqueElementUID.keySet());
                    }
                    catch (EXModificationProblem e) {
                        es[0] = e;
                    }
                }
            }
        });
        if (es[0] != null) {
            ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(es[0].getModificationProblems(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            problemsDialog.open();
        }
    }

    private IUniqueElementOccurrence getMappedOccurence(IPlanElement planElement) {
        if (this.planElementMappingOrNullForNoMapping != null) {
            for (PlanElementToOccurrenceMapping element : this.planElementMappingOrNullForNoMapping) {
                PlanElementToOccurrenceMapping mapping = element;
                if (!mapping.getCreatedPlanElement().getPlanElementUID().equals(planElement.getPlanElementUID()) || !mapping.getCreatedPlanElement().getPlanUID().equals(planElement.getPlanUID()) || !mapping.getCreatedPlanElement().getProjectUID().equals(planElement.getProjectUID())) continue;
                return mapping.getOriginalOccurence();
            }
        }
        return null;
    }

    public boolean canUndoNow() {
        return true;
    }

    public void undo() {
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                FMCAEditorMgrCommandCreatePlanElements.this.getProjectAgent().getPlanAgentUniqueElementManager().deleteUniqueElementOccurencesUnsaved(FMCAEditorMgrCommandCreatePlanElements.this.getPlanEditorControllerExtension(), FMCAEditorMgrCommandCreatePlanElements.this.planElementUIDsOfCreatedUniqueElementOccurrences);
            }
        });
    }

    public void redo() {
        this.execute();
    }
}

