/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planagents;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planagents.IInternalAbstractPlanAgentController;
import com.arcway.cockpit.frame.client.project.planagents.IInternalPlanAgentControllerExtension;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.OpenedPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElement;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.java.New;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.operating.Suppressor;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgentController;
import com.arcway.planagent.controllinginterface.planagent.INameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanElementRequestFlowInfo;
import com.arcway.planagent.controllinginterface.planagent.IPlanElementTextInfo;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planagent.IUpdatedPlanAgentExtension;
import com.arcway.planagent.controllinginterface.planagent.NameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractPlanAgentController
implements IInternalAbstractPlanAgentController,
IAbstractPlanAgentController {
    private static final ILogger logger = Logger.getLogger(AbstractPlanAgentController.class);
    private final IPlanAgentManager planAgentManager;
    private final OpenedPlan plan;
    private final IInternalPlanAgentControllerExtension planAgentControllerExtension;
    private final Object launcherKey;
    private IAbstractPlanAgent abstractPlanAgent;
    private final IPlanAgentProjectAgent projectAgent;
    private final boolean planFileAlreadyStored;
    private final Suppressor planAgentPlanFileUpdateSuppressor = new Suppressor();
    private final IPropertyChangesListener projectChangeListener = new IPropertyChangesListener(){

        public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
            if (AbstractPlanAgentController.this.planAgentPlanFileUpdateSuppressor.dontSuppress() && AbstractPlanAgentController.this.abstractPlanAgent instanceof IUpdatedPlanAgentExtension) {
                IUpdatedPlanAgentExtension updatedPlanAgent = (IUpdatedPlanAgentExtension)AbstractPlanAgentController.this.abstractPlanAgent;
                updatedPlanAgent.planInfoChanged((IPlanInfo)AbstractPlanAgentController.this.plan);
            }
        }
    };
    private final IPropertyChangesListener planChangeListener = new IPropertyChangesListener(){

        public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
            if (AbstractPlanAgentController.this.planAgentPlanFileUpdateSuppressor.dontSuppress()) {
                Collection deletedPlans = changes.getDeletedElements();
                for (IPlan deletedPlan : deletedPlans) {
                    if (!deletedPlan.getUID().equals(AbstractPlanAgentController.this.plan.getPlanUID())) continue;
                    AbstractPlanAgentController.this.getControllerExtension().closePlanAgent();
                }
                if (!AbstractPlanAgentController.this.plan.isHistoric()) {
                    Collection modifiedPlans = changes.getModifiedElements();
                    for (IPlan modifiedPlan : modifiedPlans) {
                        if (!modifiedPlan.getUID().equals(AbstractPlanAgentController.this.plan.getPlanUID())) continue;
                        AbstractPlanAgentController.this.plan.setPlan(modifiedPlan);
                        if (!(AbstractPlanAgentController.this.abstractPlanAgent instanceof IUpdatedPlanAgentExtension)) continue;
                        IUpdatedPlanAgentExtension updatedPlanAgent = (IUpdatedPlanAgentExtension)AbstractPlanAgentController.this.abstractPlanAgent;
                        updatedPlanAgent.planInfoChanged((IPlanInfo)AbstractPlanAgentController.this.plan);
                        try {
                            boolean contentHasChanged = AbstractPlanAgentController.this.getOpenedPlan().loadContent();
                            if (!contentHasChanged) continue;
                            updatedPlanAgent.planContentChanged();
                        }
                        catch (Exception e) {
                            logger.error("cannot load plan file content", (Throwable)e);
                        }
                    }
                }
            }
        }
    };
    private final IPropertyChangesListener occurenceChangeListener = new IPropertyChangesListener(){

        public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
            if (AbstractPlanAgentController.this.planAgentPlanFileUpdateSuppressor.dontSuppress() && !AbstractPlanAgentController.this.plan.isHistoric() && AbstractPlanAgentController.this.abstractPlanAgent instanceof IUpdatedPlanAgentExtension) {
                Collection createdOccurrences = changes.getCreatedElements();
                HashMap planElementUID2newPlanElementName = New.hashMap((int)createdOccurrences.size());
                for (IUniqueElementOccurrence createdOccurrence : createdOccurrences) {
                    String planUID = createdOccurrence.getPlanUID();
                    if (!AbstractPlanAgentController.this.plan.getPlanUID().equals(planUID)) continue;
                    INameAndDescriptionAndCommentAndAspectID newPlanElementName = AbstractPlanAgentController.this.getNameOfPlanElement(createdOccurrence);
                    String planElementUID = createdOccurrence.getPlanElementUID();
                    planElementUID2newPlanElementName.put(planElementUID, newPlanElementName);
                }
                AbstractPlanAgentController.this.setPlanElementNames(planElementUID2newPlanElementName);
            }
        }
    };

    public AbstractPlanAgentController(OpenedPlan plan, IInternalPlanAgentControllerExtension planAgentControllerExtension, IPlanAgentManager planAgentManger, IPlanAgentProjectAgent projectAgent, Object launcherKey, boolean planFileAlreadyStored) {
        assert (plan != null);
        assert (planAgentControllerExtension != null);
        assert (planAgentManger != null);
        assert (projectAgent != null);
        this.plan = plan;
        this.planAgentControllerExtension = planAgentControllerExtension;
        this.planAgentManager = planAgentManger;
        this.projectAgent = projectAgent;
        this.launcherKey = launcherKey;
        this.planFileAlreadyStored = planFileAlreadyStored;
        projectAgent.getPropertyChangesListenerManager().register(this.projectChangeListener, IProjectAgent.class);
        projectAgent.getPropertyChangesListenerManager().register(this.planChangeListener, IPlan.class);
        projectAgent.getPropertyChangesListenerManager().register(this.occurenceChangeListener, IUniqueElementOccurrence.class);
    }

    public void closePlan() {
        this.projectAgent.getPropertyChangesListenerManager().deregister(this.occurenceChangeListener);
        this.projectAgent.getPropertyChangesListenerManager().deregister(this.planChangeListener);
        this.projectAgent.getPropertyChangesListenerManager().deregister(this.projectChangeListener);
        this.getOpenedPlan().closePlan();
    }

    public void setAbstractPlanAgent(IAbstractPlanAgent abstractPlanAgent) {
        assert (abstractPlanAgent != null);
        this.abstractPlanAgent = abstractPlanAgent;
    }

    public IInternalPlanAgentControllerExtension getControllerExtension() {
        return this.planAgentControllerExtension;
    }

    public Object getLauncherKey() {
        return this.launcherKey;
    }

    public void planElementNamesChanged(Map<String, ? extends INameAndDescriptionAndCommentAndAspectID> planElementUID2newName) {
        if (this.abstractPlanAgent instanceof IUpdatedPlanAgentExtension) {
            IUpdatedPlanAgentExtension updatedPlanAgent = (IUpdatedPlanAgentExtension)this.abstractPlanAgent;
            updatedPlanAgent.setPlanElementNames(planElementUID2newName);
        }
    }

    @Override
    public OpenedPlan getOpenedPlan() {
        return this.plan;
    }

    @Override
    public void setPlanElementNames(Map<String, ? extends INameAndDescriptionAndCommentAndAspectID> planElementUID2newName) {
        this.planAgentManager.planElementNamesChanged(this, planElementUID2newName);
    }

    @Override
    public List<? extends IPlanAgentStructuredPlanElement> getPlanStructure() {
        return this.createFrameStructuredPlanElement(this.abstractPlanAgent.getPlanStructure());
    }

    @Override
    public FlowType getFlowType() {
        return this.abstractPlanAgent.getFlowType();
    }

    public void setAccessingMode(int newMode) throws EXWriteAccessDeniedException {
        this.planAgentManager.setAccessingMode(this, newMode);
    }

    public void setPlanTypeID(String planTypeID) {
        this.getOpenedPlan().setPlanTypeID(planTypeID);
    }

    public void createPlanRequest(File planFile) throws EXWriteAccessDeniedException {
        try {
            this.getOpenedPlan().createPlanRequest(planFile);
        }
        catch (EXNoPermission e) {
            logger.error("Could not create Plan: No Permissions!", (Throwable)e);
            throw new EXWriteAccessDeniedException((Throwable)e);
        }
        this.planStructureChanged();
        this.planFileChanged();
    }

    public INameAndDescriptionAndCommentAndAspectID getPlanElementName(IPlanAgentPlanElement planElement) {
        if (!this.plan.isHistoric()) {
            IPlanElement framePlanElement = this.createFramePlanElement(planElement);
            return this.getNameOfPlanElement(framePlanElement);
        }
        return null;
    }

    @Override
    public void planElementNamesChanged() {
        if (this.abstractPlanAgent instanceof IUpdatedPlanAgentExtension) {
            IUpdatedPlanAgentExtension updatedPlanAgent = (IUpdatedPlanAgentExtension)this.abstractPlanAgent;
            updatedPlanAgent.planElementNamesChanged();
        }
    }

    public INameAndDescriptionAndCommentAndAspectID getNameOfPlanElement(IPlanElement planElement) {
        String planElementUID = planElement.getPlanElementUID();
        IUniqueElement uniqueElement = this.projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOfOccurrence(planElement);
        return this.getNameOfPlanElement(planElementUID, uniqueElement);
    }

    public INameAndDescriptionAndCommentAndAspectID getNameOfPlanElement(IUniqueElementOccurrence occurence) {
        String planElementUID = occurence.getPlanElementUID();
        IUniqueElement uniqueElement = this.projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOfOccurrence(occurence);
        return this.getNameOfPlanElement(planElementUID, uniqueElement);
    }

    public INameAndDescriptionAndCommentAndAspectID getNameOfPlanElement(String planElementUID) {
        String planUID = this.plan.getPlanUID();
        IUniqueElementOccurrence occurrence = this.projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOccurrence1(planUID, planElementUID);
        if (occurrence == null) {
            return null;
        }
        IUniqueElement uniqueElement = this.projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOfOccurrence(occurrence);
        return this.getNameOfPlanElement(planElementUID, uniqueElement);
    }

    private INameAndDescriptionAndCommentAndAspectID getNameOfPlanElement(String planElementUID, IUniqueElement uniqueElement) {
        String text;
        IAttribute commentReplacementAttribute;
        Object value;
        IAttributeTypeID commentAttributeTypeID;
        PlanDisplayParameters planDisplayParameters = this.plan.getPlanDisplayParameters();
        String displayName = null;
        Map<String, String> planElementUID2individualNameReplacement = planDisplayParameters.getPlanElementUID2individualNameReplacement();
        if (planElementUID2individualNameReplacement != null) {
            displayName = planElementUID2individualNameReplacement.get(planElementUID);
        }
        if (displayName == null && uniqueElement != null) {
            String text2;
            IAttribute nameReplacementAttribute;
            Object value2;
            IAttributeTypeID nameAttributeTypeID = planDisplayParameters.getUniqueElementAttributeTypeIDofNameAttribute();
            if (nameAttributeTypeID != null && (value2 = (nameReplacementAttribute = uniqueElement.getAttribute(nameAttributeTypeID)).getAttributeValue()) instanceof String && (text2 = (String)value2).length() != 0) {
                displayName = text2;
            }
            if (displayName == null) {
                displayName = uniqueElement.getElementName();
            }
        }
        String description = null;
        Map<String, String> planElementUID2individualDescriptionReplacement = planDisplayParameters.getPlanElementUID2individualDescriptionReplacement();
        if (planElementUID2individualDescriptionReplacement != null) {
            description = planElementUID2individualDescriptionReplacement.get(planElementUID);
        }
        if (description == null && uniqueElement != null) {
            String text3;
            IAttribute descriptionReplacementAttribute;
            Object value3;
            IAttributeTypeID descriptionAttributeTypeID = planDisplayParameters.getUniqueElementAttributeTypeIDofDescriptionAttribute();
            if (descriptionAttributeTypeID != null && (value3 = (descriptionReplacementAttribute = uniqueElement.getAttribute(descriptionAttributeTypeID)).getAttributeValue()) instanceof String && (text3 = (String)value3).length() != 0) {
                description = text3;
            }
            if (description == null) {
                description = uniqueElement.getDescription();
            }
        }
        String comment = null;
        Map<String, String> planElementUID2individualCommentReplacement = planDisplayParameters.getPlanElementUID2individualCommentReplacement();
        if (planElementUID2individualCommentReplacement != null) {
            comment = planElementUID2individualCommentReplacement.get(planElementUID);
        }
        if (comment == null && uniqueElement != null && (commentAttributeTypeID = planDisplayParameters.getUniqueElementAttributeTypeIDofCommentAttribute()) != null && (value = (commentReplacementAttribute = uniqueElement.getAttribute(commentAttributeTypeID)).getAttributeValue()) instanceof String && (text = (String)value).length() != 0) {
            comment = text;
        }
        return new NameAndDescriptionAndCommentAndAspectID(displayName, description, comment, null);
    }

    public void planStructureChanged() {
        this.planAgentControllerExtension.planStructureChanged();
    }

    public void planFileChanged() throws EXWriteAccessDeniedException {
        if (!this.plan.isInWriteMode()) {
            throw new EXWriteAccessDeniedException("Plan " + this.plan.getPlanName() + " was saved, but the plan agent was not in write mode.");
        }
        final EXWriteAccessDeniedException[] ex = new EXWriteAccessDeniedException[1];
        this.planAgentPlanFileUpdateSuppressor.doWithSuppression(new Runnable(){

            @Override
            public void run() {
                AbstractPlanAgentController.this.projectAgent.getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!$assertionsDisabled && AbstractPlanAgentController.this.getOpenedPlan().getPlan() == null) {
                                throw new AssertionError((Object)"plan was not yet created");
                            }
                            if (!AbstractPlanAgentController.this.planFileAlreadyStored) {
                                AbstractPlanAgentController.this.getOpenedPlan().storeContent(true);
                            }
                        }
                        catch (EXModificationProblem e) {
                            ex[0] = new EXWriteAccessDeniedException((Throwable)e);
                        }
                    }
                });
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
    }

    public void close() {
        this.planAgentControllerExtension.planAgentClosed();
        this.planAgentManager.planAgentClosed(this);
    }

    private IPlanElement createFramePlanElement(IPlanAgentPlanElement editorPlanElement) {
        return new PlanElement(editorPlanElement, this.plan.getPlanUID(), this.plan.getProjectUID());
    }

    private List<? extends IPlanAgentStructuredPlanElement> createFrameStructuredPlanElement(List<? extends IPlanAgentStructuredPlanElement> editorPlanElements) {
        HashMap<String, StructuredPlanElement> framePlanElementsMap = new HashMap<String, StructuredPlanElement>(editorPlanElements.size() * 2);
        for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : editorPlanElements) {
            StructuredPlanElement framePlanElement = new StructuredPlanElement(iPlanAgentStructuredPlanElement);
            framePlanElementsMap.put(framePlanElement.getPlanElementUID(), framePlanElement);
        }
        ArrayList<StructuredPlanElement> arrayList = new ArrayList<StructuredPlanElement>(editorPlanElements.size());
        for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : editorPlanElements) {
            StructuredPlanElement frameContainedPlanElement;
            StructuredPlanElement frameContainer;
            StructuredPlanElement framePlanElement = (StructuredPlanElement)framePlanElementsMap.get(iPlanAgentStructuredPlanElement.getPlanElementUID());
            for (IPlanAgentStructuredPlanElement editorContainer : iPlanAgentStructuredPlanElement.getContainers()) {
                frameContainer = (StructuredPlanElement)framePlanElementsMap.get(editorContainer.getPlanElementUID());
                framePlanElement.getContainers().add(frameContainer);
            }
            for (IPlanAgentStructuredPlanElement editorContainedPlanElement : iPlanAgentStructuredPlanElement.getContainedPlanElements()) {
                frameContainedPlanElement = (StructuredPlanElement)framePlanElementsMap.get(editorContainedPlanElement.getPlanElementUID());
                framePlanElement.getContainedPlanElements().add(frameContainedPlanElement);
            }
            for (IPlanAgentStructuredPlanElement editorContainer : iPlanAgentStructuredPlanElement.getPredecessors()) {
                frameContainer = (StructuredPlanElement)framePlanElementsMap.get(editorContainer.getPlanElementUID());
                framePlanElement.getPredecessors().add(frameContainer);
            }
            for (IPlanAgentStructuredPlanElement editorContainedPlanElement : iPlanAgentStructuredPlanElement.getSuccessors()) {
                frameContainedPlanElement = (StructuredPlanElement)framePlanElementsMap.get(editorContainedPlanElement.getPlanElementUID());
                framePlanElement.getSuccessors().add(frameContainedPlanElement);
            }
            for (IPlanAgentStructuredPlanElement editorContainer : iPlanAgentStructuredPlanElement.getWriters()) {
                frameContainer = (StructuredPlanElement)framePlanElementsMap.get(editorContainer.getPlanElementUID());
                framePlanElement.getWriters().add(frameContainer);
            }
            for (IPlanAgentStructuredPlanElement editorContainedPlanElement : iPlanAgentStructuredPlanElement.getReaders()) {
                frameContainedPlanElement = (StructuredPlanElement)framePlanElementsMap.get(editorContainedPlanElement.getPlanElementUID());
                framePlanElement.getReaders().add(frameContainedPlanElement);
            }
            arrayList.add(framePlanElement);
        }
        return arrayList;
    }

    public static interface IPlanAgentManager {
        public void setAccessingMode(AbstractPlanAgentController var1, int var2) throws EXWriteAccessDeniedException;

        public void planElementNamesChanged(AbstractPlanAgentController var1, Map<String, ? extends INameAndDescriptionAndCommentAndAspectID> var2);

        public void planAgentClosed(AbstractPlanAgentController var1);
    }

    private class StructuredPlanElement
    implements IPlanAgentStructuredPlanElement {
        private final String planElementUID;
        private final String planElementTypeID;
        private final String planElementName;
        private final String planElementDescription;
        private final String planElementAspectID;
        private final TopologyType topologyType;
        private final Rectangle outerBoundsInMM;
        private final Rectangle pointUnionInMM;
        private final Rectangle projectionAreaInMM;
        private final boolean isComment;
        private final Collection<? extends IPlanElementTextInfo> textInfos;
        private final Collection<? extends IPlanElementRequestFlowInfo> requestFlowInfos;
        private final List<StructuredPlanElement> containers;
        private final List<StructuredPlanElement> containedPlanElements;
        private final List<StructuredPlanElement> predecessors;
        private final List<StructuredPlanElement> successors;
        private final List<StructuredPlanElement> writers;
        private final List<StructuredPlanElement> readers;

        public StructuredPlanElement(IPlanAgentStructuredPlanElement editorPlanElement) {
            this.planElementUID = editorPlanElement.getPlanElementUID();
            this.planElementTypeID = editorPlanElement.getPlanElementTypeID();
            this.planElementName = editorPlanElement.getPlanElementName();
            this.planElementDescription = editorPlanElement.getPlanElementDescription();
            this.planElementAspectID = editorPlanElement.getPlanElementAspectID();
            this.topologyType = editorPlanElement.getToplogyType();
            this.outerBoundsInMM = editorPlanElement.getOuterBoundsInMM();
            this.pointUnionInMM = editorPlanElement.getPointUnionInMM();
            this.projectionAreaInMM = editorPlanElement.getProjectionAreaInMM();
            this.isComment = editorPlanElement.isComment();
            this.textInfos = editorPlanElement.getTextInfos();
            this.requestFlowInfos = editorPlanElement.getRequestFlowInfos();
            this.containers = new ArrayList<StructuredPlanElement>(editorPlanElement.getContainers().size());
            this.containedPlanElements = new ArrayList<StructuredPlanElement>(editorPlanElement.getContainedPlanElements().size());
            this.predecessors = new ArrayList<StructuredPlanElement>(editorPlanElement.getPredecessors().size());
            this.successors = new ArrayList<StructuredPlanElement>(editorPlanElement.getSuccessors().size());
            this.writers = new ArrayList<StructuredPlanElement>(editorPlanElement.getWriters().size());
            this.readers = new ArrayList<StructuredPlanElement>(editorPlanElement.getReaders().size());
        }

        public TopologyType getToplogyType() {
            return this.topologyType;
        }

        public String getPlanElementUID() {
            return this.planElementUID;
        }

        public String getPlanElementTypeID() {
            return this.planElementTypeID;
        }

        public String getPlanElementAspectID() {
            return this.planElementAspectID;
        }

        public String getPlanElementName() {
            return this.planElementName;
        }

        public String getPlanElementDescription() {
            return this.planElementDescription;
        }

        public Rectangle getOuterBoundsInMM() {
            return this.outerBoundsInMM;
        }

        public Rectangle getPointUnionInMM() {
            return this.pointUnionInMM;
        }

        public Rectangle getProjectionAreaInMM() {
            return this.projectionAreaInMM;
        }

        public boolean isComment() {
            return this.isComment;
        }

        public Collection<? extends IPlanElementTextInfo> getTextInfos() {
            return this.textInfos;
        }

        public Collection<? extends IPlanElementRequestFlowInfo> getRequestFlowInfos() {
            return this.requestFlowInfos;
        }

        public List<StructuredPlanElement> getContainers() {
            return this.containers;
        }

        public List<StructuredPlanElement> getContainedPlanElements() {
            return this.containedPlanElements;
        }

        public List<StructuredPlanElement> getPredecessors() {
            return this.predecessors;
        }

        public List<StructuredPlanElement> getReaders() {
            return this.readers;
        }

        public List<StructuredPlanElement> getSuccessors() {
            return this.successors;
        }

        public List<StructuredPlanElement> getWriters() {
            return this.writers;
        }
    }
}

