/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0.uniqueelementtypemigrator;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOUniqueElement_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.uniqueelementtypemigrator.UniqueElementMigrationTypeDescriptions;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.uniqueelementtypemigrator.UniqueElementTypeMigratorDataPath;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class UniqueElementTypeMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version0.uniqueelementtypemigrator";
    private static final IEncodableObjectFactory EOFACTORY = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactoryForBasicEOs.getDefault(), V0_EOFactory.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()});

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("FrameDumpDirectoryMigrator");
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return V0_EOFactory.getDefault();
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_0_ dumpView = (HistoricProjectDumpView_0_)projectDump;
        for (EOProject_V0 project : dumpView.getAllProjects()) {
            EOList uniqueElementList;
            try {
                uniqueElementList = (EOList)dumpView.readDataFile(project, "uniqueElements.xml", null, EOFACTORY);
            }
            catch (EXDecoderException e) {
                throw new MigrationFailedException(e);
            }
            UniqueElementTypeMigratorDataPath.migrateUniqueElementList((EOList<EOUniqueElement_V0>)uniqueElementList, UniqueElementMigrationTypeDescriptions.getTypesForMigration(), new Locale(project.getProjectLanguage()));
            dumpView.writeDataFile(project, "uniqueElements.xml", null, (EncodableObjectBase)uniqueElementList);
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateImport(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateImport(projectFile);
    }

    private void migrateImport(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_0_ fileView = (HistoricProjectFileView_0_)projectFile;
        try {
            EOProject_V0 project = fileView.getProjectMetaData();
            EOList<? extends EncodableObjectBase> uniqueElementList = fileView.getDataList("unique elements");
            UniqueElementTypeMigratorDataPath.migrateUniqueElementList(uniqueElementList, UniqueElementMigrationTypeDescriptions.getTypesForMigration(), new Locale(project.getProjectLanguage()));
        }
        catch (ProjectFileAccess.ProjectFileAccessException e) {
            throw new MigrationFailedException(e);
        }
    }
}

