/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ShortDescriptionMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(ShortDescriptionMigrator.class);
    public static final String KEY = "com.arcway.cockpit.shortdescriptionmodule.client.ShortDescriptionMigrator";
    private static final String OLD_LINKTYPEID_SHORTDESCRIPTION_UE = "LinkShortDescUniqueElement";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
            boolean wasSDMDataPresent = false;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    boolean wasDirectoryPresent = historicView.deleteDataDirectory(currentProject, "SDM");
                    if (wasDirectoryPresent) {
                        wasSDMDataPresent = true;
                    }
                    EncodableObjectBase linkData = historicView.readLinks_3(currentProject);
                    EOList nonLocalLinksList = null;
                    if (linkData instanceof EOLinkDataContainer_V0) {
                        nonLocalLinksList = ((EOLinkDataContainer_V0)linkData).getLinks();
                    } else if (linkData instanceof EOList) {
                        nonLocalLinksList = (EOList)linkData;
                    } else {
                        throw new MigrationFailedException("Unexpected format of the link data in the project dump.");
                    }
                    ArrayList<EOLink_V0> linksToBeDeleted = new ArrayList<EOLink_V0>(nonLocalLinksList.size());
                    for (EOLink_V0 link : nonLocalLinksList) {
                        if (!OLD_LINKTYPEID_SHORTDESCRIPTION_UE.equals(link.getLinkTypeID())) continue;
                        linksToBeDeleted.add(link);
                        wasSDMDataPresent = true;
                    }
                    nonLocalLinksList.removeAll(linksToBeDeleted);
                }
            }
            if (wasSDMDataPresent) {
                logger.warn("The restored dump contained short description data. This data has been removed. If you still require this data, please convert the short descriptions in the old project and dump & restore the project again, afterwards.");
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) {
    }

    private void migrateACTOrACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        try {
            EOList<? extends EncodableObjectBase> linkData;
            HistoricProjectFileView_0_ projectFileView_0_ = (HistoricProjectFileView_0_)projectFile;
            boolean wasSDMDataPresent = false;
            EOList<? extends EncodableObjectBase> moduleDataListList = projectFileView_0_.getDataList("module data");
            if (moduleDataListList != null) {
                Iterator moduleDataListIterator = moduleDataListList.iterator();
                while (moduleDataListIterator.hasNext()) {
                    EOList moduleDataList = (EOList)moduleDataListIterator.next();
                    String moduleDataListRole = moduleDataList.getRole();
                    if (!moduleDataListRole.equals("SDM_SHORTDESCRIPTIONS")) continue;
                    moduleDataListIterator.remove();
                    if (moduleDataList.isEmpty()) continue;
                    logger.debug("Short descriptions found in project file and ignored while import: \n" + this.getStringRepresentationOfEOForLogging((EncodableObjectBase)moduleDataList));
                    wasSDMDataPresent = true;
                }
            }
            if ((linkData = projectFileView_0_.getDataList("links")) != null) {
                ArrayList<EOLink_V0> linksToBeDeleted = new ArrayList<EOLink_V0>(linkData.size());
                for (EOLink_V0 link : linkData) {
                    if (!OLD_LINKTYPEID_SHORTDESCRIPTION_UE.equals(link.getLinkTypeID())) continue;
                    linksToBeDeleted.add(link);
                    logger.debug("Short description link found in project file and ignored while import: \n" + this.getStringRepresentationOfEOForLogging((EncodableObjectBase)link));
                    wasSDMDataPresent = true;
                }
                linkData.removeAll(linksToBeDeleted);
            }
            if (wasSDMDataPresent) {
                logger.warn("The imported project file contained short description data. This data has been removed. If you still require this data, please convert the short descriptions in the old project and create & import a new project file afterwards.");
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can not migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
    }

    private String getStringRepresentationOfEOForLogging(EncodableObjectBase eo) {
        try {
            return eo.toXMLString(true);
        }
        catch (EXEncoderException e) {
            return "<unable to create text representation of " + eo.getClass() + ">";
        }
    }
}

