/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_both.version5;

import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOUserInformation_V5;
import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;
import java.util.Date;

public class EOCommitInformation_V5
extends EOEncodableObject {
    public static final String XML_TAG = "commitinformation";
    private static final String XML_ATTRIBUTE_COMMITUID = "commituid";
    private static final String XML_ATTRIBUTE_COMMITDATE = "commitdate";
    private static final String XML_ATTRIBUTE_COMMITCOMMENT = "commitcomment";
    private String commitUID;
    private Date commitDate;
    private EOUserInformation_V5 userInformation;
    private String commitComment = "";

    public EOCommitInformation_V5(String commitUID, Date commitDate, EOUserInformation_V5 userInformation, String commitComment) {
        super(XML_TAG);
        Assert.checkArgumentBeeingNotNull((Object)commitUID);
        Assert.checkArgumentBeeingNotNull((Object)commitDate);
        Assert.checkArgumentBeeingNotNull((Object)((Object)userInformation));
        Assert.checkArgumentBeeingNotNull((Object)commitComment);
        this.commitUID = commitUID;
        this.commitDate = commitDate;
        this.userInformation = userInformation;
        this.commitComment = commitComment;
    }

    public EOCommitInformation_V5(XMLContext xmlContext) {
        super(XML_TAG, xmlContext);
    }

    public String getCommitUID() {
        return this.commitUID;
    }

    public Date getCommitDate() {
        return this.commitDate;
    }

    public EOUserInformation_V5 getCommitingUserInformation() {
        return this.userInformation;
    }

    public String getCommitComment() {
        return this.commitComment;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success;
        if (name.equals(XML_ATTRIBUTE_COMMITUID)) {
            this.commitUID = value;
            success = true;
        } else if (name.equals(XML_ATTRIBUTE_COMMITDATE)) {
            long date;
            try {
                Timestamp timestamp = super.toTimestamp(value);
                date = timestamp.getTime();
            }
            catch (IllegalArgumentException e) {
                date = super.toDate(value).getTime();
            }
            this.commitDate = new Date(date);
            success = true;
        } else if (name.equals(XML_ATTRIBUTE_COMMITCOMMENT)) {
            this.commitComment = value;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    protected final void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttrToXML(writeContext, XML_ATTRIBUTE_COMMITUID, this.commitUID);
        super.appendAttrToXML(writeContext, XML_ATTRIBUTE_COMMITDATE, new Timestamp(this.commitDate.getTime()));
        super.appendAttrToXML(writeContext, XML_ATTRIBUTE_COMMITCOMMENT, this.commitComment);
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.userInformation.writeXMLBody(writeContext, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success;
        if (newChild instanceof EOUserInformation_V5) {
            this.userInformation = (EOUserInformation_V5)newChild;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EOCommitInformation_V5 other = (EOCommitInformation_V5)((Object)obj);
        return this.commitUID.equals(other.commitUID);
    }

    public int hashCode() {
        return this.commitUID.hashCode();
    }
}

