/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.exceptions;

import com.arcway.cockpit.frame.client.project.core.links.LinkFailures;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.shared.message.EOLink;
import de.plans.lib.util.collections.ArrayUtil;

public class LinkModificationException
extends Exception {
    private final int operation;
    private final int reason;
    private final String linkAsString;
    private final int linkManagerRunLevel;

    public LinkModificationException(EOLink link, int operation, int reason, int linkManagerRunLevel) {
        assert (link != null) : "link must not be null";
        assert (ArrayUtil.isIntValueOf((int)reason, (int[])LinkFailures.REASON_CODES));
        this.operation = operation;
        this.linkAsString = link.toString();
        this.reason = reason;
        this.linkManagerRunLevel = linkManagerRunLevel;
    }

    @Override
    public String getMessage() {
        return "Failure in Link Manager.\n  Operation: " + LinkFailures.getOperationDescription(this.operation) + "\n" + "  Reason: " + LinkFailures.getReasonDescription(this.reason) + "\n" + "  Link Manager RunLevel: " + LinkManager.RUNLEVEL_DESCRIPTIONS[this.linkManagerRunLevel] + "\n" + "  Link:\n" + this.linkAsString + "\n";
    }

    public int getReason() {
        return this.reason;
    }
}

