/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IReportJobParameter;
import com.arcway.cockpit.frame.client.project.docgenerator.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.ConfigurationMgr;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationItem;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.ReportResultFileType;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.IModificationProblem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class ReportJob {
    private final IDocGeneratorProjectAgent projectAgent;
    private final Locale reportLocale;
    private final PresentationContext presentationContext;
    private IReportTemplate reportTemplate = null;
    private Map<String, String> reportTemplateHeader = Collections.emptyMap();
    private IReportType reportType = null;
    private IReportOutputTemplate outputTemplate = null;
    private String reportFileName = null;
    private String reportMainFileName = null;
    private Map<String, Object> varArgs = null;
    private Map<String, List<IFilterItemProvider>> projectUID2filterItems;
    private List<IReportJobParameter> generatorSpecificParameters;
    private InfoMessage infoMessage = null;
    private final List<WarningMessage> warningMessages = new ArrayList<WarningMessage>();
    private final Set<File> reportResultFiles = new HashSet<File>();
    private int timeOutInSeconds = 0;

    public ReportJob(IDocGeneratorProjectAgent projectAgent_) {
        this.projectAgent = projectAgent_;
        this.reportLocale = projectAgent_.getProjectLocale();
        this.presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
    }

    public ReportJob(IDocGeneratorProjectAgent projectAgent_, Locale reportLocale) {
        this.projectAgent = projectAgent_;
        this.reportLocale = reportLocale;
        this.presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
    }

    public ReportJob(Locale reportLocale) {
        this.projectAgent = null;
        this.reportLocale = reportLocale;
        this.presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
    }

    public ReportJob(IDocGeneratorProjectAgent projectAgent_, PresentationContext presentationContext_) {
        this.projectAgent = projectAgent_;
        this.reportLocale = this.projectAgent.getProjectLocale();
        this.presentationContext = presentationContext_;
    }

    public final void setReportTemplate(IReportTemplate reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public void setReportTemplateHeader(Map<String, String> reportTemplateHeader) {
        this.reportTemplateHeader = reportTemplateHeader;
    }

    public final void setReportType(IReportType reportType) {
        this.reportType = reportType;
    }

    public final void setOutputTemplate(IReportOutputTemplate outputTemplate) {
        this.outputTemplate = outputTemplate;
    }

    public final void setTimeOutInSeconds(int timeOutInSeconds) {
        this.timeOutInSeconds = timeOutInSeconds;
    }

    public int getTimeOutInSeconds() {
        return this.timeOutInSeconds;
    }

    public final void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public final void setReportMainFileName(String reportMainFileName) {
        this.reportMainFileName = reportMainFileName;
    }

    public void setGeneratorSpecificParameters(List<IReportJobParameter> generatorSpecificParameters) {
        this.generatorSpecificParameters = generatorSpecificParameters;
    }

    public void setFilterSettings(Map<String, List<IFilterItemProvider>> projectUID2filterItems) {
        this.projectUID2filterItems = projectUID2filterItems;
    }

    public void setUserInfoMessage(String title, String message, IPreferenceStore preferenceStoreForTogglePreferenceKey, String togglePreferenceKey) {
        this.infoMessage = new InfoMessage(title, message, preferenceStoreForTogglePreferenceKey, togglePreferenceKey);
    }

    public void addUserWarningMessage(String problem, String reason) {
        this.warningMessages.add(new WarningMessage(problem, reason));
    }

    public final IDocGeneratorProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public final Locale getReportLocale() {
        return this.reportLocale;
    }

    public final PresentationContext getPresentationContext() {
        return this.presentationContext;
    }

    public final IReportTemplate getReportTemplate() {
        return this.reportTemplate;
    }

    public final File getReportTemplateFile() {
        return this.reportTemplate != null ? this.reportTemplate.getReportFile() : null;
    }

    public Map<String, String> getReportTemplateHeader() {
        return this.reportTemplateHeader;
    }

    public final IReportType getReportType() {
        return this.reportType;
    }

    public final IReportOutputTemplate getOutputTemplate() {
        return this.outputTemplate;
    }

    public final File getOutputTemplateFile() {
        return this.outputTemplate != null ? this.outputTemplate.getFile() : null;
    }

    public final String getReportFilename() {
        return this.reportFileName;
    }

    public final String getReportMainFileName() {
        return this.reportMainFileName;
    }

    public final ReportResultFileType getReportFileType() {
        String outputFormatID = this.reportType.getOutputFormat(this.reportTemplate);
        IReportOutputFormat outputFormat = DocGeneratorManager.getReportOutputFormat(outputFormatID);
        return outputFormat.getOutputFileType();
    }

    public void setVarArgs(Map<String, Object> varArgs) {
        this.varArgs = varArgs;
    }

    public Map<String, Object> getVarArgs() {
        return this.varArgs;
    }

    public Map<String, List<IFilterItemProvider>> getProjectUID2filterItems() {
        return this.projectUID2filterItems;
    }

    public final Map<String, Collection<AbstractFilter>> getFilters() {
        HashMap<String, Collection<AbstractFilter>> projectUID2filters = new HashMap<String, Collection<AbstractFilter>>();
        for (Map.Entry<String, List<IFilterItemProvider>> entry : this.projectUID2filterItems.entrySet()) {
            String projectUID = entry.getKey();
            ArrayList<AbstractFilter> filters = new ArrayList<AbstractFilter>();
            projectUID2filters.put(projectUID, filters);
            List<IFilterItemProvider> filterSettings = this.projectUID2filterItems.get(projectUID);
            if (filterSettings == null) {
                filterSettings = Collections.emptyList();
            }
            for (IFilterItemProvider provider : filterSettings) {
                for (IFilterItem item : provider.getItems()) {
                    filters.add(item.getFilter());
                }
            }
        }
        return projectUID2filters;
    }

    public List<IReportJobParameter> getGeneratorSpecificParameters() {
        return this.generatorSpecificParameters;
    }

    public DocGenConfigurationItem getDocGeneratorEngineConfiguration() {
        return ConfigurationMgr.getInstance().getConfiguration(this.reportTemplate.getUID(), this.projectAgent == null ? null : this.projectAgent.getProjectUID()).getDocGeneratorEngineConfiguration();
    }

    public void registerReportResultFiles(Collection<File> resultFiles) {
        assert (Collections.disjoint(this.reportResultFiles, resultFiles));
        this.reportResultFiles.addAll(resultFiles);
    }

    public Collection<File> getReportResultFiles() {
        return Collections.unmodifiableCollection(this.reportResultFiles);
    }

    public InfoMessage getUserInfoMessage() {
        return this.infoMessage;
    }

    public List<WarningMessage> getWarningMessages() {
        return this.warningMessages;
    }

    public static class InfoMessage {
        private final String title;
        private final String message;
        private final String togglePreferenceKey;
        private final IPreferenceStore preferenceStoreForTogglePreferenceKey;

        public InfoMessage(String title, String message, IPreferenceStore preferenceStoreForTogglePreferenceKey, String togglePreferenceKey) {
            this.title = title;
            this.message = message;
            this.togglePreferenceKey = togglePreferenceKey;
            this.preferenceStoreForTogglePreferenceKey = preferenceStoreForTogglePreferenceKey;
        }

        public void showMessage(Shell parentShell) {
            String askUser;
            boolean showMessage = true;
            if (this.preferenceStoreForTogglePreferenceKey != null && this.togglePreferenceKey != null && (askUser = this.preferenceStoreForTogglePreferenceKey.getString(this.togglePreferenceKey)) != null && askUser.equals("always")) {
                showMessage = false;
            }
            if (showMessage) {
                MessageDialogWithToggle.openInformation((Shell)parentShell, (String)this.title, (String)this.message, (String)Messages.getString("DocGenerationAction.NeverShowMessageAgain"), (boolean)false, (IPreferenceStore)this.preferenceStoreForTogglePreferenceKey, (String)this.togglePreferenceKey);
            }
        }
    }

    public static class WarningMessage
    implements IModificationProblem {
        private final String problem;
        private final String reason;

        public WarningMessage(String problem, String reason) {
            this.problem = problem;
            this.reason = reason;
        }

        public String getHumanReadableDescriptionOfCause() {
            return this.reason;
        }

        public String getHumanReadableDescriptionOfConsequence() {
            return this.problem;
        }

        public int getSeverity() {
            return 3;
        }
    }
}

