/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange.plan;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.SingleWizardProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.datainterchange.plan.ExportPlanWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;

public class ExportPlanWizardProvider
extends SingleWizardProvider {
    private static final String name = Messages.getString("ExportPlanWizardProvider.0");

    @Override
    public boolean validForSelectedElement(Object selectedElement) {
        return selectedElement instanceof IFrameProjectAgent || selectedElement instanceof ISection || selectedElement instanceof IPlan;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return Icons.getImageDescriptorForPlan();
    }

    @Override
    public String getID() {
        return "frame.datainterchange.import.plans";
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getDescription() {
        return Messages.getString("ExportPlanWizardProvider.1");
    }

    @Override
    public IWizard getWizard(Object selectedElement) {
        if (selectedElement instanceof IFrameProjectAgent) {
            IFrameProjectAgent projectAgent = (IFrameProjectAgent)selectedElement;
            ISection section = projectAgent.getFrameSectionManager().getRootSection();
            return new ExportPlanWizard(projectAgent, section);
        }
        if (selectedElement instanceof ISection) {
            ISection section = (ISection)selectedElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
            return new ExportPlanWizard(projectAgent, section);
        }
        if (selectedElement instanceof IPlan) {
            IPlan plan = (IPlan)selectedElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
            ISection section = projectAgent.getSectionManager().getParentSection(plan);
            return new ExportPlanWizard(projectAgent, section, plan);
        }
        return null;
    }

    @Override
    public String getPermissionError() {
        return "";
    }

    @Override
    public boolean hasPermissionForSelectedElement(Object selectedElement) {
        return true;
    }
}

