/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.CyclicUERelationshipIdentifier;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementOccurrenceMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipDataProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipType;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.lib.UUIDGenerator;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UniqueElementRelationshipProvider
implements IUniqueElementRelationshipProvider {
    private final IUniqueElementRelationshipDataProvider ueRelationshipDataProvider;
    private final IUniqueElementRelationshipType uniqueElementRelationshipType;

    public static Collection<EOUniqueElementRelationship> resolvePEStructureToUERelationships(IPlanAgentStructuredPlanElement planElement, IUniqueElementRelationshipType relationshipType, IUniqueElementOccurrenceMgr uniqueElementMgr) {
        ArrayList<EOUniqueElementRelationship> relationships = new ArrayList<EOUniqueElementRelationship>();
        String uniqueElementUID = uniqueElementMgr.getUIDOfRelatedUniqueElement(planElement.getPlanElementUID());
        if (uniqueElementUID != null) {
            HashSet<IPlanAgentStructuredPlanElement> visitedPlanElements = new HashSet<IPlanAgentStructuredPlanElement>();
            visitedPlanElements.add(planElement);
            Collection<String> relatedUniqueElementUIDs = UniqueElementRelationshipProvider.identifyUniqueElementsInStructure(planElement, visitedPlanElements, relationshipType, uniqueElementMgr);
            for (String relatedUniqueElementUID : relatedUniqueElementUIDs) {
                EOUniqueElementRelationship relationship = new EOUniqueElementRelationship(UUIDGenerator.getUniqueID(), uniqueElementMgr.getProjectUID(), relationshipType.getRelationshipTypeID(), uniqueElementUID, relatedUniqueElementUID, uniqueElementMgr.getPlanUID());
                relationships.add(relationship);
            }
        }
        return relationships;
    }

    private static Collection<String> identifyUniqueElementsInStructure(IPlanAgentStructuredPlanElement planElement, Set<IPlanAgentStructuredPlanElement> visitedPlanElements, IUniqueElementRelationshipType relationshipType, IUniqueElementOccurrenceMgr uniqueElementMgr) {
        HashSet<String> foundUEsInStructure = new HashSet<String>();
        List<? extends IPlanAgentStructuredPlanElement> dataToHandle = relationshipType.determinePlanElementsToHandle(planElement);
        for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : dataToHandle) {
            String uniqueElementUID = uniqueElementMgr.getUIDOfRelatedUniqueElement(iPlanAgentStructuredPlanElement.getPlanElementUID());
            if (uniqueElementUID != null) {
                foundUEsInStructure.add(uniqueElementUID);
                continue;
            }
            if (visitedPlanElements.contains(iPlanAgentStructuredPlanElement)) continue;
            visitedPlanElements.add(iPlanAgentStructuredPlanElement);
            foundUEsInStructure.addAll(UniqueElementRelationshipProvider.identifyUniqueElementsInStructure(iPlanAgentStructuredPlanElement, visitedPlanElements, relationshipType, uniqueElementMgr));
        }
        return foundUEsInStructure;
    }

    public UniqueElementRelationshipProvider(IUniqueElementRelationshipDataProvider ueRelationshipManager, IUniqueElementRelationshipType uniqueElementRelationshipType) {
        this.ueRelationshipDataProvider = ueRelationshipManager;
        this.uniqueElementRelationshipType = uniqueElementRelationshipType;
    }

    @Override
    public boolean isPartOfCycle(String elementUID) {
        return this.ueRelationshipDataProvider.isPartOfCycle(elementUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public CyclicUERelationshipIdentifier.Cycle getCycle(String elementUID) {
        return this.ueRelationshipDataProvider.getCycle(elementUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Set<CyclicUERelationshipIdentifier.Cycle> getRootCycles() {
        return this.ueRelationshipDataProvider.getRootCycles(this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public CyclicUERelationshipIdentifier.Cycle getCycle(Set<String> elements) {
        return this.ueRelationshipDataProvider.getCycle(elements, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getAllNextUniqueElements(String elementUID) {
        return this.ueRelationshipDataProvider.getAllNextUniqueElements(elementUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getAllPreviousUniqueElements(String elementUID) {
        return this.ueRelationshipDataProvider.getAllPreviousUniqueElements(elementUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getNextUniqueElements(String elementUID) {
        return this.ueRelationshipDataProvider.getNextUniqueElements(elementUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getPreviousUniqueElements(String elementUID) {
        return this.ueRelationshipDataProvider.getPreviousUniqueElements(elementUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getPreviousUniqueElementsOnPlan(String elementUID, String planUID) {
        return this.ueRelationshipDataProvider.getPreviousUniqueElementsOnPlan(elementUID, planUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getAllPreviousUniqueElementsOnPlan(String elementUID, String planUID) {
        return this.ueRelationshipDataProvider.getAllPreviousUniqueElementsOnPlan(elementUID, planUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getNextUniqueElementsOnPlan(String elementUID, String planUID) {
        return this.ueRelationshipDataProvider.getNextUniqueElementsOnPlan(elementUID, planUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getAllNextUniqueElementsOnPlan(String elementUID, String planUID) {
        return this.ueRelationshipDataProvider.getAllNextUniqueElementsOnPlan(elementUID, planUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getFirstUniqueElements_byACu() {
        return this.ueRelationshipDataProvider.getFirstUniqueElements_byACu(this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getFirstUniqueElements() {
        return this.ueRelationshipDataProvider.getFirstUniqueElements(this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getLastUniqueElements() {
        return this.ueRelationshipDataProvider.getLastUniqueElements(this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getFirstUniqueElementsOnPlan(String planUID) {
        return this.ueRelationshipDataProvider.getFirstUniqueElementsOnPlan(planUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public Collection<IUniqueElement> getLastUniqueElementsOnPlan(String planUID) {
        return this.ueRelationshipDataProvider.getLastUniqueElementsOnPlan(planUID, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }

    @Override
    public boolean doesRelationshipExist(String predecessorElement, String successorElement) {
        return this.ueRelationshipDataProvider.doesRelationshipExist(predecessorElement, successorElement, this.uniqueElementRelationshipType.getRelationshipTypeID());
    }
}

