/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import java.util.Comparator;

public class UniqueElementComparator
implements Comparator<IUniqueElement> {
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_PRIO_NAME = 1;
    private int methodToSort = 0;

    public UniqueElementComparator() {
        this(0);
    }

    public UniqueElementComparator(int sortBy) {
        this.methodToSort = sortBy;
    }

    @Override
    public int compare(IUniqueElement obj1, IUniqueElement obj2) {
        int result = 0;
        switch (this.methodToSort) {
            case 0: {
                String sortCriteria1 = obj1.getElementName();
                String sortCriteria2 = obj2.getElementName();
                result = sortCriteria1.toLowerCase().compareTo(sortCriteria2.toLowerCase());
                break;
            }
            case 1: {
                int e1Prio = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(obj1.getElementTypeID()).getPriority();
                int e2Prio = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(obj2.getElementTypeID()).getPriority();
                if (e1Prio < e2Prio) {
                    result = -1;
                    break;
                }
                if (e1Prio > e2Prio) {
                    result = 1;
                    break;
                }
                String sortCriteria1 = obj1.getElementName();
                String sortCriteria2 = obj2.getElementName();
                result = sortCriteria1.toLowerCase().compareTo(sortCriteria2.toLowerCase());
                break;
            }
            default: {
                String sortCriteria1 = obj1.getElementName();
                String sortCriteria2 = obj2.getElementName();
                result = sortCriteria1.toLowerCase().compareTo(sortCriteria2.toLowerCase());
            }
        }
        return result;
    }
}

