/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.client.project.datainterchange.IUniqueElementExportDataProvider;
import com.arcway.cockpit.frame.shared.message.EOUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExportDataProvider
implements IUniqueElementExportDataProvider {
    private final UniqueElementMgr uniqueElementManager;

    protected ExportDataProvider(UniqueElementMgr uniqueElementManager) {
        assert (uniqueElementManager != null);
        this.uniqueElementManager = uniqueElementManager;
    }

    @Override
    public Collection<EOUniqueElement> getAllUniqueElements() {
        List<? extends IUniqueElement> uniqueElements = this.uniqueElementManager.getUniqueElements();
        ArrayList<EOUniqueElement> eoUniqueElements = new ArrayList<EOUniqueElement>(uniqueElements.size());
        for (IUniqueElement iUniqueElement : uniqueElements) {
            eoUniqueElements.add(((UniqueElement)iUniqueElement).createEncodableObject());
        }
        return eoUniqueElements;
    }

    @Override
    public Collection<EOUniqueElementOccurrence> getUniqueElementOccurences(Collection<EOUniqueElement> uniqueElements) {
        ArrayList<EOUniqueElementOccurrence> result = new ArrayList<EOUniqueElementOccurrence>();
        for (EOUniqueElement ue : uniqueElements) {
            result.addAll(this.uniqueElementManager.getUniqueElementOccurrences(ue.getUID()));
        }
        return result;
    }
}

