/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.permissions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.IFramePermissionManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.PermissionModificationCache;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.modules.IPermissionModificationAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.PSCPermissionConstants;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.IPermissionOwner;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;

public class ProjectPermissionModificationModel
implements IPermissionModificationAgent,
IFramePermissionManager {
    public static final String EXTENSIONPOINT_ELEMENT_NAME = "ProjectsPermissionsGroup";
    public static final String EXTENSIONPOINT_ATTRIBUTE_NAME = "ProjectPermissionsGroup";
    private static final ILogger logger = Logger.getLogger(ProjectPermissionModificationModel.class);
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return ProjectPermissionModificationModel.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };
    private boolean overridePermissions = false;
    private final List<EOPermission> addedPermissions = new ArrayList<EOPermission>();
    private final List<EOPermission> removedPermissions = new ArrayList<EOPermission>();
    private Collection<IPermissionOwner> allPermissionOwners;
    private Collection<CockpitPermissionTemplate> allTemplates;
    private Collection<ILabelProvider> allTemplateLabelProviders;
    private PermissionModificationCache modificationCache;
    private IFrameProjectAgent projectAgent;

    private PermissionModificationCache getModificationCache() {
        if (this.modificationCache == null) {
            this.modificationCache = new PermissionModificationCache();
            List<EOPermission> originalPermissions = this.projectAgent.getFrameServerProxy().getAllPermissions();
            this.modificationCache.setAllPermissions(originalPermissions);
        }
        return this.modificationCache;
    }

    public void construct(IFrameProjectAgent newProjectAgent) {
        assert (newProjectAgent != null);
        this.projectAgent = newProjectAgent;
    }

    @Override
    public EOPermission addPermission(EOPermission permission) {
        assert (permission != null);
        if (!(this.overridePermissions || this.projectAgent.getFramePermissionChecker().hasPermission("adminPermissions", null, this.operandTree) || this.projectAgent.getFramePermissionChecker().isAdmin())) {
            logger.debug("user has no permission to admin this project's permissions");
            return null;
        }
        EOPermission pOld = this.getModificationCache().getExistingPermission(permission);
        if (pOld != null) {
            return pOld;
        }
        permission.setPermissionUID(UUIDGenerator.getUniqueID());
        this.addedPermissions.add(permission);
        this.getModificationCache().addPermission(permission);
        return permission;
    }

    @Override
    public void permissionOperandCreated(IPermissionOperand operand) {
        assert (operand != null);
        if (!this.isAdmin((IPermissionOwner)this.projectAgent.getUserData(true).getUser())) {
            if (operand instanceof IProjectAgent) {
                this.addPermissionsForNewProject(this.projectAgent.getUserData(true).getUser());
            } else {
                this.addAllPermissionsForOperandToOwner(operand, this.projectAgent.getUserData(true).getUser());
            }
        }
    }

    private void addAllPermissionsForOperandToOwner(IPermissionOperand operand, EOUser currentUser) {
        assert (operand != null);
        assert (currentUser != null);
        this.overridePermissions = true;
        if (this.projectAgent.isOpened()) {
            Collection<CockpitPermissionTemplate> templates = this.getAllPermissionTemplates();
            for (CockpitPermissionTemplate template : templates) {
                if (!template.getOperandType().equals(operand.getPermissionOperandType()) || !template.grantByDefault()) continue;
                EOPermission permission = template.createPermission(operand, (IPermissionOwner)currentUser, this.projectAgent.getProjectUID());
                this.addPermission(permission);
            }
        }
        this.overridePermissions = false;
    }

    private void addPermissionsForNewProject(EOUser currentUser) {
        assert (this.projectAgent != null);
        assert (currentUser != null);
        if (this.projectAgent.isOpened()) {
            boolean orgOverridePermissions = this.overridePermissions;
            this.overridePermissions = true;
            Collection<CockpitPermissionTemplate> templates = this.getAllPermissionTemplates();
            for (CockpitPermissionTemplate template : templates) {
                EOPermission permission;
                if (template instanceof AttributeModificationPermissionTemplate || (permission = template.createPermissionForNewProject(this.projectAgent, (IPermissionOwner)currentUser)) == null) continue;
                this.addPermission(permission);
            }
            this.overridePermissions = orgOverridePermissions;
        }
    }

    public boolean isAdmin(IPermissionOwner permissionOwner) {
        if (permissionOwner instanceof EOUser) {
            EOUser user = (EOUser)permissionOwner;
            return user.getUserName().equals("Administrator");
        }
        if (permissionOwner instanceof EOGroup) {
            EOGroup group = (EOGroup)permissionOwner;
            return group.getGroupName().equals("Administrators");
        }
        return false;
    }

    @Override
    public void permissionOperandRemoved(IPermissionOperand operand) {
        assert (operand != null);
        this.overridePermissions = true;
        Collection remainingPermissions = this.getModificationCache().getAllPermissionsOfOperand(operand.getPermissionOperandType(), operand.getPermissionOperandUID());
        if (remainingPermissions != null) {
            Iterator<EOPermission> i = this.addedPermissions.iterator();
            while (i.hasNext()) {
                EOPermission p = i.next();
                if (!p.getOperandType().equals(operand.getPermissionOperandType()) || !p.getOperandUID().equals(operand.getPermissionOperandUID())) continue;
                i.remove();
                this.getModificationCache().removePermission(p);
                remainingPermissions.remove(p);
            }
            this.removedPermissions.addAll(remainingPermissions);
        }
        this.overridePermissions = false;
    }

    public void permissionOwnerDeleted(IPermissionOwner owner) {
        Collection allPermissions = this.getModificationCache().getAllPermissionsOfOwner(owner.getPermissionOwnerType(), owner.getPermissionOwnerID());
        if (allPermissions != null) {
            this.removePermissions(allPermissions);
        }
    }

    @Override
    public void removePermission(IPermissionOwner owner, IPermissionOperand operand, CockpitPermissionTemplate template) {
        EOPermission p = this.getPermission(owner, operand, template);
        if (p != null) {
            this.removePermission(p);
        }
    }

    @Override
    public void removePermission(EOPermission permission) {
        assert (permission != null);
        if (!(this.overridePermissions || this.projectAgent.getFramePermissionChecker().hasPermission("adminPermissions", null, this.operandTree) || this.projectAgent.getFramePermissionChecker().isAdmin())) {
            logger.warn("user has no permission to admin this project's permissions");
            return;
        }
        if (!PSCPermissionConstants.isMandatoryPermission((EOPermission)permission)) {
            boolean wasAdded = false;
            Iterator<EOPermission> i = this.addedPermissions.iterator();
            while (i.hasNext()) {
                EOPermission p = i.next();
                if (!permission.getPermissionUID().equals(p.getPermissionUID())) continue;
                i.remove();
                wasAdded = true;
                break;
            }
            if (!wasAdded) {
                this.removedPermissions.add(permission);
            }
            this.getModificationCache().removePermission(permission);
        }
    }

    public void removePermissions(Collection permissions) {
        for (EOPermission p : permissions) {
            this.removePermission(p);
        }
    }

    public void removePermission(IPermissionOwner owner, IPermissionOperand operand, String operation, String operation2) {
        assert (owner != null);
        assert (operand != null);
        assert (operation != null);
        EOPermission permission = this.getModificationCache().getPermission(owner, operand, operation, operation2);
        if (permission != null) {
            this.removePermission(permission);
        }
    }

    public Collection getAllPermissions() {
        return this.getModificationCache().getAllPermissions();
    }

    @Override
    public boolean ownsPermission(IPermissionOwner owner, IPermissionOperand operand, CockpitPermissionTemplate template) {
        assert (owner != null);
        assert (template != null);
        return this.getPermission(owner, operand, template) != null;
    }

    public boolean ownsPermission(String operation, String operation2, IPermissionOwner owner, IPermissionOperand operand) {
        return this.getModificationCache().getPermission(owner, operand, operation, operation2) != null;
    }

    @Override
    public EOPermission getPermission(IPermissionOwner owner, IPermissionOperand operand, CockpitPermissionTemplate template) {
        assert (owner != null);
        assert (template != null);
        return this.getModificationCache().getPermission(owner, operand, template.getOperation(), template.getOperation2());
    }

    @Override
    public void commit() throws EXServerException, ServerNotAvailableException, UnknownServerException, LoginCanceledException {
        ArrayList<EOPermission> added = new ArrayList<EOPermission>(this.addedPermissions);
        ArrayList<EOPermission> removed = new ArrayList<EOPermission>(this.removedPermissions);
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.projectAgent.getFrameServerProxy().updatePermissions(added, removed);
            this.addedPermissions.clear();
            this.removedPermissions.clear();
            this.modificationCache = null;
            this.allPermissionOwners = null;
            PropertyChanges changes = new PropertyChanges(added, null, removed);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, EOPermission.class);
        }
    }

    @Override
    public void rollback() {
        this.addedPermissions.clear();
        this.removedPermissions.clear();
        this.modificationCache = null;
        this.allPermissionOwners = null;
    }

    @Override
    public boolean hasChanges() {
        return this.addedPermissions.size() > 0 || this.removedPermissions.size() > 0;
    }

    public IFrameProjectAgent getProjectAgent() {
        assert (this.projectAgent != null);
        return this.projectAgent;
    }

    @Override
    public Collection<IPermissionOwner> getAllPermissionOwners() {
        if (this.allPermissionOwners == null) {
            this.allPermissionOwners = this.projectAgent.getFrameServerProxy().getAllPermissionOwners();
        }
        return this.allPermissionOwners;
    }

    public Collection<IPermissionOwner> getAllPermissionOwners(IPermissionOperand operand, Collection templates) {
        ArrayList<IPermissionOwner> owners = new ArrayList<IPermissionOwner>();
        for (IPermissionOwner owner : this.getAllPermissionOwners()) {
            if (!this.getModificationCache().hasPermissionOfTemplate(owner, operand, templates)) continue;
            owners.add(owner);
        }
        return owners;
    }

    @Override
    public void addPermissions(IPermissionOwner owner, IPermissionOperand operand, Collection permissionTemplates) {
        for (CockpitPermissionTemplate template : permissionTemplates) {
            this.addPermission(owner, operand, template);
        }
    }

    @Override
    public void addPermission(IPermissionOwner owner, IPermissionOperand operand, CockpitPermissionTemplate template) {
        if (operand.getPermissionOperandType().equals(template.getOperandType())) {
            EOPermission p = template.createPermission(operand, owner, this.projectAgent.getProjectUID());
            this.addPermission(p);
        } else {
            logger.error("Tried to add permission besides difference in operand type of permission template and operand.");
        }
    }

    @Override
    public CockpitPermissionTemplate getTemplate(EOPermission permission) {
        String operation = permission.getOperation();
        if (operation.startsWith("modifyAttribute_")) {
            String attributeTypeID = operation.substring("modifyAttribute_".length());
            return new AttributeModificationPermissionTemplate(attributeTypeID, permission.getOperation2(), permission.getOperandType());
        }
        Collection<CockpitPermissionTemplate> templates = this.getAllPermissionTemplates();
        for (CockpitPermissionTemplate o : templates) {
            CockpitPermissionTemplate template = o;
            if (!template.isOfTemplate(permission)) continue;
            return template;
        }
        return null;
    }

    private Collection<CockpitPermissionTemplate> getAllPermissionTemplates() {
        if (this.allTemplates == null) {
            this.allTemplates = new ArrayList<CockpitPermissionTemplate>();
            this.allTemplateLabelProviders = new ArrayList<ILabelProvider>();
            Collection<IProjectPermissionsGroup> extensions = this.readAllProjectPermissionsTemplateProvider();
            for (IProjectPermissionsGroup provider : extensions) {
                this.allTemplates.addAll(provider.getTemplates(this.getProjectAgent()));
                this.allTemplateLabelProviders.add(provider.getTemplatesLabelProvider(this.getProjectAgent()));
            }
        }
        return this.allTemplates;
    }

    @Override
    public String getLabel(CockpitPermissionTemplate template) {
        if (this.allTemplateLabelProviders == null) {
            this.getAllPermissionTemplates();
        }
        for (ILabelProvider element : this.allTemplateLabelProviders) {
            ILabelProvider labelProvider = element;
            String label = labelProvider.getText((Object)template);
            if (label == null) continue;
            return label;
        }
        return null;
    }

    @Override
    public Collection<IProjectPermissionsGroup> readAllProjectPermissionsTemplateProvider() {
        ArrayList<IProjectPermissionsGroup> templateGroups = new ArrayList<IProjectPermissionsGroup>();
        ArrayList<IProjectPermissionsGroup> providers = new ArrayList<IProjectPermissionsGroup>(ExtensionMgr.getDefault().getExtension("projectpermissionsadmin", EXTENSIONPOINT_ELEMENT_NAME, EXTENSIONPOINT_ATTRIBUTE_NAME, IProjectPermissionsGroup.class));
        providers.addAll(this.projectAgent.getModuleController().getAllProjectPermissionTemplates1(this.projectAgent));
        for (IProjectPermissionsGroup tp : providers) {
            templateGroups.add(tp);
        }
        return templateGroups;
    }
}

