/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links.linktypes;

import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkCardinality;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import de.plans.lib.util.collections.ArrayUtil;

public class LinkType
implements ILinkType {
    private final String UID;
    private final String displayName;
    private final String loProviderID;
    private final String moduleDataID;
    private final ILinkCardinality cardinality;
    private final boolean isAttributeLinkType;
    private final boolean isModificationToBeDisplayedToTheUser;
    private int lockingBehaviour;
    private final String moduleID;
    private final String correspondingLinkTypeID;

    public LinkType(String UID, String displayName, String linkableObjectDataTypeID, String moduleDataTypeID, ILinkCardinality cardinality, String moduleID, String correspondingLinkTypeID, boolean isAttributeLinkType, boolean isModificationToBeDisplayedToTheUser) {
        assert (UID != null) : "UID must not be null";
        assert (UID.length() < 256);
        assert (linkableObjectDataTypeID != null) : "loProvider must not be null";
        assert (cardinality != null) : "cardinality must not be null";
        assert (moduleID != null) : "module id must not be null";
        this.UID = UID;
        this.displayName = displayName;
        this.loProviderID = linkableObjectDataTypeID;
        this.cardinality = cardinality;
        this.lockingBehaviour = cardinality.getPreferredLockingBehaviour();
        this.moduleID = moduleID;
        this.correspondingLinkTypeID = correspondingLinkTypeID;
        this.moduleDataID = moduleDataTypeID;
        this.isAttributeLinkType = isAttributeLinkType;
        this.isModificationToBeDisplayedToTheUser = isModificationToBeDisplayedToTheUser;
    }

    public void setLockingBehaviour(int lockingBehaviour) {
        assert (ArrayUtil.isIntValueOf((int)lockingBehaviour, (int[])ILinkType.LOCKING_BEHAVIOURS)) : "invalid locking behaviour";
        this.lockingBehaviour = lockingBehaviour;
    }

    @Override
    public String getUID() {
        return this.UID;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public int getLockingBehaviour() {
        return this.lockingBehaviour;
    }

    @Override
    public String getLinkableObjectTypeID() {
        return this.loProviderID;
    }

    @Override
    public ILinkCardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public String getModuleID() {
        return this.moduleID;
    }

    @Override
    public String getCorrespondingLinkTypeID() {
        return this.correspondingLinkTypeID;
    }

    @Override
    public String getModuleDataTypeID() {
        return this.moduleDataID;
    }

    @Override
    public boolean isAttributeLinkType() {
        return this.isAttributeLinkType;
    }

    @Override
    public boolean isModificationToBeDisplayedToTheUser() {
        return this.isModificationToBeDisplayedToTheUser;
    }
}

