/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.EONumberFilterValue;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EODouble;

public class EODoubleFilterValue
extends EONumberFilterValue {
    private static final ILogger logger = Logger.getLogger(EODoubleFilterValue.class);
    public static final String XML_NAME = "frame.datatypes.doublefiltervalue";
    public static final EODoubleFilterValue STANDARD_FILTER_VALUE = new EODoubleFilterValue(0.0, 0.0, 1);

    public EODoubleFilterValue() {
        super(XML_NAME);
    }

    public EODoubleFilterValue(double double1, double double2) {
        super(XML_NAME, new Double(double1), new Double(double2));
    }

    public EODoubleFilterValue(double double1, double double2, int filterMethod) {
        super(XML_NAME, new Double(double1), new Double(double2), filterMethod);
    }

    public EODoubleFilterValue(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    public EONumberFilterValue getStandardValue() {
        return STANDARD_FILTER_VALUE;
    }

    @Override
    protected void writeChild(Number number, String role, EncodableObjectBase.WriteContext context, int depth) throws EXEncoderException {
        EODouble child1 = new EODouble(new Double(number.doubleValue()), role);
        child1.writeXMLBody(context, depth);
    }

    @Override
    protected Number extractValue(EncodableObjectBase eo) throws ClassCastException {
        return ((EODouble)eo).getValue();
    }
}

