/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ClientMessageDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.EONumberFilterValue;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.NumberVerifyListener;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.util.Arrays;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AttributeNumberFilterItem
extends AbstractFilterItem {
    private static final ILogger logger = Logger.getLogger(AttributeNumberFilterItem.class);
    private final AbstractFilter filter;
    private EONumberFilterValue value;
    IAttributeTypeDataType dataType;
    private Combo filterMethodCombo;
    private Text val1Text;
    private Text val2Text;
    private static final ClientMessageDataFactory factory = ClientMessageDataFactory.getInstance();
    private static final XMLDecoder decoder = new XMLDecoder();
    public static final int FILTER_METHOD_LESS = 0;
    public static final int FILTER_METHOD_GREATER = 1;
    public static final int FILTER_METHOD_BETWEEN = 2;
    public static final int FILTER_METHOD_EQUALS = 3;
    private static final int[] METHODS;
    private static final String METHOD_NAME_LESS = "<=";
    private static final String METHOD_NAME_GREATER = ">=";
    private static final String METHOD_NAME_BETWEEN;
    private static final String METHOD_NAME_EQUALS = "=";
    private static final String[] METHOD_NAMES;
    private String standardFilterValueString = null;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        METHODS = nArray;
        METHOD_NAME_BETWEEN = Messages.getString("AttributeIntegerFilterItem.FiulterMethodBetween");
        METHOD_NAMES = new String[]{METHOD_NAME_LESS, METHOD_NAME_GREATER, METHOD_NAME_BETWEEN, METHOD_NAME_EQUALS};
    }

    public AttributeNumberFilterItem(String name, AbstractFilter filter, IAttributeTypeDataType dataType) {
        super(name, filter);
        this.filter = filter;
        this.dataType = dataType;
        this.value = this.convertFromXMLString(filter.getFilterValue());
    }

    private EONumberFilterValue convertFromXMLString(String xmlString) {
        try {
            return (EONumberFilterValue)decoder.decodeXML(xmlString, (IEncodableObjectFactory)factory, true);
        }
        catch (EXDecoderException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public void doConfirmSelection() {
        try {
            this.filter.setFilterValue(this.value != null ? this.value.toXMLString(false) : this.getStandardFilterValueXmlString());
        }
        catch (ExInvalidDataType e) {
            logger.error((Throwable)e);
        }
        catch (EXEncoderException e) {
            logger.error("Could not set filter Value", (Throwable)e);
        }
    }

    public void resetFilterValueToFilterState() {
        this.value = this.convertFromXMLString(this.filter.getFilterValue());
    }

    public void refresh() {
        this.filterMethodCombo.select(Arrays.binarySearch(METHODS, this.value.getFilterMethod()));
        this.val1Text.setText(this.value.getVal1().toString());
        this.val2Text.setText(this.value.getVal2().toString());
        this.enableValueFields();
    }

    public void filterHasChanged() {
        this.value = this.convertFromXMLString(this.filter.getFilterValue());
    }

    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        String filterInfo = String.valueOf(METHOD_NAMES[this.value.getFilterMethod()]) + " " + this.val1Text.getText();
        if (this.value.getFilterMethod() == 2) {
            filterInfo = String.valueOf(filterInfo) + Messages.getString("AttributeIntegerFilterItem.AND") + this.val2Text.getText();
        }
        return filterInfo;
    }

    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        groupGD.widthHint = 200;
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        this.filterMethodCombo = new Combo((Composite)group, 12);
        GridData filterMethodComboGD = new GridData();
        filterMethodComboGD.widthHint = 50;
        this.filterMethodCombo.setLayoutData((Object)filterMethodComboGD);
        String[] stringArray = METHOD_NAMES;
        int n = METHOD_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.filterMethodCombo.add(element);
            ++n2;
        }
        this.filterMethodCombo.select(2);
        this.filterMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeNumberFilterItem.this.enableValueFields();
                AttributeNumberFilterItem.this.updateFilter();
                AttributeNumberFilterItem.this.fireValueChanged();
            }
        });
        this.val1Text = new Text((Composite)group, 2052);
        GridData firstDateTextGD = new GridData();
        firstDateTextGD.widthHint = 75;
        this.val1Text.setLayoutData((Object)firstDateTextGD);
        this.val1Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AttributeNumberFilterItem.this.val1Text.selectAll();
            }

            public void focusLost(FocusEvent e) {
                AttributeNumberFilterItem.this.updateFilter();
                AttributeNumberFilterItem.this.fireValueChanged();
            }
        });
        this.val1Text.addVerifyListener((VerifyListener)this.createVerifyListener(this.val1Text));
        this.val2Text = new Text((Composite)group, 2052);
        GridData secondDateTextGD = new GridData();
        secondDateTextGD.widthHint = 75;
        secondDateTextGD.horizontalSpan = 2;
        secondDateTextGD.horizontalAlignment = 3;
        this.val2Text.setLayoutData((Object)secondDateTextGD);
        this.val2Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AttributeNumberFilterItem.this.val2Text.selectAll();
            }

            public void focusLost(FocusEvent e) {
                AttributeNumberFilterItem.this.updateFilter();
                AttributeNumberFilterItem.this.fireValueChanged();
            }
        });
        this.val2Text.addVerifyListener((VerifyListener)this.createVerifyListener(this.val2Text));
        this.refresh();
        return group;
    }

    private void updateFilter() {
        this.setSelected(this.val1Text.getText().length() > 0);
        try {
            Number number1 = this.parse(this.val1Text.getText());
            Number number2 = null;
            if (this.val2Text.isVisible()) {
                number2 = this.parse(this.val2Text.getText());
            }
            this.value.setVal1(number1);
            if (this.val2Text.isVisible()) {
                this.value.setVal2(number2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.value.setFilterMethod(METHODS[this.filterMethodCombo.getSelectionIndex()]);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    public boolean isAllFilterValuesSet() {
        return !this.isNoFilterValuesSet();
    }

    public boolean isNoFilterValuesSet() {
        return this.val1Text.getText().length() == 0;
    }

    private void enableValueFields() {
        this.val2Text.setVisible(this.filterMethodCombo.getText().equals(METHOD_NAME_BETWEEN));
    }

    protected abstract EONumberFilterValue getStandardFilterValue();

    protected abstract Number parse(String var1) throws NumberFormatException;

    protected abstract NumberVerifyListener createVerifyListener(Text var1);

    private String getStandardFilterValueXmlString() throws EXEncoderException {
        if (this.standardFilterValueString == null) {
            this.standardFilterValueString = this.getStandardFilterValue().toXMLString(false);
        }
        return this.standardFilterValueString;
    }
}

