/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.ISWTControlModifiedListener;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ValueRangeEnumeration;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.shared.message.EOContainer;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.java.ObjectWrapper;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ValueRangeDefinerEnumeration
implements IValueRangeDefiner {
    private final IAttributeTypeDataType baseDataType;
    private final IValueRange baseValueRange;
    private final boolean tolerant;
    private final Map swtListeners = new HashMap();

    public ValueRangeDefinerEnumeration(IAttributeTypeDataType baseDataType, IValueRange baseValueRange, boolean tolerant) {
        this.baseDataType = baseDataType;
        this.baseValueRange = baseValueRange;
        this.tolerant = tolerant;
    }

    public Control createSWTControl(Composite parent, int height, IValueRangeDefiner.IValueDeletionPolicy valueDeletionPolicy) {
        GridData gridData;
        EntriesList entriesList = new EntriesList(parent, valueDeletionPolicy);
        if (height == -1) {
            gridData = new GridData(4, 4, true, true);
            gridData.minimumHeight = 150;
        } else {
            gridData = new GridData(4, 1, true, false);
            gridData.heightHint = height;
        }
        entriesList.setLayoutData(gridData);
        return entriesList;
    }

    public void setContentForSWTControl(Control control, IValueRange valueRange) {
        Object vr = valueRange.getValueRange();
        if (!(vr instanceof List)) {
            throw new ExInvalidDataType(vr.getClass().toString(), List.class.toString());
        }
        if (!(control instanceof EntriesList)) {
            throw new ExInvalidDataType(control.getClass().toString(), EntriesList.class.toString());
        }
        List values = (List)vr;
        EntriesList entriesList = (EntriesList)control;
        for (EnumerationEntry entry : values) {
            EnumerationEntry entryCopy = new EnumerationEntry(entry);
            entriesList.addEntry(entryCopy);
        }
    }

    public void addSWTControlModifiedListener(Control control, ISWTControlModifiedListener listener) {
        ArrayList<ISWTControlModifiedListener> listeners = (ArrayList<ISWTControlModifiedListener>)this.swtListeners.get(control);
        if (listeners == null) {
            listeners = new ArrayList<ISWTControlModifiedListener>();
            this.swtListeners.put(control, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public IValueRange getValueRangeFromSWTControl(Control swtControl) {
        if (!(swtControl instanceof EntriesList)) {
            throw new ExInvalidDataType(swtControl.getClass().toString(), EntriesList.class.toString());
        }
        EntriesList entriesList = (EntriesList)swtControl;
        return new ValueRangeEnumeration(entriesList.getEntries());
    }

    public EOEncodableObject getValueAsEO(IValueRange valueRange, IValueRange currentBaseValueRange) {
        Object vr = valueRange.getValueRange();
        if (!(vr instanceof List)) {
            throw new ExInvalidDataType(vr.getClass().toString(), List.class.toString());
        }
        IValueRange baseValueRangeToUse = this.baseValueRange;
        if (baseValueRangeToUse == null) {
            baseValueRangeToUse = currentBaseValueRange;
        }
        EOList eoList = new EOList();
        List values = (List)vr;
        for (EnumerationEntry entry : values) {
            EnumerationEntry bestMatch;
            EnumerationEntry enumerationEntry = bestMatch = baseValueRangeToUse == null ? null : this.getBestMatch(entry, baseValueRangeToUse);
            if (bestMatch == null) {
                bestMatch = entry;
            }
            EOEncodableObject eoValue = this.baseDataType.getValueAsEO(bestMatch.getValue(), null);
            EOContainer eo = new EOContainer(entry.getID(), eoValue);
            eoList.add((EncodableObjectBase)eo);
        }
        return eoList;
    }

    public IValueRange getEOAsValueRange(EOEncodableObject eo) {
        if (!(eo instanceof EOList)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOList.class.toString());
        }
        EOList eoList = (EOList)eo;
        ArrayList<EnumerationEntry> list = new ArrayList<EnumerationEntry>();
        for (EOContainer container : eoList) {
            Object value = this.baseDataType.getEOAsValue(container.getContent());
            EnumerationEntry entry = new EnumerationEntry(container.getRole(), value);
            list.add(entry);
        }
        return new ValueRangeEnumeration(list);
    }

    public boolean isInValueRange(Object value, IValueRange valueRange) {
        Object vr = valueRange.getValueRange();
        if (!(vr instanceof List)) {
            throw new ExInvalidDataType(vr.getClass().toString(), List.class.toString());
        }
        if (!(value instanceof Collection)) {
            throw new ExInvalidDataType(value.getClass().toString(), Collection.class.toString());
        }
        if (!this.tolerant) {
            List allowedElements = (List)vr;
            Collection selectedElements = (Collection)value;
            return allowedElements.containsAll(selectedElements);
        }
        return true;
    }

    public IValueRangeDefiner.IValueDeletionPolicy getValueDeletionPolicyForOnlyIfNotInUse(IProjectAgent projectAgent, IAttributeType attributeType) {
        return new ValueDeletionPolicy_IfNotInUse((IFrameProjectAgent)projectAgent, attributeType);
    }

    public List<EnumerationEntry> getAllowedValues(IValueRange valueRange) {
        return (List)valueRange.getValueRange();
    }

    public EnumerationEntry getBestMatch(EnumerationEntry entry, IValueRange valueRange) {
        List valueRange_ = (List)valueRange.getValueRange();
        int indexOfEntryWithSameID = valueRange_.indexOf(entry);
        if (indexOfEntryWithSameID >= 0) {
            return (EnumerationEntry)valueRange_.get(indexOfEntryWithSameID);
        }
        for (EnumerationEntry entryFromValueRange : valueRange_) {
            if (!entryFromValueRange.getValue().equals(entry.getValue())) continue;
            return entryFromValueRange;
        }
        return null;
    }

    private void informListeners(Control control, Object newValue) {
        Collection listeners = (Collection)this.swtListeners.get(control);
        if (listeners != null) {
            for (ISWTControlModifiedListener listener : listeners) {
                listener.modified(newValue, null);
            }
        }
    }

    public IAttributeTypeDataType getBaseDataType() {
        return this.baseDataType;
    }

    class AddEntryDialog
    extends Dialog {
        private IAttributeTypeDataType.ISWTControlForModification control;
        private Object startValue;
        private Object entryValue;

        public AddEntryDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public AddEntryDialog(Object startValue, Shell parentShell) {
            this(parentShell);
            this.startValue = startValue;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(String.valueOf(Messages.getString("DataTypeEnumeration.enter")) + ValueRangeDefinerEnumeration.this.baseDataType.getDisplayName() + " ...");
            Composite base = new Composite(parent, 0);
            GridData gridData = new GridData(1808);
            base.setLayoutData((Object)gridData);
            base.setLayout((Layout)new GridLayout());
            Label dummy = new Label(base, 0);
            dummy.setText(String.valueOf(this.getShell().getText()) + "This sucks! And fuck MS!");
            dummy.setVisible(false);
            ISWTControlModifiedListener listener = new ISWTControlModifiedListener(){

                public void modified(Object newValue, Object additionalInfo) {
                    AddEntryDialog.this.entryValue = newValue;
                }

                public void setModificationInProgress(boolean modificationInProgress) {
                }
            };
            this.control = this.startValue != null ? ValueRangeDefinerEnumeration.this.baseDataType.createSWTControlForModifying(base, Collections.singleton(listener), this.startValue, null) : ValueRangeDefinerEnumeration.this.baseDataType.createSWTControlForModifying(base, Collections.singleton(listener), null);
            gridData = new GridData(768);
            gridData.heightHint = ValueRangeDefinerEnumeration.this.baseDataType.getSWTHeightHint();
            this.control.getControl().setLayoutData((Object)gridData);
            return base;
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected void cancelPressed() {
            this.entryValue = null;
            super.cancelPressed();
        }

        public Object getEntryValue() {
            return this.entryValue;
        }

        public void dispose() {
            this.control.dispose();
        }
    }

    private class DeleteAction
    extends Action {
        private final EntriesList valueRangeWidget;
        private final org.eclipse.swt.widgets.List swtListWidget;
        private final List<EnumerationEntry> valuesList;
        private final IValueRangeDefiner.IValueDeletionPolicy valueDeletionPolicy;

        public DeleteAction(EntriesList valueRangeWidget, org.eclipse.swt.widgets.List swtListWidget, List<EnumerationEntry> valuesList, IValueRangeDefiner.IValueDeletionPolicy valueDeletionPolicy) {
            this.valueRangeWidget = valueRangeWidget;
            this.swtListWidget = swtListWidget;
            this.valuesList = valuesList;
            this.valueDeletionPolicy = valueDeletionPolicy;
            this.setText(Messages.getString("AbstractDataTypeEnumeration.delete"));
        }

        public boolean update() {
            boolean enablement = this.swtListWidget.getSelectionIndex() > -1;
            this.setEnabled(enablement);
            return enablement;
        }

        public void run() {
            int index = this.swtListWidget.getSelectionIndex();
            if (index > -1) {
                String errorMessage = this.valueDeletionPolicy.mayValueBeDeleted(this.valuesList.get(index));
                if (errorMessage == null) {
                    this.swtListWidget.remove(index);
                    this.valuesList.remove(index);
                    ValueRangeDefinerEnumeration.this.informListeners((Control)this.valueRangeWidget, this.valueRangeWidget.getEntries());
                } else {
                    MessageDialog.openError((Shell)this.swtListWidget.getShell(), (String)Messages.getString("ValueRangeDefinerEnumeration.ValueCantBeDeleted.Title"), (String)errorMessage);
                }
            }
        }
    }

    private class EntriesList
    extends Composite {
        private final List<EnumerationEntry> entries;
        private final org.eclipse.swt.widgets.List list;
        private final Button btnAdd;
        private final Button btnDeleteProperty;
        private final Button btnMoveUpProperty;
        private final Button btnMoveDownProperty;
        private final Button btnEditProperty;
        private final DeleteAction deleteAction;
        private final MoveUpAction moveUpAction;
        private final MoveDownAction moveDownAction;
        private final ModifyEntryAction modifyEntryAction;
        private boolean baseEnablement;

        public EntriesList(Composite parent, IValueRangeDefiner.IValueDeletionPolicy valueDeletionPolicy) {
            super(parent, 0);
            this.entries = new ArrayList<EnumerationEntry>();
            this.baseEnablement = true;
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.list = new org.eclipse.swt.widgets.List((Composite)this, 2816);
            GridData gridData = new GridData(4, 4, true, true);
            this.list.setLayoutData((Object)gridData);
            this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EntriesList.this.updateButtonEnablement();
                }
            });
            Composite buttonComposite = new Composite((Composite)this, 0);
            GridLayoutFactory.fillDefaults().applyTo(buttonComposite);
            GridDataFactory.fillDefaults().align(4, 4).grab(false, true).applyTo((Control)buttonComposite);
            this.btnAdd = new Button(buttonComposite, 0);
            this.btnAdd.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnAdd.setImage(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/add_obj.gif").createImage());
            this.btnAdd.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddEntryDialog dialog = new AddEntryDialog(EntriesList.this.getShell());
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    Object value = dialog.getEntryValue();
                    if (value != null) {
                        boolean valueAlreadyInList = false;
                        Comparator comparator = ValueRangeDefinerEnumeration.this.baseDataType.getComparator(ValueRangeDefinerEnumeration.this.baseValueRange);
                        for (EnumerationEntry alreadySetValue : EntriesList.this.entries) {
                            if (comparator.compare(value, alreadySetValue.getValue()) != 0) continue;
                            valueAlreadyInList = true;
                            break;
                        }
                        if (!valueAlreadyInList) {
                            EnumerationEntry newEntry = new EnumerationEntry(UUIDGenerator.getUniqueID(), value);
                            EntriesList.this.addEntry(newEntry);
                            ValueRangeDefinerEnumeration.this.informListeners((Control)EntriesList.this, EntriesList.this.getEntries());
                        }
                    }
                    dialog.dispose();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.deleteAction = new DeleteAction(this, this.list, this.entries, valueDeletionPolicy);
            this.btnDeleteProperty = new Button(buttonComposite, 0);
            this.btnDeleteProperty.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnDeleteProperty.setImage(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/rem_obj.gif").createImage());
            this.btnDeleteProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EntriesList.this.deleteAction.run();
                    EntriesList.this.updateButtonEnablement();
                }
            });
            new Label(buttonComposite, 0);
            GridDataFactory.fillDefaults().align(4, 1).grab(false, false);
            this.moveUpAction = new MoveUpAction(this, this.list, this.entries);
            this.btnMoveUpProperty = new Button(buttonComposite, 0);
            this.btnMoveUpProperty.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnMoveUpProperty.setImage(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/arrow_up.gif").createImage());
            this.btnMoveUpProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EntriesList.this.moveUpAction.run();
                    EntriesList.this.updateButtonEnablement();
                }
            });
            this.moveDownAction = new MoveDownAction(this, this.list, this.entries);
            this.btnMoveDownProperty = new Button(buttonComposite, 0);
            this.btnMoveDownProperty.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnMoveDownProperty.setImage(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/arrow_down.gif").createImage());
            this.btnMoveDownProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EntriesList.this.moveDownAction.run();
                    EntriesList.this.updateButtonEnablement();
                }
            });
            new Label(buttonComposite, 0);
            GridDataFactory.fillDefaults().align(4, 1).grab(false, false);
            this.modifyEntryAction = new ModifyEntryAction(this);
            this.btnEditProperty = new Button(buttonComposite, 0);
            this.btnEditProperty.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnEditProperty.setImage(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/pencil.png").createImage());
            this.btnEditProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EntriesList.this.modifyEntryAction.run();
                    EntriesList.this.updateButtonEnablement();
                }
            });
            this.updateButtonEnablement();
        }

        public void setEnabled(boolean enabled) {
            this.list.setEnabled(enabled);
            this.baseEnablement = enabled;
            this.updateButtonEnablement();
        }

        public void updateButtonEnablement() {
            this.btnAdd.setEnabled(this.baseEnablement);
            if (this.baseEnablement) {
                this.btnDeleteProperty.setEnabled(this.deleteAction.update());
                this.btnMoveUpProperty.setEnabled(this.moveUpAction.upDate());
                this.btnMoveDownProperty.setEnabled(this.moveDownAction.upDate());
                this.btnEditProperty.setEnabled(this.modifyEntryAction.update());
            } else {
                this.btnDeleteProperty.setEnabled(false);
                this.btnMoveUpProperty.setEnabled(false);
                this.btnMoveDownProperty.setEnabled(false);
                this.btnEditProperty.setEnabled(false);
            }
        }

        public void addEntry(EnumerationEntry entry) {
            String str = ValueRangeDefinerEnumeration.this.baseDataType.getValueAsSingleLineString(entry.getValue(), null, " ", Locale.getDefault());
            this.list.add(str);
            this.entries.add(entry);
            this.updateButtonEnablement();
        }

        public List<EnumerationEntry> getEntries() {
            return this.entries;
        }
    }

    private class ModifyEntryAction
    extends Action {
        private final EntriesList entriesList;

        public ModifyEntryAction(EntriesList entriesList) {
            this.entriesList = entriesList;
            this.setText(Messages.getString("ValueRangeHelperEnumeration.edit"));
        }

        public boolean update() {
            boolean enabled = this.entriesList.list.getSelectionIndex() > -1;
            this.setEnabled(enabled);
            return enabled;
        }

        public void run() {
            int index = this.entriesList.list.getSelectionIndex();
            if (index > -1) {
                EnumerationEntry entry = (EnumerationEntry)this.entriesList.entries.get(index);
                AddEntryDialog dialog = new AddEntryDialog(entry.getValue(), this.entriesList.getShell());
                dialog.open();
                Object newValue = dialog.getEntryValue();
                if (newValue != null && !newValue.equals(entry.getValue())) {
                    this.entriesList.list.setItem(index, ValueRangeDefinerEnumeration.this.baseDataType.getValueAsSingleLineString(newValue, null, "", Locale.getDefault()));
                    entry.setValue(newValue);
                    ValueRangeDefinerEnumeration.this.informListeners((Control)this.entriesList, this.entriesList.getEntries());
                }
                dialog.dispose();
            }
        }
    }

    private class MoveDownAction
    extends Action {
        private final EntriesList entriesList;
        private final org.eclipse.swt.widgets.List swtList;
        private final List<EnumerationEntry> utilList;

        public MoveDownAction(EntriesList entriesList, org.eclipse.swt.widgets.List swtList, List<EnumerationEntry> utilList) {
            this.entriesList = entriesList;
            this.swtList = swtList;
            this.utilList = utilList;
            this.setText(Messages.getString("AbstractDataTypeEnumeration.move_down"));
        }

        public boolean upDate() {
            int index = this.swtList.getSelectionIndex();
            boolean enablement = index > -1 && index < this.swtList.getItemCount() - 1;
            this.setEnabled(enablement);
            return enablement;
        }

        public void run() {
            int index = this.swtList.getSelectionIndex();
            if (index > -1 && index < this.swtList.getItemCount()) {
                String tmpString = this.swtList.getItem(index);
                EnumerationEntry tmpObject = this.utilList.get(index);
                this.swtList.setItem(index, this.swtList.getItem(index + 1));
                this.utilList.set(index, this.utilList.get(index + 1));
                this.swtList.setItem(index + 1, tmpString);
                this.utilList.set(index + 1, tmpObject);
                this.swtList.select(index + 1);
                ValueRangeDefinerEnumeration.this.informListeners((Control)this.entriesList, this.entriesList.getEntries());
            }
        }
    }

    private class MoveUpAction
    extends Action {
        private final EntriesList entriesList;
        private final org.eclipse.swt.widgets.List swtList;
        private final List<EnumerationEntry> utilList;

        public MoveUpAction(EntriesList entriesList, org.eclipse.swt.widgets.List swtList, List<EnumerationEntry> utilList) {
            this.entriesList = entriesList;
            this.swtList = swtList;
            this.utilList = utilList;
            this.setText(Messages.getString("AbstractDataTypeEnumeration.move_up"));
        }

        public boolean upDate() {
            boolean enablement = this.swtList.getSelectionIndex() > 0;
            this.setEnabled(enablement);
            return enablement;
        }

        public void run() {
            int index = this.swtList.getSelectionIndex();
            if (index > 0) {
                String tmpString = this.swtList.getItem(index);
                EnumerationEntry tmpObject = this.utilList.get(index);
                this.swtList.setItem(index, this.swtList.getItem(index - 1));
                this.utilList.set(index, this.utilList.get(index - 1));
                this.swtList.setItem(index - 1, tmpString);
                this.utilList.set(index - 1, tmpObject);
                this.swtList.select(index - 1);
                ValueRangeDefinerEnumeration.this.informListeners((Control)this.entriesList, this.entriesList.getEntries());
            }
        }
    }

    private static final class ValueDeletionPolicy_IfNotInUse
    implements IValueRangeDefiner.IValueDeletionPolicy {
        private final IFrameProjectAgent projectAgent;
        private final IAttributeType attributeType;

        public ValueDeletionPolicy_IfNotInUse(IFrameProjectAgent projectAgent, IAttributeType attributeType) {
            this.projectAgent = projectAgent;
            this.attributeType = attributeType;
        }

        public boolean isDeletionPossibleInGeneral() {
            return true;
        }

        public String mayValueBeDeleted(final EnumerationEntry value) {
            final String cockpitTypeID = this.attributeType.getCockpitDataType().getCockpitDataTypeID();
            IFrameDataManager dataManager = this.projectAgent.getDataManager(cockpitTypeID);
            final ObjectWrapper isInUse = new ObjectWrapper((Object)Boolean.FALSE);
            dataManager.visitAllAttributeOwnerRWs(new IAttributeOwnerRW.IVisitor(){

                @Override
                public void visit(IAttributeOwnerRW attributeOwnerRW) {
                    IAttribute attribute;
                    if (cockpitTypeID.equals(attributeOwnerRW.getTypeID()) && (attribute = attributeOwnerRW.getAttribute(attributeType.getAttributeTypeID())) != null) {
                        for (EnumerationEntry valueSetInObject : (Collection)attribute.getAttributeValue()) {
                            if (!valueSetInObject.getID().equals(value.getID())) continue;
                            isInUse.setWrappedObject((Object)Boolean.TRUE);
                            break;
                        }
                    }
                }
            });
            if (((Boolean)isInUse.getWrappedObject()).booleanValue()) {
                return Messages.getString("ValueRangeDefinerEnumeration.ValueCantBeDeleted.Message");
            }
            return null;
        }
    }
}

