/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datamanager;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameDataCache<T extends ICockpitProjectData> {
    private final Map<String, T> containedData = new HashMap<String, T>();

    public FrameDataCache() {
    }

    public FrameDataCache(Collection<? extends T> dataItems) {
        this.putDataItems(dataItems);
    }

    public void putDataItem(T dataItem) {
        this.containedData.put(dataItem.getUID(), dataItem);
    }

    public void putDataItems(Collection<? extends T> dataItems) {
        for (ICockpitProjectData dataItem : dataItems) {
            this.containedData.put(dataItem.getUID(), dataItem);
        }
    }

    public void removeDataItem(T dataItem) {
        this.containedData.remove(dataItem.getUID());
    }

    public void removeDataItems(Collection<? extends T> dataItems) {
        for (ICockpitProjectData dataItem : dataItems) {
            this.containedData.remove(dataItem.getUID());
        }
    }

    public Collection<? extends T> getAllDataItems() {
        return this.containedData.values();
    }

    public T getData(String uID) {
        return (T)((ICockpitProjectData)this.containedData.get(uID));
    }
}

