/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import org.eclipse.jface.dialogs.IInputValidator;

public class RenameDataValidator
implements IInputValidator {
    private final IFrameProjectAgent projectAgent;
    private final IFrameDataManager parentManager;
    private final IAttributeOwner parent;
    private final String newDataTypeID;
    private IFrameDataRW dataToRename;

    public RenameDataValidator(String dataTypeID, IAttributeOwner parent, IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.parent = parent;
        this.parentManager = projectAgent.getDataManager(parent.getTypeID());
        this.newDataTypeID = dataTypeID;
    }

    public RenameDataValidator(IFrameDataRW dataToRename, IFrameProjectAgent projectAgent) {
        IFrameDataManager dataManager = projectAgent.getDataManager(dataToRename.getTypeID());
        this.parent = dataManager.getParent(dataToRename);
        this.projectAgent = projectAgent;
        this.parentManager = projectAgent.getDataManager(this.parent.getTypeID());
        this.newDataTypeID = dataToRename.getTypeID();
        this.dataToRename = dataToRename;
    }

    public String isValid(String p_newText) {
        String newText = p_newText == null ? "" : p_newText.trim();
        if (newText.length() == 0) {
            return Messages.getString("RenameDataValidator.name_must_contain_one_char");
        }
        for (IAttributeOwner iAttributeOwner : this.parentManager.getChildren(this.parent)) {
            IFrameDataManager childManager;
            IDataLabelProvider childLabelProvider;
            String childName;
            IFrameDataRW child;
            if (!(iAttributeOwner instanceof IFrameDataRW) || (child = (IFrameDataRW)iAttributeOwner) == this.dataToRename || !child.getTypeID().equals(this.newDataTypeID) || !(childName = (childLabelProvider = (childManager = this.projectAgent.getDataManager(child.getTypeID())).getDataLabelProvider()).getText((Object)child)).equalsIgnoreCase(newText)) continue;
            return String.valueOf(Messages.getString("RenameDataValidator.there_is_already_a1")) + childLabelProvider.getTypeDisplayName(child.getTypeID()) + Messages.getString("RenameDataValidator.there_is_already_a2") + newText + Messages.getString("RenameDataValidator.there_is_already_a3");
        }
        return null;
    }
}

