/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IModuleStakeholderManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListenerManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesProviderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileTransactionManagerInitialisationFailed;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dnd.DNDManager;
import com.arcway.cockpit.frame.client.global.gui.dnd.IDNDManager;
import com.arcway.cockpit.frame.client.global.gui.dnd.IModuleDNDManager;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectView;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.ILocalClientProductLicenseManager;
import com.arcway.cockpit.frame.client.project.CockpitController;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.FrameLinkManager;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameCockpitController;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFramePermissionManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameReportOutputTemplateManager;
import com.arcway.cockpit.frame.client.project.IFrameReportTemplateFolderManager;
import com.arcway.cockpit.frame.client.project.IFrameReportTemplateManager;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.IFrameStakeholderManager;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectOpenListener;
import com.arcway.cockpit.frame.client.project.IServerDataContainerProcessor;
import com.arcway.cockpit.frame.client.project.IUniqueElementRelationshipManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ModelTransactionManager;
import com.arcway.cockpit.frame.client.project.ModificationRootItem;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.ProjectMetaDataManager;
import com.arcway.cockpit.frame.client.project.core.ChildRelationsManager;
import com.arcway.cockpit.frame.client.project.core.CommitMgr;
import com.arcway.cockpit.frame.client.project.core.IChildRelationsManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoriesManager;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FilesManager;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataAttributeTypesProviderMgr;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeImage;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockMgr;
import com.arcway.cockpit.frame.client.project.core.permissions.ProjectPermissionChecker;
import com.arcway.cockpit.frame.client.project.core.permissions.ProjectPermissionModificationModel;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportOutputTemplatesManager;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateFoldersManager;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplatesManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.ISectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ExRetryProjectOpen;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipMgr;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.datainterchange.FrameImportExportManager;
import com.arcway.cockpit.frame.client.project.datainterchange.IFrameExportDataProvider;
import com.arcway.cockpit.frame.client.project.datainterchange.IFrameImporter;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.DocGenerationAction;
import com.arcway.cockpit.frame.client.project.editors.EditorsListSelectionDialog;
import com.arcway.cockpit.frame.client.project.exceptions.EXApplicationOfAsynchronousUpdatesHungUp;
import com.arcway.cockpit.frame.client.project.modules.IModuleLinkManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleLockManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleSectionManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleServerProxy;
import com.arcway.cockpit.frame.client.project.modules.IModuleUniqueElementManager;
import com.arcway.cockpit.frame.client.project.modules.IPermissionChecker;
import com.arcway.cockpit.frame.client.project.modules.IPermissionModificationAgent;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.modules.IUniqueElementHighlightRequest;
import com.arcway.cockpit.frame.client.project.modules.ModuleController;
import com.arcway.cockpit.frame.client.project.modules.ModuleDataManager;
import com.arcway.cockpit.frame.client.project.offlinemode.IOfflineModeManager;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineModeManager;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineDataNotAvailable;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentLinkManager;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentModuleController;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentSectionManager;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.planimportexport.PlanImporterExporterManager;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.IModulePlanEditorManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElementsHighlighter;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.frame.client.project.propertychanges.PropertyChangesManager;
import com.arcway.cockpit.frame.client.project.sequences.IFrameSequencerManager;
import com.arcway.cockpit.frame.client.project.sequences.ISequencerManager;
import com.arcway.cockpit.frame.client.project.sequences.SequencerManager;
import com.arcway.cockpit.frame.client.project.settings.global.ConfigurationManager;
import com.arcway.cockpit.frame.client.project.settings.global.IConfigurationManager;
import com.arcway.cockpit.frame.client.project.settings.local.ProjectSettingsStore;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.serverexceptions.EXPendingAsynchronousUpdates;
import com.arcway.cockpit.frame.shared.serverexceptions.EXProjectDoesNotExist;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.repository.RepositoryEditorFactory;
import com.arcway.lib.eclipse.uiframework.editors.EditorInput;
import com.arcway.lib.eclipse.uiframework.editors.repository.RepositoryEditor;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.files.PropertiesFile;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.clientadapter.implementation.adapter.IRepositoryPlatformController;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterInterface;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkstation;
import com.arcway.repository.clientadapter.implementation.adapter.infolink.PlatformAdapterModuleInfoLink;
import com.arcway.repository.clientadapter.implementation.adapter.modelelement.PlatformAdapterModuleModelElement;
import com.arcway.repository.clientadapter.implementation.adapter.modules.PlatformAdapterModuleModules;
import com.arcway.repository.clientadapter.implementation.adapter.plan.PlatformAdapterModulePlan;
import com.arcway.repository.clientadapter.implementation.adapter.project.PlatformAdapterModuleProject;
import com.arcway.repository.clientadapter.implementation.adapter.reporttemplates.PlatformAdapterModuleReportTemplates;
import com.arcway.repository.clientadapter.implementation.adapter.section.PlatformAdapterModuleSection;
import com.arcway.repository.clientadapter.implementation.adapter.stakeholder.PlatformAdapterModuleStakeholder;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import com.arcway.repository.cockpit.interFace.declaration.frame.plan.COTIDsPlan;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadAllDependentModuleTypes;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadRootModuleType;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.manager.EXRepositoryInterfaceNotFound;
import com.arcway.repository.interFace.plugin.extensions.IRepositoryChassisClient;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.eclipse.ProgressDisplayToJFaceProgressMonitorAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.IPermissionsChangeListener;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProjectAgent
implements IFrameProjectAgent,
IFrameDataManagerAdministrator,
IAdaptable {
    private static final ILogger logger = Logger.getLogger(ProjectAgent.class);
    public static final String AUTOEXEC_REPORT_NAME_INFIX = "[Dashboard]";
    public static final String PROPERTIES_FILE_NAME = "project.properties";
    public static final String PROJECT_SUBFOLDER_LOCKS_DB = new String("locksdb");
    public static final String PROJECT_SUBFOLDER_MOD = new String("mod");
    public static final String PROJECT_SUBFOLDER_FILES = new String("files");
    private static final String SERVER_ID = "serverID";
    private static final String PROJECT_UID = "projectUID";
    private static final String PROJECT_NAME = "projectName";
    private static final Set<IProjectOpenListener> projectOpenListeners = new HashSet<IProjectOpenListener>();
    private final File projectRoot;
    private final PropertiesFile propertiesFile;
    private AtomicModificationDataAccessor atomicModificationDataAccessor;
    private final Set<ProjectCloseListenerWithPriority> projectCloseListeners = new HashSet<ProjectCloseListenerWithPriority>();
    private boolean isOpened = false;
    private boolean isClosing = false;
    private final Map<String, IFrameDataManager> dataManagers = new HashMap<String, IFrameDataManager>();
    private final String serverID;
    private final String projectUID;
    private String projectName;
    private final ModelTransactionManager modelTransactionManager;
    private final List<String> commitVersionUIDs;
    private final PropertyChangesManager propertyChangesManager;
    private final IOfflineModeManager offlineModeManager;
    private ProjectMetaDataManager metaDataManager = new ProjectMetaDataManager();
    private IPermissionsChangeListener permissionChangeListener;
    private PermissionChangePropagator permissionChangePropagator = null;
    private EOUserAndGroupAndPermissions userData;
    private ModuleController moduleController;
    private SectionManager sectionMgr;
    private UniqueElementMgr uniqueElementMgr;
    private StakeholderManager stakeholderManager;
    private UniqueElementRelationshipMgr uniqueElementRelationshipMgr;
    private IFrameServerProxy serverProxy;
    private CommitMgr commitMgr;
    private DocGeneratorManager docGeneratorManager;
    private LockMgr lockMgr;
    private LinkManager linkMgr;
    private ILOLinkAccessFacade uniqueElementLinkFacade;
    private FilesManager filesManager;
    private ProjectPermissionChecker permissionChecker;
    private ProjectPermissionModificationModel permissionModificationModel;
    private PlanAgentManager planAgentManager;
    private PlanEditorManager planEditorManager;
    private FrameImportExportManager importExportManager;
    private PlanImporterExporterManager planImporterExporterManager;
    private ReportTemplateFoldersManager reportTemplatesFolderManager;
    private ReportTemplatesManager reportTemplatesManager;
    private ReportOutputTemplatesManager reportOutputtemplatesManager;
    private IChildRelationsManager childRelationsManager;
    private SequencerManager sequencerManager;
    private DNDManager dndManager;
    private ModificationRootItem modificationRootItem;
    private FrameLinkManager frameLinkMgr;
    private ProjectSettingsStore localSettingsStore;
    private UserDefinedAttributeTypesManager userDefinedAttributeTypesManager;
    private FrameDataAttributeTypesProviderMgr frameDataAttributeTypesProviderMgr;
    private ObjectTypeCategoriesManager objectTypeCategoriesManager;
    private IConfigurationManager configurationManager;
    private IRepositoryTypeManagerRO repositoryTypeManager;
    private IRepositoryInterfaceRO repositoryInterface;
    private CockpitController cockpitController;
    private IRepositoryPlatformController repositoryPlattformController;
    private static final Comparator<ProjectCloseListenerWithPriority> PROJECT_CLOSE_LISTENER_PRIORITY_COMPARATOR = new Comparator<ProjectCloseListenerWithPriority>(){

        @Override
        public int compare(ProjectCloseListenerWithPriority o1, ProjectCloseListenerWithPriority o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };

    public static ProjectAgent recreateProjectAgent(File projectRoot) throws IOException {
        PropertiesFile propertiesFile = new PropertiesFile(projectRoot, PROPERTIES_FILE_NAME);
        Properties projectProperties = propertiesFile.readProperties();
        return new ProjectAgent(projectProperties.getProperty(PROJECT_UID), projectProperties.getProperty(PROJECT_NAME, "Unknown - " + System.currentTimeMillis()), projectProperties.getProperty(SERVER_ID), projectRoot, propertiesFile);
    }

    public ProjectAgent(String projectUID, String projectName, String serverID, File projectRoot) {
        this(projectUID, projectName, serverID, projectRoot, new PropertiesFile(projectRoot, PROPERTIES_FILE_NAME));
        this.writeProperties();
    }

    private ProjectAgent(String projectUID, String projectName, String serverID, File projectRoot, PropertiesFile propertiesFile) {
        assert (projectUID != null);
        assert (projectName != null);
        assert (ProjectMgr.getProjectMgr().isConfiguredServer(serverID));
        assert (projectRoot.isDirectory());
        this.projectUID = projectUID;
        this.projectName = projectName;
        this.serverID = serverID;
        this.projectRoot = projectRoot;
        this.propertiesFile = propertiesFile;
        this.modelTransactionManager = new ModelTransactionManager(this);
        this.commitVersionUIDs = new LinkedList<String>();
        this.offlineModeManager = new OfflineModeManager(this, projectRoot);
        this.propertyChangesManager = new PropertyChangesManager(this);
    }

    @Override
    public ModificationRootItem getModificationRootItem() {
        if (this.modificationRootItem == null) {
            this.modificationRootItem = new ModificationRootItem(this);
        }
        return this.modificationRootItem;
    }

    private void writeProperties() {
        try {
            Properties projectProperties = new Properties();
            projectProperties.setProperty(SERVER_ID, this.serverID);
            projectProperties.setProperty(PROJECT_UID, this.projectUID);
            projectProperties.setProperty(PROJECT_NAME, this.projectName);
            this.saveProperties(projectProperties);
            int i = 0;
            while (i < 4) {
                if (this.propertiesFile.length() == 0L) {
                    this.saveProperties(projectProperties);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            logger.error("writeProperties() - Unable to save properties file " + this.propertiesFile.getAbsolutePath(), (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("writeProperties() - Unable to save properties file " + this.propertiesFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private void saveProperties(Properties projectProperties) throws IOException {
        try (FileOutputStream fileOutPutStream = new FileOutputStream((File)this.propertiesFile);){
            projectProperties.store(fileOutPutStream, "Project Properties");
        }
    }

    @Override
    public ImageDescriptor getProjectLogo() {
        Project project = this.getProjectMetaDataManager().getProject();
        IAttribute logoAttribute = project.getAttribute(ProjectAttributeTypeProvider.ATTRID_LOGO);
        IAttributeType attributeType = project.getAttributeType(logoAttribute.getAttributeTypeID());
        DataTypeImage dataType = (DataTypeImage)attributeType.getDataType();
        return dataType.getImageDescriptor((FileID)logoAttribute.getAttributeValue());
    }

    @Override
    public void openWithProgressbar(boolean forceOpen, boolean triggerUserOnOpenActions, IWorkbenchPage currentPage) throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, InterruptedException, ExProjectOpenAbortWithMessage {
        this.open(forceOpen, triggerUserOnOpenActions, currentPage, true);
    }

    @Override
    public boolean open(boolean forceOpen, boolean triggerUserOnOpenActions, IWorkbenchPage currentPage) throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, ExProjectOpenAbortWithMessage {
        return this.open(forceOpen, triggerUserOnOpenActions, currentPage, false);
    }

    private boolean open(final boolean forceOpen, final boolean triggerUserOnOpenActions, final IWorkbenchPage currentPage, boolean showProgressDialog) throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, ExProjectOpenAbortWithMessage {
        Shell shell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        Throwable openException = null;
        if (showProgressDialog) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ProjectAgent.this.open(monitor, forceOpen, triggerUserOnOpenActions, currentPage);
                    }
                    catch (LoginCanceledException lce) {
                        throw new InvocationTargetException(lce);
                    }
                    catch (ServerNotAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (UnknownServerException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (EXServerException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (ExProjectOpenAbortWithMessage e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
            progressDialog.setOpenOnRun(true);
            try {
                progressDialog.run(false, false, runnable);
            }
            catch (InvocationTargetException ite) {
                openException = ite.getTargetException();
            }
            catch (InterruptedException e) {
                logger.error("Although cancellation is neither enabled nor implemented a InterruptedException occured:", (Throwable)e);
            }
            progressDialog.getProgressMonitor().done();
        } else {
            ProgressDisplayToJFaceProgressMonitorAdapter monitor = new ProgressDisplayToJFaceProgressMonitorAdapter(IProgressDisplay.DUMMY);
            try {
                this.open((IProgressMonitor)monitor, forceOpen, triggerUserOnOpenActions, currentPage);
            }
            catch (LoginCanceledException lce) {
                openException = lce;
            }
            catch (ServerNotAvailableException e) {
                openException = e;
            }
            catch (UnknownServerException e) {
                openException = e;
            }
            catch (EXServerException e) {
                openException = e;
            }
            catch (ExProjectOpenAbortWithMessage e) {
                openException = e;
            }
        }
        if (openException != null) {
            this.isOpened = false;
            this.destroyInternalStructure();
        }
        if (openException instanceof LoginCanceledException) {
            throw (LoginCanceledException)openException;
        }
        if (openException instanceof ServerNotAvailableException) {
            throw (ServerNotAvailableException)openException;
        }
        if (openException instanceof UnknownServerException) {
            throw (UnknownServerException)openException;
        }
        if (openException instanceof EXServerException) {
            throw (EXServerException)openException;
        }
        if (openException instanceof ExProjectOpenAbortWithMessage) {
            throw (ExProjectOpenAbortWithMessage)openException;
        }
        if (openException != null) {
            logger.error("Project could not be opened due to runtime exception", openException);
        }
        return this.isOpened;
    }

    private void open(final IProgressMonitor monitor, final boolean forceOpen, boolean triggerUserOnOpenActions, IWorkbenchPage currentPage) throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, ExProjectOpenAbortWithMessage {
        assert (monitor != null);
        if (this.isOpened()) {
            assert (false);
            logger.error("tried to open project " + this.projectName + " twice.");
            return;
        }
        this.propertyChangesManager.doOpenProjectWithSuspendedPropertyEventPropagation(new PropertyChangesManager.IProjectOpenRunnable(){

            @Override
            public void run() throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, ExProjectOpenAbortWithMessage {
                ProjectAgent.this.open_PropertyEventsSuspended(monitor, forceOpen);
            }
        });
        if (triggerUserOnOpenActions) {
            this.triggerUserOnOpenActions(currentPage);
        }
    }

    @Override
    public void triggerUserOnOpenActions(IWorkbenchPage currentPage) {
        if (!ProjectMgr.getProjectMgr().isInScriptMode()) {
            this.processDashboardReport(currentPage);
        }
    }

    private void processDashboardReport(IWorkbenchPage currentPage) {
        IReportTemplate autoExecReportTemplate = null;
        for (IAttributeOwner iAttributeOwner : this.reportTemplatesManager.getData()) {
            IReportTemplate reportTemplate;
            String templateName;
            if (!(iAttributeOwner instanceof IReportTemplate) || (templateName = (reportTemplate = (IReportTemplate)iAttributeOwner).getName()) == null || !templateName.contains(AUTOEXEC_REPORT_NAME_INFIX)) continue;
            autoExecReportTemplate = reportTemplate;
            break;
        }
        if (autoExecReportTemplate != null) {
            final DocGenerationAction docGenerationAction = new DocGenerationAction((ICockpitProjectData)autoExecReportTemplate, currentPage);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    docGenerationAction.run();
                }
            });
        }
    }

    private void open_PropertyEventsSuspended(final IProgressMonitor monitor, final boolean forceOpen) throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, ExProjectOpenAbortWithMessage {
        IProjectManagerServerProxy projectManagerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.serverID);
        if (this.offlineModeManager.isInOfflineMode()) {
            ILocalClientProductLicenseManager localProductLicenseManager = projectManagerServerProxy.getLocalProductLicenseManager();
            if (!localProductLicenseManager.hasProductLicense(ClientProductLicenseTypes.FULL_LICENSE)) {
                throw new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.Error_while_opening_the_project_21"), Messages.getString("ProjectAgent.ErrorOpening.OfflineMode.MissingLicense"));
            }
        } else {
            projectManagerServerProxy.forceLogin();
        }
        try {
            this.constructInternalStructure();
        }
        catch (EXCorruptProjectData e1) {
            this.destroyInternalStructure();
            throw ProjectAgent.createCorruptProjectDataAbortException(e1);
        }
        final EXCorruptProjectData[] exCorruptProjectData = new EXCorruptProjectData[1];
        final ServerNotAvailableException[] serverNotAvailableException = new ServerNotAvailableException[1];
        final LoginCanceledException[] loginCanceledException = new LoginCanceledException[1];
        final EXServerException[] exServerException = new EXServerException[1];
        final UnknownServerException[] unknownServerException = new UnknownServerException[1];
        final ExProjectOpenAbortWithMessage[] projectOpenAbortWithMessage = new ExProjectOpenAbortWithMessage[1];
        while (true) {
            final ExRetryProjectOpen[] exRetryProjectOpen = new ExRetryProjectOpen[1];
            this.atomicModificationDataAccessor.executeModificationBootstrapRunnable(new AtomicModificationDataAccessor.BootstrapRunnable(){

                public void run() {
                    try {
                        ServerDataContainer serverDataContainer;
                        ProjectAgent.this.commitMgr.initializeAsynchronousUpdateDelayMachinery();
                        try {
                            serverDataContainer = ProjectAgent.this.initialize();
                            if (serverDataContainer == null) {
                                throw new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.Error_while_opening_the_project_21"), Messages.getString("ProjectAgent.Project_data_is_invalid"));
                            }
                            ProjectAgent.this.installRepositoryInterface(serverDataContainer);
                        }
                        catch (EXProjectDoesNotExist e) {
                            throw new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.Error_while_opening_the_project_21"), Messages.getString("ProjectAgent.Project_has_been_deleted_from_the_server._22"), e);
                        }
                        catch (EXOfflineDataNotAvailable eODNA) {
                            throw new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.Error_while_opening_the_project_21"), Messages.getString("ProjectAgent.ErrorOpening.OfflineData"), eODNA);
                        }
                        String availabilty = ProjectAgent.this.serverProxy.getAvailabilityState();
                        if (availabilty != null) {
                            throw new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.project_not_available"), String.valueOf(Messages.getString("ProjectAgent.not_available_reason")) + availabilty);
                        }
                        List<IFrameDataManager> frameDatamanagers = ProjectAgent.this.getDataManagers();
                        JFaceProgressMonitorToProgressDisplayAdapter pDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                        int nrOfManager = 3 * (frameDatamanagers.size() + 1);
                        pDisplay.beginQuantifiedTask(String.valueOf(Messages.getString("ProjectAgent.open_project")) + "\"" + ProjectAgent.this.projectName + "\"", nrOfManager + 1, false);
                        int currentmanager = 0;
                        for (IFrameDataManager manager : frameDatamanagers) {
                            pDisplay.reportQuantifiedProgress(++currentmanager, manager.getLocalizedManagerName());
                            manager.initializeBeforePermissionsCheck(ProjectAgent.this, serverDataContainer);
                        }
                        if (!(ProjectAgent.this.permissionChecker.hasPermission("openProject", null, ProjectAgent.this, true) || ProjectAgent.this.permissionChecker.isAdmin() || forceOpen)) {
                            throw new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.Error_while_opening_the_project_27"), Messages.getString("ProjectAgent.Could_not_open_the_project_due_to_insufficient_permissions._28"));
                        }
                        for (IFrameDataManager manager : frameDatamanagers) {
                            pDisplay.reportQuantifiedProgress(++currentmanager, manager.getLocalizedManagerName());
                            manager.initializeAfterPermissionsCheck(ProjectAgent.this, serverDataContainer);
                        }
                        ProjectAgent.this.isOpened = true;
                        ProjectAgent.this.linkMgr.finishInitialization(ProjectAgent.this, serverDataContainer);
                        for (IFrameDataManager manager : frameDatamanagers) {
                            if (manager instanceof LinkManager) continue;
                            pDisplay.reportQuantifiedProgress(++currentmanager, manager.getLocalizedManagerName());
                            manager.finishInitialization(ProjectAgent.this, serverDataContainer);
                        }
                    }
                    catch (ExRetryProjectOpen e) {
                        exRetryProjectOpen[0] = e;
                    }
                    catch (EXCorruptProjectData e) {
                        exCorruptProjectData[0] = e;
                    }
                    catch (ServerNotAvailableException e) {
                        serverNotAvailableException[0] = e;
                    }
                    catch (LoginCanceledException e) {
                        loginCanceledException[0] = e;
                    }
                    catch (EXServerException e) {
                        exServerException[0] = e;
                    }
                    catch (UnknownServerException e) {
                        unknownServerException[0] = e;
                    }
                    catch (ExProjectOpenAbortWithMessage e) {
                        projectOpenAbortWithMessage[0] = e;
                    }
                }
            });
            if (exRetryProjectOpen[0] == null) break;
            if (exRetryProjectOpen[0].doDiscardChangesBeforeAttemptingRetry() != ExRetryProjectOpen.CleanupActionBeforeNextOpenAttempt.DiscardLocalModifications) continue;
            try {
                this.discardLocalModificationsAndRecreateInternalStructure();
            }
            catch (EXCorruptProjectData e) {
                throw ProjectAgent.createDiscardLocalModificationsAndRecreateInternalStructureAbortException((Exception)((Object)e));
            }
            catch (JvmExternalResourceInteractionException e) {
                throw ProjectAgent.createDiscardLocalModificationsAndRecreateInternalStructureAbortException((Exception)((Object)e));
            }
        }
        if (exCorruptProjectData[0] != null) {
            throw ProjectAgent.createCorruptProjectDataAbortException(exCorruptProjectData[0]);
        }
        if (serverNotAvailableException[0] != null) {
            throw serverNotAvailableException[0];
        }
        if (loginCanceledException[0] != null) {
            throw loginCanceledException[0];
        }
        if (exServerException[0] != null) {
            throw exServerException[0];
        }
        if (unknownServerException[0] != null) {
            throw unknownServerException[0];
        }
        if (projectOpenAbortWithMessage[0] != null) {
            throw projectOpenAbortWithMessage[0];
        }
        new PlanElementsHighlighter(this);
        if (this.permissionChangeListener != null && this.userData != null) {
            this.userData.removePermissionsChangeListener(this.permissionChangeListener);
        }
        this.userData = this.getUserData(false);
        this.permissionChangeListener = new IPermissionsChangeListener(){

            public void permissionAdded(EOPermission addedPermission) {
                ProjectAgent.this.propagateAddedPermission(addedPermission);
            }

            public void permissionsRemoved(EOPermission removedPermission) {
                ProjectAgent.this.propagateRemovedPermission(removedPermission);
            }
        };
        this.userData.addPermissionsChangeListener(this.permissionChangeListener);
        this.activateRepositoryInterface();
        this.commitMgr.startAsynchronousUpdateProcessing();
        this.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)new PropertyChanges(null, (Object)this, null), IProjectAgent.class);
        ProjectAgent.informProjectOpenListeners(this);
    }

    private static ExProjectOpenAbortWithMessage createDiscardLocalModificationsAndRecreateInternalStructureAbortException(Exception e) {
        return new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.UnableToDiscardObsoleteSucessfullyCommitedModifications.title"), String.valueOf(Messages.getString("ProjectAgent.UnableToDiscardObsoleteSucessfullyCommitedModifications.message")) + e.getLocalizedMessage(), e);
    }

    private static ExProjectOpenAbortWithMessage createCorruptProjectDataAbortException(EXCorruptProjectData e) {
        return new ExProjectOpenAbortWithMessage(Messages.getString("ProjectAgent.CorruptProjectDataAbortException.title"), String.valueOf(Messages.getString("ProjectAgent.CorruptProjectDataAbortException.message")) + e.getLocalizedMessage(), e);
    }

    private synchronized void propagateAddedPermission(EOPermission addedPermission) {
        this.enquePermissionChangePropagator();
        this.permissionChangePropagator.addedPermissions.add(addedPermission);
    }

    private synchronized void propagateRemovedPermission(EOPermission removedPermission) {
        this.enquePermissionChangePropagator();
        this.permissionChangePropagator.removedPermissions.add(removedPermission);
    }

    private void enquePermissionChangePropagator() {
        if (this.permissionChangePropagator == null) {
            this.permissionChangePropagator = new PermissionChangePropagator();
            Display.getDefault().asyncExec((Runnable)this.permissionChangePropagator);
        }
    }

    @Override
    public void showProjectOpenAbortWithMessageDialog(Shell shell, ExProjectOpenAbortWithMessage poawm) {
        MessageDialog mDialog = new MessageDialog(shell, poawm.dialogTitle, null, poawm.dialogMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        mDialog.open();
    }

    public List<IFrameDataManager> getDataManagers() {
        IFrameDataManager[] managers = new IFrameDataManager[]{this.filesManager, this.userDefinedAttributeTypesManager, this.objectTypeCategoriesManager, this.stakeholderManager, this.metaDataManager, this.sectionMgr, this.uniqueElementMgr, this.uniqueElementRelationshipMgr, this.reportTemplatesFolderManager, this.reportTemplatesManager, this.reportOutputtemplatesManager, this.localSettingsStore, this.moduleController, this.linkMgr, this.docGeneratorManager};
        return Arrays.asList(managers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean close(Shell shell) {
        boolean closingSucceeded = false;
        if (this.isOpened && !this.isClosing) {
            this.isClosing = true;
            try {
                boolean savingEditorsSucceeded = true;
                if (shell != null) {
                    savingEditorsSucceeded = this.saveAllEditors(shell, Messages.getString("ProjectAgent.CloseProject.SaveEditors"), true, true, false);
                }
                if (!savingEditorsSucceeded) return closingSucceeded;
                boolean closingPlanEditorsSucceeded = true;
                this.planAgentManager.closeAllPlanAgents();
                Collection openPlans = this.planAgentManager.getAObjectForEachRelevantPlanAgent(PlanAgentManager.IControllerFitCretereon.ALL_CONTROLLER_EXTENSIONS);
                closingPlanEditorsSucceeded = openPlans.isEmpty();
                if (!closingPlanEditorsSucceeded && shell != null) return closingSucceeded;
                this.deactivateRepositoryInterface();
                this.uninstallRepositoryInterface();
                this.informProjectCloseListeners();
                this.propertyChangesManager.projectClosed();
                if (this.userData != null) {
                    this.userData.removePermissionsChangeListener(this.permissionChangeListener);
                }
                this.userData = null;
                this.permissionChangeListener = null;
                this.filesManager.dispose();
                this.isOpened = false;
                this.destroyInternalStructure();
                closingSucceeded = true;
                return closingSucceeded;
            }
            finally {
                this.isClosing = false;
            }
        } else {
            closingSucceeded = true;
            this.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)new PropertyChanges(null, (Object)this, null), IProjectAgent.class);
        }
        return closingSucceeded;
    }

    @Override
    public void addProjectCloseListener(IProjectCloseListener projectListener) {
        this.addProjectCloseListener(projectListener, 0);
    }

    @Override
    public void addProjectCloseListener(IProjectCloseListener projectListener, int priority) {
        boolean addedOne = this.projectCloseListeners.add(new ProjectCloseListenerWithPriority(projectListener, priority));
        assert (addedOne);
    }

    @Override
    public void removeProjectCloseListener(IProjectCloseListener projectListener) {
        boolean removedOne = this.projectCloseListeners.remove(new ProjectCloseListenerWithPriority(projectListener, 0));
        assert (removedOne);
    }

    private void informProjectCloseListeners() {
        ArrayList<ProjectCloseListenerWithPriority> localListeners = new ArrayList<ProjectCloseListenerWithPriority>(this.projectCloseListeners);
        Collections.sort(localListeners, PROJECT_CLOSE_LISTENER_PRIORITY_COMPARATOR);
        for (ProjectCloseListenerWithPriority projectListener : localListeners) {
            projectListener.getProjectCloseListener().closeProject(this);
        }
        assert (!new HashSet<ProjectCloseListenerWithPriority>(localListeners).addAll(this.projectCloseListeners)) : "No projectCloseListeners must be added during informProjectCloseListeners.";
    }

    private void installRepositoryInterface(ServerDataContainer serverDataContainer) throws EXOfflineDataNotAvailable {
        this.cockpitController = new CockpitController(this);
        this.cockpitController.install(serverDataContainer);
    }

    @Override
    public void activateRepositoryInterface() {
        this.cockpitController.activateBegin();
        PlatformAdapterModuleManager adapterModuleManager = this.cockpitController.getPlatformAdapterModuleManager();
        ICollection_<IRepositoryDataTypeRegistration> dataTypeRegistrations = adapterModuleManager.getRepositoryDataTypeRegistrations();
        IRepositoryTypeDeclaration rootModuleTypeDeclaration = adapterModuleManager.getRootRepositoryModuleTypeDeclaration();
        ICollection_<IRepositoryModuleTypeDeclaration> dependentModuleTypeDeclarations = adapterModuleManager.getDependentRepositoryModuleTypeDeclarations();
        PlatformAdapterWorkstation workstation = new PlatformAdapterWorkstation(this);
        try {
            this.repositoryTypeManager = IRepositoryChassisClient.REPOSITORY_CHASSIS.createRepositoryTypeManager((IRepositoryInterfaceRO)workstation.getRepositoryInterfaceImplementation(), dataTypeRegistrations, rootModuleTypeDeclaration, dependentModuleTypeDeclarations);
        }
        catch (EXCouldNotLoadRootModuleType e1) {
            throw new RuntimeException(e1);
        }
        catch (EXCouldNotLoadAllDependentModuleTypes e1) {
            throw new RuntimeException(e1);
        }
        workstation.setRepositoryTypeManager(this.repositoryTypeManager);
        this.repositoryPlattformController = workstation;
        IRepositoryWorkspaceRO workspace = workstation.createRepositoryWorkspace();
        this.repositoryInterface = workspace.getRepositoryInterfaceRO();
        this.cockpitController.activateEnd();
    }

    @Override
    public void deactivateRepositoryInterface() {
        this.repositoryPlattformController = null;
        if (this.repositoryTypeManager != null) {
            this.repositoryTypeManager.shutdown();
        }
        this.repositoryTypeManager = null;
        this.repositoryInterface = null;
        this.cockpitController.deactivate();
    }

    private void uninstallRepositoryInterface() {
        this.cockpitController.uninstall();
        this.cockpitController = null;
    }

    @Override
    public IRepositoryInterfaceRO getRepositoryInterface() {
        return this.repositoryInterface;
    }

    private void constructInternalStructure() throws EXCorruptProjectData {
        this.dataManagers.clear();
        try {
            this.atomicModificationDataAccessor = new AtomicModificationDataAccessor(this.getProjectSubFolder(PROJECT_SUBFOLDER_MOD));
        }
        catch (FileTransactionManagerInitialisationFailed e) {
            throw new EXCorruptProjectData((Exception)((Object)e));
        }
        this.serverProxy = this.offlineModeManager.getAppropriateServerProxy();
        this.metaDataManager = new ProjectMetaDataManager();
        this.planAgentManager = new PlanAgentManager();
        this.planEditorManager = new PlanEditorManager(this);
        this.moduleController = new ModuleController();
        this.sectionMgr = new SectionManager();
        this.linkMgr = new LinkManager(this);
        this.frameLinkMgr = new FrameLinkManager(this.linkMgr, this);
        this.sequencerManager = new SequencerManager(this);
        this.uniqueElementMgr = new UniqueElementMgr();
        this.stakeholderManager = new StakeholderManager();
        this.uniqueElementRelationshipMgr = new UniqueElementRelationshipMgr();
        this.commitMgr = new CommitMgr();
        this.docGeneratorManager = new DocGeneratorManager();
        this.lockMgr = new LockMgr();
        this.permissionChecker = new ProjectPermissionChecker();
        this.dndManager = new DNDManager();
        this.planImporterExporterManager = new PlanImporterExporterManager();
        this.localSettingsStore = new ProjectSettingsStore();
        this.userDefinedAttributeTypesManager = new UserDefinedAttributeTypesManager();
        this.objectTypeCategoriesManager = new ObjectTypeCategoriesManager();
        this.frameDataAttributeTypesProviderMgr = new FrameDataAttributeTypesProviderMgr(this.projectUID);
        this.permissionModificationModel = new ProjectPermissionModificationModel();
        this.filesManager = new FilesManager(this);
        this.reportTemplatesFolderManager = new ReportTemplateFoldersManager(this);
        this.reportTemplatesManager = new ReportTemplatesManager(this);
        this.reportOutputtemplatesManager = new ReportOutputTemplatesManager(this);
        this.childRelationsManager = new ChildRelationsManager(this);
        this.planAgentManager.construct(this);
        this.planEditorManager.construct(this.planAgentManager);
        this.moduleController.construct(this);
        this.frameLinkMgr.construct();
        this.sequencerManager.construct();
        this.sectionMgr.construct(this);
        this.uniqueElementMgr.construct(this);
        this.uniqueElementRelationshipMgr.construct(this);
        this.commitMgr.construct(this, this.moduleController, this.uniqueElementMgr, this.sectionMgr, this.serverProxy, this.lockMgr, this.linkMgr, this.stakeholderManager);
        this.docGeneratorManager.construct(this);
        this.lockMgr.setup(this, this.serverProxy);
        this.stakeholderManager.construct(this);
        this.permissionChecker.construct(this);
        this.permissionModificationModel.construct(this);
        this.planImporterExporterManager.construct(this.planAgentManager);
        this.userDefinedAttributeTypesManager.construct(this);
        this.objectTypeCategoriesManager.construct(this);
    }

    protected void destroyInternalStructure() {
        this.dataManagers.clear();
        if (this.commitMgr != null) {
            this.commitMgr.destroy();
        }
        if (this.moduleController != null) {
            this.moduleController.destruct();
        }
        this.planAgentManager = null;
        this.moduleController = null;
        this.sectionMgr = null;
        this.uniqueElementMgr = null;
        this.uniqueElementRelationshipMgr = null;
        this.commitMgr = null;
        this.docGeneratorManager = null;
        if (this.lockMgr != null) {
            this.lockMgr.destruct();
            this.lockMgr = null;
        }
        this.uniqueElementLinkFacade = null;
        this.sequencerManager = null;
        this.linkMgr = null;
        this.dndManager = null;
        this.planImporterExporterManager = null;
        this.localSettingsStore = null;
        this.configurationManager = null;
        if (this.frameLinkMgr != null) {
            this.frameLinkMgr.destruct();
        }
        this.frameLinkMgr = null;
        this.reportTemplatesFolderManager = null;
        this.reportOutputtemplatesManager = null;
        this.reportTemplatesManager = null;
        this.modificationRootItem = null;
        this.userDefinedAttributeTypesManager = null;
        this.objectTypeCategoriesManager = null;
        this.filesManager = null;
        this.childRelationsManager = null;
        this.projectCloseListeners.clear();
        this.commitVersionUIDs.clear();
        this.serverProxy = null;
        if (this.atomicModificationDataAccessor != null) {
            this.atomicModificationDataAccessor.destruct(this.projectUID);
            this.atomicModificationDataAccessor = null;
        }
    }

    @Override
    public File getProjectSettingsFile() {
        return new File(this.getProjectRoot(), "project.localSettings");
    }

    @Override
    public PlanAgentManager getPlanAgentManager() {
        return this.planAgentManager;
    }

    @Override
    public PlanEditorManager getPlanEditorManager() {
        return this.planEditorManager;
    }

    @Override
    public IPropertyChangesListenerManager getPropertyChangesListenerManager() {
        return this.propertyChangesManager;
    }

    @Override
    public IPropertyChangesProviderManager getPropertyChangesProviderManager() {
        return this.propertyChangesManager;
    }

    @Override
    public IChildRelationsManager getChildRelationsManager() {
        return this.childRelationsManager;
    }

    @Override
    public IFrameServerProxy getFrameServerProxy() {
        return this.serverProxy;
    }

    @Override
    public IModuleServerProxy getModuleServerProxy() {
        return this.serverProxy;
    }

    public UniqueElementMgr getUniqueElementMgr() {
        return this.uniqueElementMgr;
    }

    @Override
    public IUniqueElementRelationshipManager getUniqueElementRelationshipManager() {
        return this.uniqueElementRelationshipMgr;
    }

    @Override
    public ModuleController getModuleController() {
        return this.moduleController;
    }

    @Override
    public IPlanAgentModuleController getPlanAgentModuleController() {
        return this.getModuleController();
    }

    @Override
    public CommitMgr getCommitMgr() {
        return this.commitMgr;
    }

    @Override
    public ILockManager getLockManager() {
        return this.lockMgr;
    }

    @Override
    public IOfflineModeManager getOfflineModeManager() {
        return this.offlineModeManager;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public String getUID() {
        return this.getProjectUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCommitVersionUIDs() {
        List<String> list = this.commitVersionUIDs;
        synchronized (list) {
            return new ArrayList<String>(this.commitVersionUIDs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommitVersionUID(String newCommitVersionUID) {
        List<String> list = this.commitVersionUIDs;
        synchronized (list) {
            if (!this.commitVersionUIDs.contains(newCommitVersionUID)) {
                this.commitVersionUIDs.add(newCommitVersionUID);
            } else {
                logger.warn("Tried to add CommitVersionUID already contained in list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCommitVersionUIDs(List<String> commitUIDs) {
        List<String> list = this.commitVersionUIDs;
        synchronized (list) {
            ListIterator<String> itCommitUIDs = commitUIDs.listIterator();
            while (itCommitUIDs.hasNext()) {
                String commitUID = itCommitUIDs.next();
                this.commitVersionUIDs.remove(commitUID);
            }
        }
    }

    @Override
    public String getServerID() {
        return this.serverID;
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public boolean isOpenAndNotClosing() {
        return this.isOpened && !this.isClosing;
    }

    @Override
    public File getProjectRoot() {
        return this.projectRoot;
    }

    public EOUserAndGroupAndPermissions getUserData(boolean forceLogin) {
        try {
            return this.serverProxy.getUserData(forceLogin);
        }
        catch (ServerNotAvailableException e) {
            ServerConnection sc = ProjectMgr.getProjectMgr().getServerConnectionByServerID(this.serverID);
            logger.info("server " + sc.getServerName() + " not available.");
        }
        catch (EXServerException e) {
            logger.error((Throwable)e);
        }
        catch (LoginCanceledException loginCanceledException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public File getProjectSubFolder(String subFolder) {
        if (subFolder == PROJECT_SUBFOLDER_LOCKS_DB || subFolder == PROJECT_SUBFOLDER_MOD || subFolder == PROJECT_SUBFOLDER_FILES) {
            File folder = new File(this.getProjectRoot(), subFolder);
            try {
                FileHelper.ensureDirectoryExistance((File)folder);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error((Throwable)e);
            }
            return folder;
        }
        assert (false) : "Illegal Argument";
        return null;
    }

    private static void informProjectOpenListeners(IProjectAgent projectAgent) {
        HashSet<IProjectOpenListener> listeners = new HashSet<IProjectOpenListener>(projectOpenListeners);
        for (IProjectOpenListener projectOpenListener : listeners) {
            projectOpenListener.projectOpened(projectAgent);
        }
        assert (projectOpenListeners.size() == listeners.size() && !listeners.addAll(projectOpenListeners)) : "The Set of projectOpenListeners must not be modified during informProjectOpenListeners.";
    }

    public void fireCommitStateChange() {
        PropertyChanges changes = new PropertyChanges(null, (Object)this, null);
        this.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IProjectAgent.class);
    }

    public static void addProjectOpenListener(IProjectOpenListener projectOpenListener) {
        boolean addedOne = projectOpenListeners.add(projectOpenListener);
        assert (addedOne);
    }

    public static void removeProjectOpenListener(IProjectOpenListener projectOpenListener) {
        boolean removedOne = projectOpenListeners.remove(projectOpenListener);
        assert (removedOne);
    }

    @Override
    public void highlightElements(IWorkbenchWindow window, Collection<IUniqueElementHighlightRequest> uniqueElementHighlightRequests) {
        this.planEditorManager.highlightElementsOnPlanEditors(window, uniqueElementHighlightRequests);
    }

    @Override
    public IPlanAgentLinkManager getPlanAgentLinkManager() {
        return this.linkMgr;
    }

    @Override
    public void setUniqueElementLinkAccessFacade(ILOLinkAccessFacade facade) {
        this.uniqueElementLinkFacade = facade;
    }

    @Override
    public ILOLinkAccessFacade getUniqueElementLinkFacade() {
        return this.uniqueElementLinkFacade;
    }

    @Override
    public IFrameLinkManager getLinkManager() {
        return this.frameLinkMgr;
    }

    @Override
    public ProjectPermissionModificationModel getProjectPermissionModificationModel() {
        if (this.permissionModificationModel == null) {
            this.permissionModificationModel = new ProjectPermissionModificationModel();
            this.permissionModificationModel.construct(this);
        }
        return this.permissionModificationModel;
    }

    @Override
    public IPermissionChecker getFramePermissionChecker() {
        return this.permissionChecker;
    }

    @Override
    public IPermissionChecker getModulePermissionChecker() {
        return this.permissionChecker;
    }

    public String getPermissionOperandUID() {
        return this.getProjectUID();
    }

    public String getPermissionOperandType() {
        return "project";
    }

    public String getPermissionOperandDisplayName() {
        return this.projectName;
    }

    @Override
    public void projectNameChanged(String newName) {
        String oldName = this.projectName;
        this.projectName = newName;
        if (!oldName.equals(newName)) {
            this.writeProperties();
        }
    }

    public IStakeholderManager getStakeholderManager() {
        return this.stakeholderManager;
    }

    @Override
    public boolean isAssignedToElementOnPlan(String uniqueElementUID, String planUID) {
        return this.getUniqueElementMgr().hasOccurrencesOnPlan(uniqueElementUID, planUID);
    }

    private ServerDataContainer initialize() throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException, EXOfflineDataNotAvailable, ExRetryProjectOpen {
        ServerDataContainer serverDataContainer = this.serverProxy.setupAfterDataManagersAreCreated();
        if (serverDataContainer != null) {
            EOProject projectMetaData = serverDataContainer.getMetaData();
            String possiblyNewProjectName = Project.getProjectName(projectMetaData);
            try {
                if (!this.projectName.equals(possiblyNewProjectName) && !ProjectMetaDataManager.modFileExists(this)) {
                    this.projectNameChanged(possiblyNewProjectName);
                }
            }
            catch (EXCorruptProjectData e) {
                logger.error("Exception occured while reading project modification failes - displayed project name may be wrong", (Throwable)e);
                throw new Error(e);
            }
        }
        return serverDataContainer;
    }

    public String getTypeID() {
        return "frame.project";
    }

    @Override
    public boolean commitProject(String modificationComment, boolean serverProxyIsPrepared, boolean dontAskUserForDestination, Shell shell) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        boolean success = this.commitMgr.commitProject(modificationComment, serverProxyIsPrepared, dontAskUserForDestination, shell);
        ProjectView.refresh1();
        return success;
    }

    @Override
    public boolean isCommitable() {
        return this.serverProxy.isCommitable() && this.commitMgr.areModificationsPresent();
    }

    @Override
    public IExternalPlanEditorControllerExtension getPlanEditorControllerExtension(IEditorPart editorPart) {
        return this.getPlanEditorManager().getPlanEditorControllerExtension((IWorkbenchPart)editorPart);
    }

    @Override
    public boolean saveAllEditors(Shell parentShell, String message, boolean savePlanEditors, boolean saveFormsEditors, boolean includeClose) {
        ArrayList<IEditorPart> editorsToSave = new ArrayList<IEditorPart>();
        if (savePlanEditors) {
            editorsToSave.addAll(this.planEditorManager.getAllDirtyEditorParts());
        }
        if (saveFormsEditors) {
            editorsToSave.addAll(this.collectDirtyFormEditors());
        }
        boolean savedAll = editorsToSave.size() == 0;
        ArrayList<IEditorPart> unsavedEditors = new ArrayList<IEditorPart>();
        ArrayList<IEditorPart> unsavedEditorsToIgnore = new ArrayList<IEditorPart>();
        if (editorsToSave.size() > 0) {
            EditorsListSelectionDialog dialog = new EditorsListSelectionDialog(parentShell, message, editorsToSave);
            dialog.setInitialSelections(editorsToSave.toArray());
            int returnCode = dialog.open();
            if (returnCode == 0) {
                savedAll = true;
                Object[] selectedEditors = dialog.getResult();
                if (selectedEditors != null) {
                    Object[] objectArray = selectedEditors;
                    int n = selectedEditors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        IEditorPart part = (IEditorPart)element;
                        if (!part.getSite().getPage().saveEditor(part, false)) {
                            savedAll &= false;
                            unsavedEditors.add(part);
                        }
                        ++n2;
                    }
                    List<Object> selectedEditorsAsList = Arrays.asList(selectedEditors);
                    for (IEditorPart editorToSave : editorsToSave) {
                        if (selectedEditorsAsList.contains(editorToSave)) continue;
                        unsavedEditorsToIgnore.add(editorToSave);
                    }
                }
            } else if (returnCode == 1) {
                savedAll = false;
            }
        }
        if (savedAll && savePlanEditors) {
            this.planEditorManager.setAllEditorsToProjectorMode();
        }
        Collection<RepositoryEditor> openFormEditors = this.collectAllFormEditors();
        if (savedAll && saveFormsEditors) {
            for (RepositoryEditor eclipseEditor : openFormEditors) {
                boolean succesfullyChangedMode;
                if (unsavedEditors.contains(eclipseEditor)) {
                    succesfullyChangedMode = false;
                    eclipseEditor.bringToTop();
                } else if (unsavedEditorsToIgnore.contains(eclipseEditor)) {
                    succesfullyChangedMode = true;
                } else {
                    succesfullyChangedMode = eclipseEditor.changeMode(1, true);
                    if (!succesfullyChangedMode) {
                        eclipseEditor.bringToTop();
                    }
                }
                savedAll &= succesfullyChangedMode;
            }
        }
        if (savedAll && includeClose) {
            for (RepositoryEditor eclipseEditor : openFormEditors) {
                eclipseEditor.closeEditor(false, true);
            }
            for (IEditorPart editorPart : this.planEditorManager.getAllEditorParts()) {
                editorPart.getEditorSite().getPage().closeEditor(editorPart, false);
            }
        }
        return savedAll;
    }

    @Override
    public HashSet_<IRepositoryObjectReference> getObjectsShownInDirtyEditors() {
        final IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        IHasher_ referencingEqualObjectsHasher = RepositoryObjectReference.get_REFERENCING_EQUAL_OBJECTS_HASHER((IRepositoryTypeManagerRO)typeManager);
        final HashSet_ dirtyEditorObjectReferences = new HashSet_(referencingEqualObjectsHasher);
        for (IPlan iPlan : this.getPlanEditorManager().getAllDirtyPlans()) {
            RepositoryObjectTypeID objectTypeID = COTIDsPlan.OBJECT_TYPE_ID;
            IRepositoryPropertySetSample objectID = this.getRepositoryObjectID(iPlan.getUID());
            RepositoryObjectReference objectReference = new RepositoryObjectReference((IRepositoryObjectTypeID)objectTypeID, objectID);
            dirtyEditorObjectReferences.add((Object)objectReference);
        }
        for (IEditorPart iEditorPart : this.collectDirtyFormEditors()) {
            IEditorInput editorInput = iEditorPart.getEditorInput();
            if (editorInput instanceof EditorInput) {
                EditorInput repositoryEditorInput = (EditorInput)editorInput;
                RepositoryEditorFactory.Input i = (RepositoryEditorFactory.Input)repositoryEditorInput.getInput();
                i.doWithReferencedObject(new RepositoryEditorFactory.Input.IReferencedObjectProcessor(){

                    public void objectNotFound(IRepositorySnapshotRO snapshotRO) throws EXNotReproducibleSnapshot {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }

                    public void interfaceNotFound() {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }

                    public void doWithReferencedObject(IRepositoryObject object) throws EXNotReproducibleSnapshot {
                        if (typeManager.equals(object.getTypeManager())) {
                            dirtyEditorObjectReferences.add((Object)new RepositoryObjectReference(object));
                        }
                    }
                });
                continue;
            }
            if ("com.arcway.planagent.planeditor.PlanEditorFacadeInput".equals(editorInput.getClass().getCanonicalName())) continue;
            assert (false);
            logger.debug("Unkown/alien editor with unsaved changes detected - unable to verify if its content is related to this copy request: " + iEditorPart.getTitle() + " " + editorInput.getClass().getName());
        }
        return dirtyEditorObjectReferences;
    }

    private Collection<RepositoryEditor> collectAllFormEditors() {
        return this.collectFormEditors(false);
    }

    private Collection<RepositoryEditor> collectDirtyFormEditors() {
        return this.collectFormEditors(true);
    }

    /*
     * Unable to fully structure code
     */
    private Collection<RepositoryEditor> collectFormEditors(boolean onlyDirtyEditors) {
        openFormEditors = new ArrayList<RepositoryEditor>();
        var7_4 = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        var6_5 = windows.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            window = var7_4[var5_6];
            var12_12 = pages = window.getPages();
            var11_11 = pages.length;
            var10_10 = 0;
            while (var10_10 < var11_11) {
                page = var12_12[var10_10];
                var17_17 = editorReferences = page.getEditorReferences();
                var16_16 = editorReferences.length;
                var15_15 = 0;
                while (var15_15 < var16_16) {
                    editorReference = var17_17[var15_15];
                    editorPart = editorReference.getEditor(true);
                    if (editorPart instanceof RepositoryEditor) {
                        formEditor = (RepositoryEditor)editorPart;
                        if (!onlyDirtyEditors || formEditor.isDirty()) {
                            editorInput = formEditor.getEditorInput();
                            if (editorInput instanceof EditorInput) {
                                typedEditorInput = (EditorInput)editorInput;
                                input = typedEditorInput.getInput();
                                if (input instanceof RepositoryEditorFactory.Input) {
                                    typedInput = (RepositoryEditorFactory.Input)input;
                                    try {
                                        repositoryInterfaceRO = typedInput.getRepositoryInterface();
                                        platformAdapterInterface = (PlatformAdapterInterface)repositoryInterfaceRO;
                                        if (platformAdapterInterface.getProjectAgent() != this) ** GOTO lbl46
                                        openFormEditors.add(formEditor);
                                    }
                                    catch (EXRepositoryInterfaceNotFound e) {
                                        ProjectAgent.logger.error("Repository form editor found with no corresponding repository interface.");
                                        if (!ProjectAgent.$assertionsDisabled) {
                                            throw new AssertionError();
                                        }
                                    }
                                } else {
                                    ProjectAgent.logger.error("Repository form editor found with input of unknown type.");
                                    if (!ProjectAgent.$assertionsDisabled) {
                                        throw new AssertionError();
                                    }
                                }
                            } else {
                                ProjectAgent.logger.error("Repository form editor found with unknown editor input type.");
                                if (!ProjectAgent.$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                            }
                        }
                    }
lbl46:
                    // 10 sources

                    ++var15_15;
                }
                ++var10_10;
            }
            ++var5_6;
        }
        return openFormEditors;
    }

    @Override
    public void switchAllEditorsIntoViewModeWithoutSaving(Shell parentShell) {
        this.planEditorManager.setAllEditorsToProjectorMode();
        Collection<RepositoryEditor> allFormEditors = this.collectAllFormEditors();
        for (RepositoryEditor formEditor : allFormEditors) {
            formEditor.changeMode(1, true);
        }
    }

    @Override
    public boolean hasPermission(String operation, String operation2, IPermissionOperand operand) {
        return this.permissionChecker.hasPermission(operation, operation2, operand);
    }

    @Override
    public boolean hasPermission(String operation, IPermissionOperand operand) {
        return this.hasPermission(operation, null, operand);
    }

    @Override
    public void stopProjectionButtonPressed(IProjectionReceiver projectionReceiver) {
        this.moduleController.stopProjectionButtonPressed(projectionReceiver);
    }

    @Override
    public IFrameUniqueElementManager getFrameUniqueElementMgr() {
        return this.uniqueElementMgr;
    }

    @Override
    public IPlanAgentUniqueElementManager getPlanAgentUniqueElementManager() {
        return this.uniqueElementMgr;
    }

    @Override
    public IModuleLinkManager getModuleLinkManager() {
        return this.linkMgr;
    }

    @Override
    public IModuleUniqueElementManager getModuleUniqueElementManager() {
        return this.uniqueElementMgr;
    }

    @Override
    public IFrameStakeholderManager getFrameStakeholderManager() {
        return this.stakeholderManager;
    }

    @Override
    public IFrameSectionManager getFrameSectionManager() {
        return this.sectionMgr;
    }

    @Override
    public IFrameReportTemplateFolderManager getFrameReportTemplateFolderManager() {
        return this.reportTemplatesFolderManager;
    }

    @Override
    public IFrameReportTemplateManager getFrameReportTemplateManager() {
        return this.reportTemplatesManager;
    }

    @Override
    public IFrameReportOutputTemplateManager getFrameReportOutputTemplateManager() {
        return this.reportOutputtemplatesManager;
    }

    @Override
    public IFrameLockManager getFrameLockManager() {
        return this.lockMgr;
    }

    @Override
    public IModuleLockManager getModuleLockManager() {
        return this.lockMgr;
    }

    @Override
    public IPlanAgentSectionManager getPlanAgentSectionManager() {
        return this.sectionMgr;
    }

    @Override
    public ISectionManager getSectionManager() {
        return this.sectionMgr;
    }

    @Override
    public IModuleSectionManager getModuleSectionManager() {
        return this.sectionMgr;
    }

    public IModuleStakeholderManager getModuleStakeholderManager() {
        return this.stakeholderManager;
    }

    @Override
    public IModulePlanEditorManager getModulePlanEditorManager() {
        return this.planEditorManager;
    }

    @Override
    public IModuleDNDManager getModuleDNDManager() {
        return this.dndManager;
    }

    @Override
    public IDNDManager getDNDManger() {
        return this.dndManager;
    }

    @Override
    public IFrameExportDataProvider getFrameExportDataProvider() {
        if (this.importExportManager == null) {
            this.importExportManager = new FrameImportExportManager(this);
        }
        return this.importExportManager;
    }

    @Override
    public IFrameImporter getFrameDataImporter() {
        if (this.importExportManager == null) {
            this.importExportManager = new FrameImportExportManager(this);
        }
        return this.importExportManager;
    }

    @Override
    public PlanImporterExporterManager getPlanImporterExporterManager() {
        return this.planImporterExporterManager;
    }

    @Override
    public IFramePermissionManager getFramePermissionManager() {
        return this.permissionModificationModel;
    }

    @Override
    public IPermissionModificationAgent getPermissionModificationAgent() {
        return this.permissionModificationModel;
    }

    public void doWithSuspendedAsynchronousUpdate(Runnable todo) {
        this.commitMgr.doWithSuspendedAsynchronousUpdate(todo);
    }

    public IArcwayMemento getLocalSettings(String moduleID) {
        return this.localSettingsStore.getLocalSetting(moduleID);
    }

    @Override
    public IArcwayMemento getFrameLocalSettings() {
        return this.localSettingsStore.getLocalSetting("frame.project");
    }

    @Override
    public IConfigurationManager getConfigurationManager() {
        if (this.configurationManager == null) {
            this.configurationManager = new ConfigurationManager(this);
        }
        return this.configurationManager;
    }

    @Override
    public DocGeneratorManager getDocGeneratorManager() {
        return this.docGeneratorManager;
    }

    @Override
    public void discardLocalModifications(Shell parentShell) {
        if (this.isOpened()) {
            this.switchAllEditorsIntoViewModeWithoutSaving(parentShell);
            this.modelTransactionManager.executeTransaction(new Runnable(){

                @Override
                public void run() {
                    List<IFrameDataManager> frameDataManagers = ProjectAgent.this.getDataManagers();
                    for (IFrameDataManager manager : frameDataManagers) {
                        manager.discardLocalModifications();
                    }
                }
            });
            this.lockMgr.releaseAllLocks();
            this.getCockpitController().discardLocalModifications();
        }
    }

    private void discardLocalModificationsAndRecreateInternalStructure() throws EXCorruptProjectData, JvmExternalResourceInteractionException {
        this.destroyInternalStructure();
        try {
            FileHelper.deleteFileOrDirectory((File)this.getProjectSubFolder(PROJECT_SUBFOLDER_MOD));
            FileHelper.deleteFileOrDirectory((File)this.getProjectSubFolder(PROJECT_SUBFOLDER_FILES));
        }
        finally {
            this.constructInternalStructure();
        }
        this.lockMgr.releaseAllLocks();
    }

    @Override
    public IModuleProjectAgent getModuleprojectAgent() {
        return this;
    }

    @Override
    public LinkManager getLinkDataManager() {
        return this.linkMgr;
    }

    @Override
    public UniqueElementMgr getUniqueElementManager() {
        return this.uniqueElementMgr;
    }

    @Override
    public IFrameProjectAgent getFrameProjectAgent() {
        return this;
    }

    @Override
    public IFrameUserDefinedAttributeTypesManager getFrameUserDefinedAttributeTypesManager() {
        return this.userDefinedAttributeTypesManager;
    }

    @Override
    public ObjectTypeCategoriesManager getObjectTypeCategoriesManager() {
        return this.objectTypeCategoriesManager;
    }

    @Override
    public FrameDataAttributeTypesProviderMgr getFrameDataAttributeTypesProviderManager() {
        return this.frameDataAttributeTypesProviderMgr;
    }

    @Override
    public IFrameDataManager getDataManager(String dataTypeID) {
        IFrameDataManager dataManager = this.dataManagers.get(dataTypeID);
        if (dataManager == null) {
            for (IFrameDataManager dm : this.getDataManagers()) {
                ModuleController mc;
                ModuleDataManager moduleDataManager;
                if (dm == null || !dm.handlesDataType(dataTypeID)) continue;
                if (dm instanceof ModuleController && (moduleDataManager = (mc = (ModuleController)dm).createModuleDataManager(dataTypeID)) != null) {
                    dm = moduleDataManager;
                }
                dataManager = dm;
                this.dataManagers.put(dataTypeID, dataManager);
                break;
            }
        }
        return dataManager;
    }

    @Override
    public IModuleUserDefinedAttributeTypesManager getModuleUserDefinedAttributeTypesManager() {
        return this.userDefinedAttributeTypesManager;
    }

    @Override
    public ILocksAndPermissionsTransactionController getLocksAndPermissionsTransactionController() {
        return new LocksAndPermissionsTransactionController(this);
    }

    @Override
    public IFilesManager getFilesManager() {
        return this.filesManager;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Collection<? extends IAttributeOwner> attributeOwners, Class<? extends IAttributeTypeDataType> clazz) {
        HashMap<IAttributeTypeDataType, Collection<IAttribute>> attributes = new HashMap<IAttributeTypeDataType, Collection<IAttribute>>();
        for (IAttributeOwner iAttributeOwner : attributeOwners) {
            ProjectAgent.getAttributes(iAttributeOwner, clazz, attributes);
        }
        return attributes;
    }

    private static void getAttributes(IAttributeOwner attributeOwner, Class<? extends IAttributeTypeDataType> clazz, Map<IAttributeTypeDataType, Collection<IAttribute>> allAttributesOfType) {
        for (IAttribute attribute : attributeOwner.getAllAttributes()) {
            IAttributeTypeDataType dataType = ProjectAgent.getDataType(attributeOwner, attribute);
            if (!clazz.isAssignableFrom(dataType.getClass())) continue;
            if (!allAttributesOfType.containsKey(dataType)) {
                allAttributesOfType.put(dataType, new ArrayList());
            }
            Collection<IAttribute> attributes = allAttributesOfType.get(dataType);
            attributes.add(attribute);
        }
    }

    private static IAttributeTypeDataType getDataType(IAttributeOwner attributeOwner, IAttribute attribute) {
        try {
            IAttributeType attributeType = attributeOwner.getAttributeType(attribute.getAttributeTypeID());
            return attributeType.getDataType();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getLanguage() {
        try {
            IAttribute attribute = this.metaDataManager.getProject().getAttribute(ProjectAttributeTypeProvider.ATTRID_LANGUAGE);
            return (String)attribute.getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return Locale.getDefault().getLanguage();
        }
    }

    @Override
    public ProjectMetaDataManager getProjectMetaDataManager() {
        return this.metaDataManager;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public Object getAdapter(Class adapter) {
        if (this.repositoryInterface != null && adapter.isAssignableFrom(this.repositoryInterface.getClass())) {
            return this.repositoryInterface;
        }
        return null;
    }

    @Override
    public IClientFunctionLicenseManager getServerLicenseManager() {
        IProjectManagerServerProxy projectManagerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.serverID);
        return projectManagerServerProxy.getFunctionLicenseManager();
    }

    @Override
    public ISequencerManager getSequencerManager() {
        return this.sequencerManager;
    }

    @Override
    public IRepositoryPlatformController getRepositoryPlattformController() {
        return this.repositoryPlattformController;
    }

    @Override
    public IFrameCockpitController getCockpitController() {
        return this.cockpitController;
    }

    @Override
    public IFrameSequencerManager getFrameSequencerManager() {
        return this.sequencerManager;
    }

    @Override
    public ICockpitProject getProject() {
        ProjectMetaDataManager manager = this.getProjectMetaDataManager();
        if (manager != null) {
            return manager.getProject();
        }
        return null;
    }

    @Override
    public IPlatformAdapterModule[] getPlatformAdapterModules() {
        ArrayList<IPlatformAdapterModule> adapterModules = new ArrayList<IPlatformAdapterModule>();
        adapterModules.add(new PlatformAdapterModuleProject(this));
        adapterModules.add(new PlatformAdapterModuleModelElement(this));
        adapterModules.add(new PlatformAdapterModuleSection(this));
        adapterModules.add(new PlatformAdapterModulePlan(this));
        adapterModules.add(new PlatformAdapterModuleStakeholder(this));
        adapterModules.add(new PlatformAdapterModuleReportTemplates(this));
        adapterModules.add(new PlatformAdapterModuleModules());
        adapterModules.add(new PlatformAdapterModuleInfoLink());
        IPlatformAdapterModule[] moduleAdapterModules = this.moduleController.getModulePlatformAdapterModules();
        adapterModules.addAll(Arrays.asList(moduleAdapterModules));
        return adapterModules.toArray(new IPlatformAdapterModule[adapterModules.size()]);
    }

    @Override
    public IFrontendTypeManager getFrontendTypeManager() {
        return FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)this.getRepositoryInterface().getTypeManager());
    }

    @Override
    public IRepositoryPropertySetSample getRepositoryObjectID(String cockpitDataUID) {
        return this.repositoryPlattformController.getRepositoryObjectID(cockpitDataUID);
    }

    @Override
    public String getCockpitDataUID(IRepositoryPropertySetSample repositoryObjectID) {
        return this.repositoryPlattformController.getCockpitDataUID(repositoryObjectID);
    }

    @Override
    public IRepositoryObject findRepositoryObject(IRepositorySnapshotRO snapshot, ICockpitDataID cockpitDataID) throws EXNotReproducibleSnapshot {
        return this.repositoryPlattformController.findRepositoryObject(snapshot, cockpitDataID);
    }

    public AtomicModificationDataAccessor getAtomicModificationDataAccessor() {
        return this.atomicModificationDataAccessor;
    }

    @Override
    public IPermissionOperand getBaseOperand() {
        return this;
    }

    @Override
    public IPermissionOperand getParent(IPermissionOperand childOperand) {
        return null;
    }

    @Override
    public void doWithCurrentServerDataContainer(final IServerDataContainerProcessor serverDataContainerProcessor) throws Exception {
        final boolean[] retry = new boolean[]{true};
        final Exception[] exception = new Exception[1];
        int trysAllowed = 100;
        int trysProcessed = 0;
        do {
            if (trysProcessed >= 100) {
                throw new EXApplicationOfAsynchronousUpdatesHungUp(trysProcessed);
            }
            this.serverProxy.refreshProject();
            this.doWithSuspendedAsynchronousUpdate(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServerDataContainer serverDataContainer = ProjectAgent.this.serverProxy.fetchServerDataContainer(ProjectAgent.this.lockMgr.getAllLocksCurrentlyAllocatedOnServer());
                        serverDataContainerProcessor.processServerDataContainer_theClientIsOnSameState(serverDataContainer);
                        retry[0] = false;
                    }
                    catch (EXPendingAsynchronousUpdates e) {
                        retry[0] = true;
                    }
                    catch (Exception e) {
                        retry[0] = false;
                        exception[0] = e;
                    }
                }
            });
            ++trysProcessed;
        } while (retry[0]);
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    @Override
    public boolean isInMemoryStateConsistent() {
        return this.atomicModificationDataAccessor.isInMemoryStateConsistent();
    }

    @Override
    public boolean isDiskStateInSynchWithInMemoryState() {
        return this.atomicModificationDataAccessor.isDiskStateInSynchWithInMemoryState();
    }

    public ModelTransactionManager getModelTransactionManager() {
        return this.modelTransactionManager;
    }

    private class PermissionChangePropagator
    implements Runnable {
        private final Collection<EOPermission> addedPermissions = new ArrayList<EOPermission>();
        private final Collection<EOPermission> removedPermissions = new ArrayList<EOPermission>();

        private PermissionChangePropagator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProjectAgent projectAgent = ProjectAgent.this;
            synchronized (projectAgent) {
                ProjectAgent.this.permissionChangePropagator = null;
                PropertyChanges changes = new PropertyChanges(this.addedPermissions, null, this.removedPermissions);
                ProjectAgent.this.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, EOPermission.class);
            }
        }
    }

    private static class ProjectCloseListenerWithPriority {
        private final IProjectCloseListener projectCloseListener;
        private final int priority;

        public ProjectCloseListenerWithPriority(IProjectCloseListener projectCloseListener, int priority) {
            this.projectCloseListener = projectCloseListener;
            this.priority = priority;
        }

        public IProjectCloseListener getProjectCloseListener() {
            return this.projectCloseListener;
        }

        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return this.projectCloseListener == null ? 0 : this.projectCloseListener.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ProjectCloseListenerWithPriority && this.projectCloseListener == ((ProjectCloseListenerWithPriority)obj).getProjectCloseListener();
        }
    }
}

