/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.IModelTransactionManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class ModelTransactionManager
implements IModelTransactionManager {
    private static final ILogger logger = Logger.getLogger(ModelTransactionManager.class);
    private final ProjectAgent projectAgent;
    private int transactionParenthesisCount;

    ModelTransactionManager(ProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.transactionParenthesisCount = 0;
    }

    public synchronized void executeTransaction(final Runnable todo) {
        assert (this.transactionParenthesisCount >= 0);
        boolean currentlyNotInSuspendMode = this.transactionParenthesisCount == 0;
        ++this.transactionParenthesisCount;
        try {
            if (currentlyNotInSuspendMode) {
                final Runnable modFileSavingTodo = new Runnable(){

                    @Override
                    public void run() {
                        ModelTransactionManager.this.projectAgent.getAtomicModificationDataAccessor().doWithDelayedWriteThrough(todo);
                    }
                };
                final Runnable propertyEventsTodo = new Runnable(){

                    @Override
                    public void run() {
                        ModelTransactionManager.this.projectAgent.getPropertyChangesProviderManager().doWithSuspendedPropertyEventPropagation(modFileSavingTodo);
                    }
                };
                Runnable asyncUpdatesTodo = new Runnable(){

                    @Override
                    public void run() {
                        ModelTransactionManager.this.projectAgent.doWithSuspendedAsynchronousUpdate(propertyEventsTodo);
                    }
                };
                try {
                    asyncUpdatesTodo.run();
                }
                catch (Exception e) {
                    logger.warn("Exception during transaction processing in AbstractDataManager.", (Throwable)e);
                }
            } else {
                todo.run();
            }
        }
        finally {
            --this.transactionParenthesisCount;
        }
    }

    public int getTransactionParenthesisCount() {
        return this.transactionParenthesisCount;
    }

    public boolean isInTransaction() {
        assert (this.transactionParenthesisCount >= 0);
        return this.transactionParenthesisCount > 0;
    }
}

