/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.relationviews;

import com.arcway.cockpit.frame.client.lib.relationviews.ITextExtendCalculator;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.lib.graphics.text.IFont;
import com.arcway.lib.graphics.text.TextStyle;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class ViewPartTextExtendCalculator
implements ITextExtendCalculator {
    private static IFont currentFont = null;
    private static TextStyle currentTextStyle = null;

    @Override
    public int getTextHeight(Font font) {
        int height = (int)Math.ceil(this.getFontHeightInPixels(font));
        return height;
    }

    @Override
    public int getTextWidth(Font font, String text) {
        int width = 0;
        try {
            String fontName = font.getFontData()[0].getName();
            TextStyle textStyle = new TextStyle(fontName);
            this.updateFont(textStyle);
            width = (int)Math.ceil(currentFont.getTextExtend(text).w() * this.getFontHeightInPixels(font));
        }
        catch (EXNoMoreHandles e) {
            width = FigureUtilities.getTextExtents((String)text, (Font)font).width;
        }
        return width;
    }

    private double getFontHeightInPixels(Font font) {
        int swtHeightInPointsPostscript = font.getFontData()[0].getHeight();
        Display screen = Display.getDefault();
        int screenDPIy = screen.getDPI().y;
        return (double)swtHeightInPointsPostscript / 72.0 * (double)screenDPIy / 0.8075987144168962;
    }

    private void updateFont(TextStyle newTextStyle) throws EXNoMoreHandles {
        if (currentTextStyle == null || !currentTextStyle.isEqualTextStyle(newTextStyle)) {
            this.disposeFont();
            currentTextStyle = newTextStyle;
            try {
                IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
                currentFont = renderer.createFont(currentTextStyle);
            }
            catch (EXNoMoreHandles e) {
                currentFont = null;
                currentTextStyle = null;
                throw e;
            }
        }
    }

    private void disposeFont() {
        if (currentFont != null) {
            currentFont.dispose();
            currentFont = null;
        }
    }
}

