/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ColumnState;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateModelAccess;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperWO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IMemento;

public class TreeDataViewState<ContentType> {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED_OBJECTS = "expandedObjects";
    private static final String TAG_FILTERED_EXPANDED_OBJECTS = "filteredExpandedObjects";
    private static final String TAG_COLUMN_STATES = "columnStates";
    private static final String TAG_COLUMN_STATE = "columnState";
    private static final String TAG_COLUMN_ID = "columnID";
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    private static final String TAG_COLUMN_POSITION = "columnPosition";
    private static final String TAG_COLUMN_SHOWN = "columnShown";
    private static final String TAG_COLUMN_SORTINGDIRECTION = "columnSortingDirections";
    private static final String TAG_COLUMN_SORTINGORDERRANK = "columnSortingOrderRank";
    private static final String TAG_SORTINGMODE = "sortingMode";
    private static final String TAG_OBJECT = "object";
    private static final String TAG_TREEPATH = "treePath";
    private static final String TAG_TREEPATHSEGMENT = "treePathSegment";
    private static final String TAG_ADDITIONALSTATEINFORMATION = "additionalstateinformation";
    private Collection<ColumnState> columnStates;
    private ISelection initiallySelectedItems = new StructuredSelection();
    private List<TreePath> initiallyExpandedItems = Collections.emptyList();
    private List<TreePath> filteredExpandedItems = Collections.emptyList();
    private int sortingMode = -1;
    private Map<String, String> additionalStateInformation;
    private Map<String, ColumnState> map_id_columnState;
    private List<String> defaultPositionOrderWithInvisibles;
    private List<String> defaultPositionOrder;
    private List<String> initialPositionOrderWithInvisibles;
    private int[] initialPositionOrderPermutation;
    private List<String> currentSortingOrderWithInvisibles;
    private List<String> currentSortingOrder;

    public TreeDataViewState(IMemento memento, ITreeDataViewStateSerialisationHelper<ContentType> serialisationHelper, ITreeDataViewStateModelAccess<ContentType> modelAccess) {
        this();
        super.loadState(memento, serialisationHelper, modelAccess);
    }

    public TreeDataViewState() {
        this.columnStates = Collections.emptyList();
        this.additionalStateInformation = new HashMap<String, String>();
    }

    public int getColumnCount() {
        return this.map_id_columnState.keySet().size();
    }

    public int getShownColumnCount() {
        return this.defaultPositionOrder.size();
    }

    public List<String> getAllColumnsInDefaultOrder() {
        return this.defaultPositionOrderWithInvisibles;
    }

    public List<String> getShownColumnsInDefaultOrder() {
        return this.defaultPositionOrder;
    }

    public int getColumnIndex(String columnID) {
        return this.defaultPositionOrder.indexOf(columnID);
    }

    public String getColumnByIndex(int index) {
        return this.defaultPositionOrder.get(index);
    }

    public int[] getInitialPositionPermutation() {
        return this.initialPositionOrderPermutation;
    }

    public String getColumnName(String columnID) {
        return this.map_id_columnState.get(columnID).getName();
    }

    public String getColumnDescription(String columnID) {
        return this.map_id_columnState.get(columnID).getDescription();
    }

    public int getColumnWidth(String columnID) {
        return this.map_id_columnState.get(columnID).getWidth();
    }

    public boolean isColumnShown(String columnID) {
        return this.map_id_columnState.get(columnID).isShown();
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    public int getColumnSortingDirection(String columnID) {
        return this.map_id_columnState.get(columnID).getSortingDirection();
    }

    public IDataViewColumnComparator getColumnComparator(String columnID) {
        return this.map_id_columnState.get(columnID).getComparator();
    }

    public String getColumnBySortingPriority(int sortingPriority) {
        return this.currentSortingOrder.get(sortingPriority);
    }

    public boolean isSortingOrderFirstPriorityColumn(String columnID) {
        return this.currentSortingOrder.get(0).equals(columnID);
    }

    public ISelection getInitiallySelectedItems() {
        return this.initiallySelectedItems;
    }

    public TreePath[] getInitiallyExpandedItems() {
        return this.initiallyExpandedItems.toArray(new TreePath[this.initiallyExpandedItems.size()]);
    }

    public List<TreePath> getFilteredExpandedItems() {
        return this.filteredExpandedItems;
    }

    public String getAdditionalStateInformation(String key) {
        return this.additionalStateInformation.get(key);
    }

    public void setColumnWidth(String columnID, int width) {
        this.map_id_columnState.get(columnID).setWidth(width);
    }

    public void setSortingMode(int sortingMode) {
        this.sortingMode = sortingMode;
    }

    public void setSortingOrderFirstPriorityColumn(String columnID) {
        this.currentSortingOrderWithInvisibles.remove(columnID);
        this.currentSortingOrderWithInvisibles.add(0, columnID);
        this.currentSortingOrder.remove(columnID);
        this.currentSortingOrder.add(0, columnID);
    }

    public void setColumnSortingDirection(String columnID, int sortingDirection) {
        this.map_id_columnState.get(columnID).setSortingDirection(sortingDirection);
    }

    public void setColumnShown(String columnID, boolean isShown) {
        this.map_id_columnState.get(columnID).setShown(isShown);
    }

    public void setAdditionalStateInformation(String key, String stateInformation) {
        this.additionalStateInformation.put(key, stateInformation);
    }

    public void startUsage(Collection<IColumnDescription> currentColumns, int defaultSortingMode) {
        this.map_id_columnState = new HashMap<String, ColumnState>();
        for (IColumnDescription columnDescription : currentColumns) {
            ColumnState columnState = new ColumnState(columnDescription);
            this.map_id_columnState.put(columnDescription.getId(), columnState);
        }
        for (ColumnState savedColumnState : this.columnStates) {
            ColumnState columnState = this.map_id_columnState.get(savedColumnState.getId());
            if (columnState == null) continue;
            columnState.setWidth(savedColumnState.getWidth());
            columnState.setPosition(savedColumnState.getPosition());
            columnState.setShown(savedColumnState.isShown());
            columnState.setSortingDirection(savedColumnState.getSortingDirection());
            columnState.setSortingOrderRank(savedColumnState.getSortingOrderRank());
        }
        if (this.sortingMode == -1) {
            this.sortingMode = defaultSortingMode;
        }
        this.defaultPositionOrderWithInvisibles = new LinkedList<String>(this.map_id_columnState.keySet());
        Collections.sort(this.defaultPositionOrderWithInvisibles, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o1)).getDefaultPosition() - ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o2)).getDefaultPosition();
            }
        });
        this.initialPositionOrderWithInvisibles = new LinkedList<String>();
        for (ColumnState columnState2 : this.map_id_columnState.values()) {
            if (columnState2.getPosition() == -1) continue;
            this.initialPositionOrderWithInvisibles.add(columnState2.getId());
        }
        Collections.sort(this.initialPositionOrderWithInvisibles, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o1)).getPosition() - ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o2)).getPosition();
            }
        });
        TreeDataViewState.integrateUnorderedColumnsAccordingToBaseOrder(this.initialPositionOrderWithInvisibles, this.defaultPositionOrderWithInvisibles);
        this.defaultPositionOrder = new LinkedList<String>(this.defaultPositionOrderWithInvisibles);
        Iterator<String> i = this.defaultPositionOrder.iterator();
        while (i.hasNext()) {
            if (this.map_id_columnState.get(i.next()).isShown()) continue;
            i.remove();
        }
        this.initialPositionOrderPermutation = new int[this.defaultPositionOrder.size()];
        int index = 0;
        for (String columnID : this.initialPositionOrderWithInvisibles) {
            if (!this.map_id_columnState.get(columnID).isShown()) continue;
            this.initialPositionOrderPermutation[index] = this.defaultPositionOrder.indexOf(columnID);
            ++index;
        }
        LinkedList<String> defaultSortingOrderWithInvisibles = new LinkedList<String>(this.map_id_columnState.keySet());
        Collections.sort(defaultSortingOrderWithInvisibles, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o1)).getDeafultSortingOrderRank() - ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o2)).getDeafultSortingOrderRank();
            }
        });
        this.currentSortingOrderWithInvisibles = new LinkedList<String>();
        for (ColumnState columnState : this.map_id_columnState.values()) {
            if (columnState.getSortingOrderRank() == -1) continue;
            this.currentSortingOrderWithInvisibles.add(columnState.getId());
        }
        Collections.sort(this.currentSortingOrderWithInvisibles, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o1)).getSortingOrderRank() - ((ColumnState)TreeDataViewState.this.map_id_columnState.get(o2)).getSortingOrderRank();
            }
        });
        TreeDataViewState.integrateUnorderedColumnsAccordingToBaseOrder(this.currentSortingOrderWithInvisibles, defaultSortingOrderWithInvisibles);
        this.currentSortingOrder = new LinkedList<String>(this.currentSortingOrderWithInvisibles);
        Iterator<String> iterator = this.currentSortingOrder.iterator();
        while (iterator.hasNext()) {
            if (this.map_id_columnState.get(iterator.next()).isShown()) continue;
            iterator.remove();
        }
    }

    public void stopUsage(ISelection currentSelection, TreePath[] currentlyExpandedItems, int[] currentColumnOrder, List<TreePath> filteredExpandedElements) {
        this.initiallySelectedItems = currentSelection;
        this.initiallyExpandedItems = Arrays.asList(currentlyExpandedItems);
        this.filteredExpandedItems = filteredExpandedElements;
        LinkedList<String> finalPositionOrder = new LinkedList<String>();
        int[] nArray = currentColumnOrder;
        int n = currentColumnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            finalPositionOrder.add(this.defaultPositionOrder.get(element));
            ++n2;
        }
        TreeDataViewState.integrateUnorderedColumnsAccordingToBaseOrder(finalPositionOrder, this.initialPositionOrderWithInvisibles);
        int index = 0;
        for (String columnID : finalPositionOrder) {
            this.map_id_columnState.get(columnID).setPosition(index);
            ++index;
        }
        int c = 0;
        while (c < this.currentSortingOrderWithInvisibles.size()) {
            this.map_id_columnState.get(this.currentSortingOrderWithInvisibles.get(c)).setSortingOrderRank(c);
            ++c;
        }
        this.columnStates = new ArrayList<ColumnState>(this.map_id_columnState.values());
    }

    private static void integrateUnorderedColumnsAccordingToBaseOrder(List<String> currentOrder, List<String> baseOrder) {
        for (String idToBeIntegrated : baseOrder) {
            if (currentOrder.contains(idToBeIntegrated)) continue;
            int bestMatchingIndex = 0;
            int bestMatch = 0;
            int currentMatch = 0;
            int index = 0;
            while (index < currentOrder.size()) {
                currentMatch = baseOrder.indexOf(idToBeIntegrated) < baseOrder.indexOf(currentOrder.get(index)) ? --currentMatch : ++currentMatch;
                if (currentMatch >= bestMatch) {
                    bestMatch = currentMatch;
                    bestMatchingIndex = index + 1;
                }
                ++index;
            }
            currentOrder.add(bestMatchingIndex, idToBeIntegrated);
        }
    }

    private void loadState(IMemento memento, ITreeDataViewStateSerialisationHelper<ContentType> serialisationHelper, ITreeDataViewStateModelAccess<ContentType> modelAccess) {
        IMemento additionalStateMemento;
        IMemento sortingModeMemento;
        IMemento selectionMemento = memento.getChild(TAG_SELECTION);
        List selectionElements = selectionMemento != null ? this.resurrectObjects(selectionMemento, serialisationHelper) : Collections.emptyList();
        this.initiallySelectedItems = new StructuredSelection(selectionElements);
        IMemento expandedMemento = memento.getChild(TAG_EXPANDED_OBJECTS);
        List expandedElementsList = expandedMemento != null ? this.resurrectTreePaths(expandedMemento, serialisationHelper) : Collections.emptyList();
        this.initiallyExpandedItems = expandedElementsList;
        IMemento filteredExpandedMemento = memento.getChild(TAG_FILTERED_EXPANDED_OBJECTS);
        List filteredExpandedElementsList = filteredExpandedMemento != null ? this.resurrectTreePaths(filteredExpandedMemento, serialisationHelper) : Collections.emptyList();
        this.filteredExpandedItems = new ArrayList(filteredExpandedElementsList);
        IMemento columnStatesMemento = memento.getChild(TAG_COLUMN_STATES);
        if (columnStatesMemento != null) {
            this.columnStates = new LinkedList<ColumnState>();
            IMemento[] iMementoArray = columnStatesMemento.getChildren(TAG_COLUMN_STATE);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento columnStateMemento = iMementoArray[n2];
                ColumnState columnState = new ColumnState(columnStateMemento.getString(TAG_COLUMN_ID));
                columnState.setWidth(columnStateMemento.getInteger(TAG_COLUMN_WIDTH));
                columnState.setPosition(columnStateMemento.getInteger(TAG_COLUMN_POSITION));
                columnState.setShown(columnStateMemento.getInteger(TAG_COLUMN_SHOWN) > 0);
                columnState.setSortingDirection(columnStateMemento.getInteger(TAG_COLUMN_SORTINGDIRECTION));
                columnState.setSortingOrderRank(columnStateMemento.getInteger(TAG_COLUMN_SORTINGORDERRANK));
                this.columnStates.add(columnState);
                ++n2;
            }
        }
        if ((sortingModeMemento = memento.getChild(TAG_SORTINGMODE)) != null) {
            this.sortingMode = sortingModeMemento.getInteger(TAG_SORTINGMODE);
        }
        if ((additionalStateMemento = memento.getChild(TAG_ADDITIONALSTATEINFORMATION)) != null) {
            String[] stringArray = additionalStateMemento.getAttributeKeys();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String key = stringArray[n3];
                String value = additionalStateMemento.getString(key);
                this.additionalStateInformation.put(key, value);
                ++n3;
            }
        }
        this.checkState(modelAccess);
    }

    public void saveState(IMemento memento, ITreeDataViewStateSerialisationHelperWO<ContentType> modelAccess) {
        if (this.initiallySelectedItems != null && this.initiallySelectedItems instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.initiallySelectedItems;
            IMemento selectionMemento = memento.createChild(TAG_SELECTION);
            this.saveObjects(selectionMemento, structuredSelection.toList(), modelAccess);
        }
        if (this.initiallyExpandedItems != null) {
            IMemento expandedMemento = memento.createChild(TAG_EXPANDED_OBJECTS);
            this.saveTreePaths(expandedMemento, this.initiallyExpandedItems, modelAccess);
        }
        if (this.filteredExpandedItems != null) {
            IMemento filteredExpandedMemento = memento.createChild(TAG_FILTERED_EXPANDED_OBJECTS);
            this.saveTreePaths(filteredExpandedMemento, this.filteredExpandedItems, modelAccess);
        }
        if (this.columnStates != null) {
            IMemento columnStatesMemento = memento.createChild(TAG_COLUMN_STATES);
            for (ColumnState columnState : this.columnStates) {
                IMemento columnStateMemento = columnStatesMemento.createChild(TAG_COLUMN_STATE);
                columnStateMemento.putString(TAG_COLUMN_ID, columnState.getId());
                columnStateMemento.putInteger(TAG_COLUMN_WIDTH, columnState.getWidth());
                columnStateMemento.putInteger(TAG_COLUMN_POSITION, columnState.getPosition());
                columnStateMemento.putInteger(TAG_COLUMN_SHOWN, columnState.isShown() ? 1 : 0);
                columnStateMemento.putInteger(TAG_COLUMN_SORTINGDIRECTION, columnState.getSortingDirection());
                columnStateMemento.putInteger(TAG_COLUMN_SORTINGORDERRANK, columnState.getSortingOrderRank());
            }
        }
        IMemento sortingModeMemento = memento.createChild(TAG_SORTINGMODE);
        sortingModeMemento.putInteger(TAG_SORTINGMODE, this.sortingMode);
        IMemento additionalStateMemento = memento.createChild(TAG_ADDITIONALSTATEINFORMATION);
        for (Map.Entry<String, String> entry : this.additionalStateInformation.entrySet()) {
            additionalStateMemento.putString(entry.getKey(), entry.getValue());
        }
    }

    public static <ContentType> void copyMemento(IMemento source, IMemento target, ITreeDataViewStateSerialisationHelperWO<ContentType> modelAccess) {
        IMemento sourceSortingMode;
        IMemento sourceSelection = source.getChild(TAG_SELECTION);
        IMemento targetSelection = target.createChild(TAG_SELECTION);
        TreeDataViewState.copyObjects(sourceSelection, targetSelection, modelAccess);
        IMemento sourceExpansion = source.getChild(TAG_EXPANDED_OBJECTS);
        IMemento targetExpansion = target.createChild(TAG_EXPANDED_OBJECTS);
        TreeDataViewState.copyObjects(sourceExpansion, targetExpansion, modelAccess);
        IMemento sourceFilteredExpansion = source.getChild(TAG_FILTERED_EXPANDED_OBJECTS);
        IMemento targetFilteredExpansion = target.createChild(TAG_FILTERED_EXPANDED_OBJECTS);
        TreeDataViewState.copyObjects(sourceFilteredExpansion, targetFilteredExpansion, modelAccess);
        IMemento sourceColumnStates = source.getChild(TAG_COLUMN_STATES);
        if (sourceColumnStates != null) {
            IMemento targetColumnSates = target.createChild(TAG_COLUMN_STATES);
            targetColumnSates.putMemento(sourceColumnStates);
        }
        if ((sourceSortingMode = source.getChild(TAG_SORTINGMODE)) != null) {
            IMemento targetSortingMode = target.createChild(TAG_SORTINGMODE);
            targetSortingMode.putMemento(sourceSortingMode);
        }
    }

    private List<ContentType> resurrectObjects(IMemento memento, ITreeDataViewStateSerialisationHelper<ContentType> modelAccess) {
        IMemento[] objectMementos;
        ArrayList<ContentType> objects = new ArrayList<ContentType>();
        IMemento[] iMementoArray = objectMementos = memento.getChildren(TAG_OBJECT);
        int n = objectMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento objectMemento = iMementoArray[n2];
            try {
                ContentType dataItem = modelAccess.readDataItemFromMemento(objectMemento);
                if (dataItem != null) {
                    objects.add(dataItem);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n2;
        }
        return objects;
    }

    private List<TreePath> resurrectTreePaths(IMemento memento, ITreeDataViewStateSerialisationHelper<ContentType> modelAccess) {
        IMemento[] treePathMementos;
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        IMemento[] iMementoArray = treePathMementos = memento.getChildren(TAG_TREEPATH);
        int n = treePathMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento treePathMemento;
            IMemento segmentParentMemento = treePathMemento = iMementoArray[n2];
            ArrayList<ContentType> segments = new ArrayList<ContentType>();
            boolean noMoreSegments = false;
            while (!noMoreSegments) {
                IMemento segmentMemento = segmentParentMemento.getChild(TAG_TREEPATHSEGMENT);
                if (segmentMemento != null) {
                    try {
                        ContentType dataItem = modelAccess.readDataItemFromMemento(segmentMemento);
                        if (dataItem == null) break;
                        segments.add(dataItem);
                    }
                    catch (NullPointerException e) {
                        break;
                    }
                    segmentParentMemento = segmentMemento;
                    continue;
                }
                noMoreSegments = true;
                treePaths.add(new TreePath(segments.toArray()));
            }
            ++n2;
        }
        return treePaths;
    }

    private void saveObjects(IMemento memento, Collection<ContentType> objects, ITreeDataViewStateSerialisationHelperWO<ContentType> modelAccess) {
        for (ContentType next : objects) {
            IMemento objectMemento = memento.createChild(TAG_OBJECT);
            modelAccess.storeDataItemReferenceIntoMemento(next, objectMemento);
        }
    }

    private void saveTreePaths(IMemento memento, Collection<TreePath> treePaths, ITreeDataViewStateSerialisationHelperWO<ContentType> modelAccess) {
        for (TreePath treePath : treePaths) {
            IMemento treePathMemento;
            IMemento segmentParentMemento = treePathMemento = memento.createChild(TAG_TREEPATH);
            int index = 0;
            while (index < treePath.getSegmentCount()) {
                IMemento segmentMemento = segmentParentMemento.createChild(TAG_TREEPATHSEGMENT);
                modelAccess.storeDataItemReferenceIntoMemento(treePath.getSegment(index), segmentMemento);
                segmentParentMemento = segmentMemento;
                ++index;
            }
        }
    }

    private static <ContentType> void copyObjects(IMemento source, IMemento target, ITreeDataViewStateSerialisationHelperWO<ContentType> modelAccess) {
        if (source != null) {
            IMemento[] sourceObjects;
            IMemento[] iMementoArray = sourceObjects = source.getChildren(TAG_OBJECT);
            int n = sourceObjects.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento sourceObject = iMementoArray[n2];
                try {
                    IMemento targetObject = target.createChild(TAG_OBJECT);
                    modelAccess.copyDataItemReferenceBetweenMementos(sourceObject, targetObject);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public void checkState(ITreeDataViewStateModelAccess<ContentType> modelAccess) {
        if (this.initiallyExpandedItems != null) {
            ArrayList<TreePath> expandedElementList = new ArrayList<TreePath>(this.initiallyExpandedItems);
            this.removeObsoleteTreePaths(expandedElementList, modelAccess);
            this.initiallyExpandedItems = expandedElementList;
        }
        if (this.filteredExpandedItems != null) {
            ArrayList<TreePath> filteredExpandedElementList = new ArrayList<TreePath>(this.filteredExpandedItems);
            this.removeObsoleteTreePaths(filteredExpandedElementList, modelAccess);
            this.filteredExpandedItems = filteredExpandedElementList;
        }
        if (this.initiallySelectedItems != null && this.initiallySelectedItems instanceof IStructuredSelection) {
            ArrayList selectionList = new ArrayList(((IStructuredSelection)this.initiallySelectedItems).toList());
            this.removeObsoleteItems(selectionList, modelAccess);
            this.initiallySelectedItems = new StructuredSelection(selectionList);
        }
    }

    public static <ContentType> boolean checkTreePath(TreePath treePath, ITreeDataViewStateModelAccess<ContentType> modelAccess) {
        Object lastSegment = null;
        int index = 0;
        while (index < treePath.getSegmentCount()) {
            Object segment = treePath.getSegment(index);
            if (!modelAccess.itemExists(segment)) {
                return false;
            }
            if (index > 0 && !modelAccess.isChildOfParent(lastSegment, segment)) {
                return false;
            }
            lastSegment = segment;
            ++index;
        }
        return true;
    }

    private void removeObsoleteItems(Collection<ContentType> items, ITreeDataViewStateModelAccess<ContentType> modelAccess) {
        Iterator<ContentType> i = items.iterator();
        while (i.hasNext()) {
            ContentType element = i.next();
            if (modelAccess.itemExists(element)) continue;
            i.remove();
        }
    }

    private void removeObsoleteTreePaths(Collection<TreePath> treePaths, ITreeDataViewStateModelAccess<ContentType> modelAccess) {
        Iterator<TreePath> i = treePaths.iterator();
        while (i.hasNext()) {
            TreePath treePath = i.next();
            if (TreeDataViewState.checkTreePath(treePath, modelAccess)) continue;
            i.remove();
        }
    }
}

