/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewSortingState;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public abstract class TreeDataViewSorter<ContentType>
extends ViewerSorter {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    public static final int SORTING_MODE__NATURAL_ORDER = 1;
    public static final int SORTING_MODE__COLUMN_BASED_ORDER = 2;
    public static final int SORTING_MODE_UNKNOWN = -1;
    private IDataViewSortingState sortingState;

    public TreeDataViewSorter(IDataViewSortingState sortingState) {
        this.sortingState = sortingState;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Object dataItem1 = e1;
        Object dataItem2 = e2;
        Integer typeComparison = this.compareAccordingToType(dataItem1, dataItem2);
        if (typeComparison != null) {
            return typeComparison;
        }
        Integer typeSpecificRuleComparison = this.compareAccordingToTypeSpecificRule(dataItem1, dataItem2);
        if (typeSpecificRuleComparison != null) {
            return typeSpecificRuleComparison;
        }
        if (this.sortingState.getSortingMode() == 2) {
            return this.compareColumnValues(dataItem1, dataItem2, 0);
        }
        Integer naturalOrderComparison = this.compareAccordingToNaturalOrder(dataItem1, dataItem2);
        if (naturalOrderComparison != null) {
            return naturalOrderComparison;
        }
        return 0;
    }

    private int compareColumnValues(Object e1, Object e2, int sortingPriority) {
        if (sortingPriority >= this.sortingState.getColumnCount()) {
            return 0;
        }
        IDataViewColumnComparator comparator = this.sortingState.getComparator(sortingPriority);
        if (comparator == null) {
            return this.compareColumnValues(e1, e2, sortingPriority + 1);
        }
        int result = comparator.compare(e1, e2);
        if (result == 0) {
            return this.compareColumnValues(e1, e2, sortingPriority + 1);
        }
        return result *= this.sortingState.getSortingDirection(sortingPriority);
    }

    protected abstract Integer compareAccordingToType(ContentType var1, ContentType var2);

    protected abstract Integer compareAccordingToTypeSpecificRule(ContentType var1, ContentType var2);

    protected abstract Integer compareAccordingToNaturalOrder(ContentType var1, ContentType var2);

    public void destroyInternalStructure() {
        this.sortingState = null;
    }
}

