/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.license;

import com.arcway.cockpit.frame.client.global.license.AbstractClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientModuleLicense;
import com.arcway.cockpit.frame.client.global.license.IClientModuleLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientProductOrModuleLicense;
import java.util.HashMap;
import java.util.Map;

public abstract class HierarchicalClientFunctionLicenseType
extends AbstractClientFunctionLicenseType2 {
    private static Map<String, Map<String, Object>> productLicense_functionLicenses = new HashMap<String, Map<String, Object>>();
    private static Map<String, Map<String, Object>> moduleLicense_functionLicenses = new HashMap<String, Map<String, Object>>();

    @Override
    protected final Object getLicenseValue(IClientProductOrModuleLicense license) {
        if (license instanceof IClientProductLicense) {
            return this.getLicenseValue(((IClientProductLicense)license).getType());
        }
        if (license instanceof IClientModuleLicense) {
            return this.getLicenseValue(moduleLicense_functionLicenses.get(((IClientModuleLicense)license).getModuleID()));
        }
        assert (false);
        return this.getDenialValue();
    }

    @Override
    public final boolean isGrantedByProductLicenseOfType(IClientProductLicenseType productLicenseType) {
        Object licenseValue = this.getLicenseValue(productLicenseType);
        return !this.isDenialValue(licenseValue);
    }

    private Object getLicenseValue(IClientProductLicenseType productLicenseType) {
        Map<String, Object> licenseType_licenseValue = productLicense_functionLicenses.get(productLicenseType.getProductID());
        return this.getLicenseValue(licenseType_licenseValue);
    }

    private Object getLicenseValue(Map<String, Object> licenseType_licenseValue) {
        String typeID = this.getKey();
        if (licenseType_licenseValue == null) {
            return this.getDenialValue();
        }
        while (true) {
            Object value;
            if ((value = licenseType_licenseValue.get(typeID)) != null) {
                return value;
            }
            if (typeID.indexOf(".") < 0) break;
            typeID = typeID.substring(0, typeID.lastIndexOf("."));
        }
        return this.getDenialValue();
    }

    @Override
    public final boolean isDenial(IClientFunctionLicense license) {
        return license == null || this.isDenialValue(license.getValue());
    }

    private boolean isDenialValue(Object licenseValue) {
        return licenseValue == null || this.getDenialValue() != null && this.getDenialValue().equals(licenseValue);
    }

    protected abstract Object getDenialValue();

    protected static final void setLicense(IClientProductLicenseType productLicenseType, String clientFunctionLicenseTypeKey, Object licenseValue) {
        Map<String, Object> licenseType_licenseValue = productLicense_functionLicenses.get(productLicenseType.getProductID());
        if (licenseType_licenseValue == null) {
            licenseType_licenseValue = new HashMap<String, Object>();
            productLicense_functionLicenses.put(productLicenseType.getProductID(), licenseType_licenseValue);
        }
        licenseType_licenseValue.put(clientFunctionLicenseTypeKey, licenseValue);
    }

    protected static final void setLicense(IClientModuleLicenseType moduleLicenseType, String clientFunctionLicenseTypeKey, Object licenseValue) {
        Map<String, Object> licenseType_licenseValue = moduleLicense_functionLicenses.get(moduleLicenseType);
        if (licenseType_licenseValue == null) {
            licenseType_licenseValue = new HashMap<String, Object>();
            moduleLicense_functionLicenses.put(moduleLicenseType.getModuleID(), licenseType_licenseValue);
        }
        licenseType_licenseValue.put(clientFunctionLicenseTypeKey, licenseValue);
    }
}

