/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.linkview;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.LinkView;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.LinkViewContentProvider;
import org.eclipse.jface.action.Action;

public class FilterForLinkTypeAction
extends Action {
    private final ILinkContentProvider linkContentProvider;
    private final LinkViewContentProvider contentProvider;
    private final LinkView linkView;
    private boolean show;

    protected FilterForLinkTypeAction(ILinkContentProvider linkContentProvider, boolean show, LinkViewContentProvider contentProvider, LinkView linkView) {
        assert (linkContentProvider != null);
        assert (contentProvider != null);
        assert (linkView != null);
        this.show = show;
        this.linkContentProvider = linkContentProvider;
        this.contentProvider = contentProvider;
        this.linkView = linkView;
        this.setText(linkContentProvider.getTypeName());
        this.setImageDescriptor(linkContentProvider.getIcon());
        this.setToolTipText(String.valueOf(Messages.getString("FilterForLinkTypeAction.filter_links_of_type")) + linkContentProvider.getTypeName());
        this.setShow(show);
    }

    public boolean getShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
        this.setChecked(show);
        if (!show) {
            this.contentProvider.filter(this.linkContentProvider);
        } else {
            this.contentProvider.unfilter(this.linkContentProvider);
        }
    }

    public String getLinkTypeName() {
        return this.linkContentProvider.getTypeName();
    }

    public void run() {
        if (!this.show) {
            this.contentProvider.unfilter(this.linkContentProvider);
            this.show = true;
        } else {
            this.contentProvider.filter(this.linkContentProvider);
            this.show = false;
        }
        this.linkView.showElements();
    }
}

