/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.element;

import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DetailsElementTable
extends DetailsElementList {
    private static final int MIN_COLUMN_WIDTH = 120;

    public DetailsElementTable(String label, DetailsValueTable detailsValue) {
        super(null, label, detailsValue);
    }

    @Override
    protected List<Control> createEntryWidgets(Composite parent, List<DetailsValue> detailsValues, IDetailsResourceProvider resourceProvider) {
        ArrayList<Control> entryWidgets = new ArrayList<Control>();
        int columnCount = 0;
        int[] columnMinWidths = null;
        boolean isFirstRow = true;
        for (DetailsValue detailsValue : detailsValues) {
            if (isFirstRow) {
                columnCount = detailsValue.getSubItemCount();
                columnMinWidths = new int[columnCount];
                GridLayout layout = new GridLayout(columnCount, false);
                layout.marginHeight = 0;
                layout.marginWidth = 5;
                layout.horizontalSpacing = 8;
                parent.setLayout((Layout)layout);
                int c = 0;
                while (c < detailsValue.getSubItemCount()) {
                    String headerEntryLabel;
                    DetailsValue headerEntrySpec = detailsValue.getSubItem(c);
                    String text = headerEntryLabel = headerEntrySpec.getDisplayText();
                    Font font = resourceProvider.getLabelFont();
                    StyledText headerEntryWidget = new StyledText(parent, 8);
                    headerEntryWidget.setText(text);
                    headerEntryWidget.setFont(font);
                    headerEntryWidget.setForeground(resourceProvider.getColour(4));
                    entryWidgets.add((Control)headerEntryWidget);
                    int widthLimit = headerEntrySpec.getParameter() != null && headerEntrySpec.getParameter() instanceof Integer && (Integer)headerEntrySpec.getParameter() > 0 ? (Integer)headerEntrySpec.getParameter() : 120;
                    columnMinWidths[c] = Math.max(FigureUtilities.getTextExtents((String)text, (Font)font).width, widthLimit);
                    ++c;
                }
                isFirstRow = false;
                continue;
            }
            int c = 0;
            while (c < columnCount) {
                DetailsValue entrySpec = detailsValue.getSubItem(c);
                Control entryWidget = entrySpec != null ? this.createSelectableEntryWidgetWithContextMenu(parent, entrySpec, columnMinWidths[c], resourceProvider) : this.createSelectableEntryWidgetWithContextMenu(parent, new DetailsValue("-", null, detailsValue.getForegroundType(), detailsValue.getBackgroundType(), null), columnMinWidths[c], resourceProvider);
                entryWidgets.add(entryWidget);
                ++c;
            }
        }
        return entryWidgets;
    }

    @Override
    protected boolean isLineShowingEqualValues(DetailsValue detailsValueForLine1, DetailsValue detailsValueForLine2) {
        if (detailsValueForLine1.getSubItemCount() != detailsValueForLine2.getSubItemCount()) {
            return false;
        }
        int index = 0;
        while (index < detailsValueForLine1.getSubItemCount()) {
            String label2;
            String label1 = detailsValueForLine1.getSubItem(index).getDisplayText();
            if (!label1.equals(label2 = detailsValueForLine2.getSubItem(index).getDisplayText())) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

