/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.AbstractPropertyGeneralWithCategorySelection;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.AttributeTextField;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderRoleValidator;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyRolesAndStakeholders;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleRW;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRoleAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralStakeholderRole
extends AbstractPropertyGeneralWithCategorySelection {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralStakeholderRole.class);
    private IStakeholderRole role;
    private RenameStakeholderRoleValidator nameValidator;
    private Image roleImage;
    private Collection<AttributeTextField> attributeFields;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;
    private Combo categoryCombo;
    private Collection<IModificationProblem> initialCategoryModificationProblems;

    @Override
    public IModificationProblem init_internal(ICockpitProjectData element, boolean forCreation) {
        this.role = (IStakeholderRole)element;
        this.nameValidator = new RenameStakeholderRoleValidator(this.projectAgent);
        return null;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        if (this.attributeFields != null) {
            for (AttributeTextField field : this.attributeFields) {
                problems.addAll(field.getModificationProblems());
            }
        }
        if (this.initialCategoryModificationProblems != null) {
            problems.addAll(this.initialCategoryModificationProblems);
        }
        return problems;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IStakeholderRoleRW;
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneralStakeholderRole.general");
    }

    @Override
    public Image getPropertyImage() {
        if (this.roleImage == null) {
            this.roleImage = Icons.getImageDescriptorForStakeholderRole().createImage();
        }
        return this.roleImage;
    }

    @Override
    public Composite getPropertyPage_internal(Composite parent) {
        AttributeTextField af;
        IPropertiesDialog dialog = this.getDialog();
        dialog.setTitle(String.valueOf(Messages.getString("PropertyGeneralStakeholderRole.role")) + this.role.getName(), this);
        dialog.setMessage(Messages.getString("PropertyGeneralStakeholderRole.view_and_admin"), 0, this);
        IWorkbenchHelpSystem helpSystem = dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        this.attributeFields = new ArrayList<AttributeTextField>();
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(base, 256);
        GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
        label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
        this.categoryCombo = new Combo(base, 12);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.categoryCombo);
        LineSeparator line = new LineSeparator(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)line);
        Label space = new Label(base, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)space);
        Label detailNameLabel = new Label(base, 0);
        detailNameLabel.setLayoutData((Object)new GridData());
        detailNameLabel.setText(Messages.getString("RolesAdminDialog.Name_10"));
        Text detailNameText = new Text(base, 2048);
        detailNameText.setLayoutData((Object)new GridData(768));
        try {
            af = new AttributeTextField((IAttributeOwner)this.role, this.role.getAttributeType(StakeholderRoleAttributeTypesProvider.ATTRID_NAME), detailNameText, dialog);
            this.attributeFields.add(af);
        }
        catch (ExInvalidAttributeType e1) {
            logger.error("could not execute", (Throwable)e1);
        }
        Label detailDescriptionLabel = new Label(base, 0);
        detailDescriptionLabel.setText(Messages.getString("RolesAdminDialog.Description_11"));
        detailDescriptionLabel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Text detailDescriptionText = new Text(base, 2562);
        GridData data = new GridData(1808);
        data.heightHint = 50;
        detailDescriptionText.setLayoutData((Object)data);
        af = new AttributeTextField((IAttributeOwner)this.role, this.role.getAttributeType(StakeholderRoleAttributeTypesProvider.ATTRID_DESCRIPTION), detailDescriptionText, dialog);
        this.attributeFields.add(af);
        this.nameValidator.setRole(this.role);
        this.setOriginalValues();
        if (this.role instanceof IStakeholderRoleRW) {
            this.initialCategoryModificationProblems = ((IStakeholderRoleRW)this.role).checkObjectTypeCategoryModificationPermission();
        }
        return base;
    }

    private void setOriginalValues() {
        for (AttributeTextField af : this.attributeFields) {
            af.reset();
        }
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
        }
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public boolean hasChanges() {
        for (AttributeTextField af : this.attributeFields) {
            if (!af.isModified()) continue;
            return true;
        }
        return this.isCategoryChanged();
    }

    public Collection<IModificationProblem> requestCommit() {
        Collection<IModificationProblem> modProblems = Collections.emptyList();
        if (this.role instanceof IStakeholderRoleRW) {
            IStakeholderRoleRW rw = (IStakeholderRoleRW)this.role;
            this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.newAttributes = new ArrayList<IAttribute>();
            for (AttributeTextField af : this.attributeFields) {
                if (!af.isModified()) continue;
                Attribute attribute = new Attribute(af.getAttributeTypeID(), af.getText());
                this.newAttributes.add(attribute);
                rw.requestAttributeModificationPermission(attribute, this.transactionController);
            }
            if (this.isCategoryChanged()) {
                rw.requestObjectTypeCategoryModificationPermission(this.transactionController);
            }
            modProblems = this.transactionController.execute();
        }
        return modProblems;
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.role instanceof IStakeholderRoleRW) {
            IStakeholderRoleRW rw = (IStakeholderRoleRW)this.role;
            if (this.newAttributes != null) {
                for (IAttribute attribute : this.newAttributes) {
                    try {
                        rw.setAttribute(attribute);
                    }
                    catch (EXNoPermission e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXNoLock e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                }
            }
            if (this.isCategoryChanged()) {
                try {
                    rw.setCategoryID(this.getSelectedCategoryID());
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (EXNoLock e) {
                    logger.error("could not execute", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        this.destroy();
    }

    private void destroy() {
        if (this.roleImage != null) {
            this.roleImage.dispose();
        }
        this.roleImage = null;
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    @Override
    protected Combo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Override
    protected ObjectTypeCategoryID getCategoryIDFromAttributeOwner() {
        return this.role.getCategoryID();
    }

    @Override
    protected boolean hasCategoryChangePermission() {
        if (this.initialCategoryModificationProblems != null) {
            return this.initialCategoryModificationProblems.isEmpty();
        }
        return false;
    }
}

