/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXInvalidValue;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.gui.ISWTControlModifiedListener;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.AddUserDefinedAttributeDialog;
import com.arcway.cockpit.frame.client.global.gui.dialogs.AddUserDefinedObjectTypesCategoryDialog;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ConvertUserDefinedAttributeDialog;
import com.arcway.cockpit.frame.client.global.gui.dialogs.IconChooserDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeCustomProperties;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeCustomPropertiesAdministrate;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.IObjectTypeCategoryModifier;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoriesManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeTypesModifier;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.CheckboxImages;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.viewers.ITableWithRowHeadingsLabelProvider;
import com.arcway.lib.eclipse.gui.viewers.TreeViewerWithVerticalHeaders;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.java.Equals;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.resource.URLResource;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyAdminUserDefinedAttributeTypesDataType
implements IPropertiesListEntry,
IAttributeTypesModifier,
IObjectTypeCategoryModifier {
    private static final ILogger logger = Logger.getLogger(PropertyAdminUserDefinedAttributeTypesDataType.class);
    private static final int CATEGORY_TABLE_COLUMN_WIDTH = 26;
    private static final int CATEGORY_TABLE_HEADER_WIDTH_AND_HEIGHT = 130;
    private static final int USER_SELECTABLE_ICON_SIZE = 16;
    private static final IStreamResource imageAdd = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/add_obj.gif"));
    private static final IStreamResource imageRemove = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/rem_obj.gif"));
    private final ICockpitDataType dataType;
    private IPropertiesDialog dialog;
    private IFrameProjectAgent projectAgent;
    private boolean mayModify = true;
    private Composite baseComposite;
    private TableViewer tableViewer;
    private StackLayout stackLayout;
    final MoveAttributeAction moveAttributeUpAction = new MoveAttributeAction(-1);
    final MoveAttributeAction moveAttributeDownAction = new MoveAttributeAction(1);
    final MoveCategoryAction moveCategoryUpAction = new MoveCategoryAction(-1);
    final MoveCategoryAction moveCategoryDownAction = new MoveCategoryAction(1);
    private IAttributeType shownType;
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private List<IAttributeType> allSavedUserDefinedAttributeTypes;
    private String highestUsedSortString;
    private final Collection<IAttributeType> attributeTypesToAdd = new ArrayList<IAttributeType>();
    private final Map<IAttributeTypeID, IAttributeType> attributeTypesToModify = new HashMap<IAttributeTypeID, IAttributeType>();
    private final Collection<IAttributeTypeID> attributeTypeIDsToDelete = new ArrayList<IAttributeTypeID>();
    private ILocksAndPermissionsTransactionController transactionController;
    private List<ObjectTypeCategory> allSavedCategories;
    private final List<ObjectTypeCategory> categoriesToAdd = new ArrayList<ObjectTypeCategory>();
    private final Map<ObjectTypeCategoryID, ObjectTypeCategory> categoriesToModify = new HashMap<ObjectTypeCategoryID, ObjectTypeCategory>();
    private final Collection<ObjectTypeCategory> categoriesToDelete = new ArrayList<ObjectTypeCategory>();
    private int highestCategorySortingPosition = -1;
    private TreeViewerWithVerticalHeaders objectTypesCategoryTable;
    private final List<IAttributeTypeID> objectTypesCategoryTableColumnHeaders = new ArrayList<IAttributeTypeID>();
    private Button btnDeleteCategory;
    private Button btnRemoveIcon;
    private Group categoryDetailsGroup;
    private Image iconForIconLabel;
    private final List<FileID> temporaryImages = new ArrayList<FileID>();

    public PropertyAdminUserDefinedAttributeTypesDataType(ICockpitDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IFrameProjectAgent;
        }
        return false;
    }

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.setDialog(newDialog);
        this.allSavedUserDefinedAttributeTypes = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(this.dataType.getCockpitDataTypeID());
        this.highestUsedSortString = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getHighestUsedSortString(this.dataType.getCockpitDataTypeID());
        this.allSavedCategories = this.projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.dataType.getCockpitDataTypeID());
        if (!this.allSavedCategories.isEmpty()) {
            this.highestCategorySortingPosition = this.allSavedCategories.get(this.allSavedCategories.size() - 1).getSortPosition();
        }
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(dialog.getProjectUID());
    }

    @Override
    public String getPropertyName() {
        return this.dataType.getDisplayName();
    }

    @Override
    public Image getPropertyImage() {
        return this.dataType.getIcon();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        StructuredSelection sel;
        Object firstEntry;
        IModificationProblem modProblem;
        this.modificationProblems.clear();
        this.attributeTypesToAdd.clear();
        this.attributeTypeIDsToDelete.clear();
        this.attributeTypesToModify.clear();
        this.categoriesToAdd.clear();
        this.categoriesToDelete.clear();
        this.categoriesToModify.clear();
        this.temporaryImages.clear();
        this.shownType = null;
        this.dialog.setTitle(String.valueOf(Messages.getString("PropertyAdminUserDefinedAttributeTypes.custom_properties_for_datatype")) + this.dataType.getDisplayName(), this);
        this.setDialogMessage(null, 0);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        if ((modProblem = this.projectAgent.getFrameUserDefinedAttributeTypesManager().checkAttributeTypesModificationPermission(this.dataType)) != null) {
            this.mayModify = false;
            this.modificationProblems.add(modProblem);
        } else {
            this.mayModify = true;
        }
        if (!this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed(ClientFunctionLicenseTypeCustomPropertiesAdministrate.getInstance())) {
            this.modificationProblems.add(new ModificationProblem(ClientFunctionLicenseTypeCustomPropertiesAdministrate.getInstance(), Messages.getString("PropertyAdminUserDefinedAttributeTypesDataType.custom_props_cannot_be_mod")));
            this.mayModify = false;
        }
        this.baseComposite = new Composite(parent, 0);
        this.baseComposite.setLayout((Layout)new FillLayout());
        this.baseComposite.setLayoutData((Object)new GridData(1808));
        TabFolder tabFolder = new TabFolder(this.baseComposite, 0);
        this.createAttributeTabItem(tabFolder);
        if (this.dataType.isSupportingCategories()) {
            this.createCategoryTabItem(tabFolder);
        }
        if ((firstEntry = this.tableViewer.getElementAt(0)) != null) {
            sel = new StructuredSelection(firstEntry);
            this.tableViewer.setSelection((ISelection)sel);
        }
        if (this.allSavedCategories.size() > 0 && this.objectTypesCategoryTable != null) {
            sel = new StructuredSelection((Object)this.allSavedCategories.get(0));
            this.objectTypesCategoryTable.setSelection((ISelection)sel);
        }
        return this.baseComposite;
    }

    private void createAttributeTabItem(TabFolder tabFolder) {
        TabItem propertiesTabItem = new TabItem(tabFolder, 0);
        propertiesTabItem.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Property.TabTitle"));
        Composite propertiesComposite = new Composite((Composite)tabFolder, 0);
        propertiesComposite.setLayoutData((Object)new GridData(1808));
        propertiesComposite.setLayout((Layout)new GridLayout(2, false));
        propertiesTabItem.setControl((Control)propertiesComposite);
        Group left = new Group(propertiesComposite, 0);
        left.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.allProperties"));
        GridData gridData = new GridData(1040);
        left.setLayoutData((Object)gridData);
        left.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = this.createTableViewerForAttributes((Composite)left);
        Composite buttons = new Composite((Composite)left, 0);
        buttons.setLayoutData((Object)new GridData(16384, 128, false, false));
        buttons.setLayout((Layout)new GridLayout());
        Button btnAddProperty = new Button(buttons, 0);
        btnAddProperty.setLayoutData((Object)new GridData());
        btnAddProperty.setImage(ImageCache.getImage((Display)this.baseComposite.getDisplay(), (IStreamResource)imageAdd));
        btnAddProperty.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.define_new"));
        btnAddProperty.setEnabled(this.mayModify);
        final Button btnDeleteProperty = new Button(buttons, 0);
        btnDeleteProperty.setLayoutData((Object)new GridData());
        btnDeleteProperty.setImage(ImageCache.getImage((Display)this.baseComposite.getDisplay(), (IStreamResource)imageRemove));
        btnDeleteProperty.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.delete_tooltip"));
        btnDeleteProperty.setEnabled(false);
        new Label(buttons, 0);
        ActionContributionItem up = new ActionContributionItem((IAction)this.moveAttributeUpAction);
        up.fill(buttons);
        ActionContributionItem down = new ActionContributionItem((IAction)this.moveAttributeDownAction);
        down.fill(buttons);
        this.moveAttributeUpAction.update();
        this.moveAttributeDownAction.update();
        final Group right = new Group(propertiesComposite, 0);
        right.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        right.setLayout((Layout)this.stackLayout);
        right.setVisible(false);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                ISelection selection = PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1) {
                    IAttributeType selectedType = (IAttributeType)sel.getFirstElement();
                    if (!selectedType.equals(PropertyAdminUserDefinedAttributeTypesDataType.this.shownType)) {
                        PropertyAdminUserDefinedAttributeTypesDataType.this.shownType = selectedType;
                        if (((PropertyAdminUserDefinedAttributeTypesDataType)PropertyAdminUserDefinedAttributeTypesDataType.this).stackLayout.topControl != null) {
                            ((PropertyAdminUserDefinedAttributeTypesDataType)PropertyAdminUserDefinedAttributeTypesDataType.this).stackLayout.topControl.dispose();
                        }
                        ((PropertyAdminUserDefinedAttributeTypesDataType)PropertyAdminUserDefinedAttributeTypesDataType.this).stackLayout.topControl = PropertyAdminUserDefinedAttributeTypesDataType.this.createPropertyContainerForAttribute(selectedType, (Composite)right);
                        right.setVisible(true);
                        right.setText(NLS.bind((String)Messages.getString("PropertyAdminUserDefinedAttributeTypes.details"), (Object)selectedType.getDisplayName()));
                        right.layout();
                    }
                    btnDeleteProperty.setEnabled(PropertyAdminUserDefinedAttributeTypesDataType.this.mayModify);
                }
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveAttributeUpAction.update();
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveAttributeDownAction.update();
            }
        });
        btnAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSortString = AttributeTypeSortCriterium.computeUsefulNextSortString(PropertyAdminUserDefinedAttributeTypesDataType.this.highestUsedSortString);
                PropertyAdminUserDefinedAttributeTypesDataType.this.highestUsedSortString = newSortString;
                AttributeTypeSortCriterium sortCriterium = new AttributeTypeSortCriterium(IAttributeTypeSortCriterium.CATEGORY_USERDEFINED_ATTRIBUTE, newSortString);
                AddUserDefinedAttributeDialog addDialog = new AddUserDefinedAttributeDialog(PropertyAdminUserDefinedAttributeTypesDataType.this.dialog.getShell(), PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent, PropertyAdminUserDefinedAttributeTypesDataType.this.dataType, sortCriterium, PropertyAdminUserDefinedAttributeTypesDataType.this);
                addDialog.open();
                IAttributeType newType = addDialog.getAttributeType();
                if (newType != null) {
                    PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToAdd.add(newType);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.refresh();
                    StructuredSelection sel = new StructuredSelection((Object)newType);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.setSelection((ISelection)sel);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.recreateTableForCategories();
                }
            }
        });
        btnDeleteProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                IStructuredSelection sel = (IStructuredSelection)PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.getSelection();
                if (sel.size() == 1 && (o = sel.getFirstElement()) instanceof IAttributeType) {
                    IAttributeType attributeType = (IAttributeType)o;
                    if (PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToAdd.contains(attributeType)) {
                        PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToAdd.remove(attributeType);
                    } else {
                        if (PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToModify.containsKey(attributeType.getAttributeTypeID())) {
                            PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToModify.remove(attributeType.getAttributeTypeID());
                        }
                        PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypeIDsToDelete.add(attributeType.getAttributeTypeID());
                    }
                    for (ObjectTypeCategory category : PropertyAdminUserDefinedAttributeTypesDataType.this.getCurrentListOfCategories(false)) {
                        if (!category.getAttributeList().contains(attributeType.getAttributeTypeID())) continue;
                        PropertyAdminUserDefinedAttributeTypesDataType.this.modifyCategory(category).getAttributeList().remove(attributeType.getAttributeTypeID());
                    }
                    btnDeleteProperty.setEnabled(false);
                    right.setVisible(false);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.refresh();
                    PropertyAdminUserDefinedAttributeTypesDataType.this.recreateTableForCategories();
                }
            }
        });
    }

    private void createCategoryTabItem(TabFolder tabFolder) {
        TabItem categoriesTabItem = new TabItem(tabFolder, 0);
        categoriesTabItem.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.TabTitle"));
        Composite categoriesComposite = new Composite((Composite)tabFolder, 0);
        categoriesComposite.setLayoutData((Object)new GridData(1808));
        categoriesComposite.setLayout((Layout)new GridLayout(2, false));
        categoriesTabItem.setControl((Control)categoriesComposite);
        Composite left = new Composite(categoriesComposite, 0);
        left.setLayoutData((Object)new GridData(4, 4, true, true));
        left.setLayout((Layout)new GridLayout(1, false));
        Composite right = new Composite(categoriesComposite, 0);
        right.setLayoutData((Object)new GridData(4, 4, false, true));
        right.setLayout((Layout)new GridLayout(1, false));
        Composite tableComposite = new Composite(left, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new FillLayout());
        this.createTableViewerForCategories(tableComposite);
        this.objectTypesCategoryTable.setInput(new Object());
        this.categoryDetailsGroup = new Group(left, 0);
        this.categoryDetailsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this.categoryDetailsGroup.setVisible(false);
        this.categoryDetailsGroup.setLayout((Layout)new FillLayout());
        this.createPropertyContainerForCategory(null, (Composite)this.categoryDetailsGroup);
        Button btnAddCategory = new Button(right, 0);
        btnAddCategory.setLayoutData((Object)new GridData());
        btnAddCategory.setImage(ImageCache.getImage((Display)this.baseComposite.getDisplay(), (IStreamResource)imageAdd));
        btnAddCategory.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Add.Tooltip"));
        btnAddCategory.setEnabled(this.mayModify);
        btnAddCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddUserDefinedObjectTypesCategoryDialog addDialog = new AddUserDefinedObjectTypesCategoryDialog(PropertyAdminUserDefinedAttributeTypesDataType.this.dialog.getShell(), PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent, PropertyAdminUserDefinedAttributeTypesDataType.this.dataType, PropertyAdminUserDefinedAttributeTypesDataType.this.highestCategorySortingPosition + 1, PropertyAdminUserDefinedAttributeTypesDataType.this);
                addDialog.open();
                ObjectTypeCategory newCategory = addDialog.getObjectTypesCategory();
                if (newCategory != null) {
                    PropertyAdminUserDefinedAttributeTypesDataType.this.highestCategorySortingPosition = newCategory.getSortPosition();
                    PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToAdd.add(newCategory);
                    if (newCategory.getIcon() != null && !Equals.equals((Object)newCategory.getIcon(), (Object)FileID.NO_FILE)) {
                        PropertyAdminUserDefinedAttributeTypesDataType.this.temporaryImages.add(newCategory.getIcon());
                    }
                    PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.refresh();
                    StructuredSelection sel = new StructuredSelection((Object)newCategory);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.setSelection((ISelection)sel, true);
                }
            }
        });
        this.btnDeleteCategory = new Button(right, 0);
        this.btnDeleteCategory.setLayoutData((Object)new GridData());
        this.btnDeleteCategory.setImage(ImageCache.getImage((Display)this.baseComposite.getDisplay(), (IStreamResource)imageRemove));
        this.btnDeleteCategory.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Delete.Tooltip"));
        this.btnDeleteCategory.setEnabled(false);
        this.btnDeleteCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                IStructuredSelection sel = (IStructuredSelection)PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.getSelection();
                if (sel.size() == 1 && (o = sel.getFirstElement()) instanceof ObjectTypeCategory) {
                    ObjectTypeCategory objectTypeCategoryRequestedToDelete = (ObjectTypeCategory)o;
                    List<IAttributeOwner> usedBy = PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getObjectTypeCategoriesManager().getAllAttributeOwnerUsingCategory(objectTypeCategoryRequestedToDelete);
                    if (usedBy.isEmpty()) {
                        if (!PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToAdd.remove(objectTypeCategoryRequestedToDelete)) {
                            if (PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToModify.remove(objectTypeCategoryRequestedToDelete.getObjectTypeCategoryID()) != null) {
                                for (ObjectTypeCategory savedCategory : PropertyAdminUserDefinedAttributeTypesDataType.this.allSavedCategories) {
                                    if (!savedCategory.getObjectTypeCategoryID().equals((Object)objectTypeCategoryRequestedToDelete.getObjectTypeCategoryID())) continue;
                                    PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToDelete.add(savedCategory);
                                    break;
                                }
                            } else {
                                PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToDelete.add(objectTypeCategoryRequestedToDelete);
                            }
                        }
                        PropertyAdminUserDefinedAttributeTypesDataType.this.btnDeleteCategory.setEnabled(false);
                        PropertyAdminUserDefinedAttributeTypesDataType.this.categoryDetailsGroup.setVisible(false);
                        int sortpos = objectTypeCategoryRequestedToDelete.getSortPosition();
                        for (ObjectTypeCategory category : PropertyAdminUserDefinedAttributeTypesDataType.this.getCurrentListOfCategories(false)) {
                            if (category.getSortPosition() <= sortpos) continue;
                            ObjectTypeCategory modifyableCategory = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyCategory(category);
                            modifyableCategory.setSortPosition(modifyableCategory.getSortPosition() - 1);
                        }
                        PropertyAdminUserDefinedAttributeTypesDataType propertyAdminUserDefinedAttributeTypesDataType = PropertyAdminUserDefinedAttributeTypesDataType.this;
                        propertyAdminUserDefinedAttributeTypesDataType.highestCategorySortingPosition = propertyAdminUserDefinedAttributeTypesDataType.highestCategorySortingPosition - 1;
                        PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.refresh();
                        PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.layout();
                    } else {
                        IDataLabelProvider dataLabelProvider = PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getDataManager(PropertyAdminUserDefinedAttributeTypesDataType.this.dataType.getCockpitDataTypeID()).getDataLabelProvider();
                        Object[] namesArray = new String[usedBy.size()];
                        int i = 0;
                        for (IAttributeOwner ao : usedBy) {
                            namesArray[i++] = dataLabelProvider.getText((Object)ao);
                        }
                        Arrays.sort(namesArray);
                        String namesString = StringUtil.concatWithLineBreaks((String[])namesArray, (boolean)false);
                        Set<ModificationProblem> message = Collections.singleton(new ModificationProblem(NLS.bind((String)Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.DeletionAborted.Cause"), (Object)dataLabelProvider.getTypeDisplayName(PropertyAdminUserDefinedAttributeTypesDataType.this.dataType.getCockpitDataTypeID()), (Object)namesString), NLS.bind((String)Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.DeletionAborted.Consequence"), (Object)objectTypeCategoryRequestedToDelete.getDisplayName())));
                        ModificationProblemsDialog modProbDialog = new ModificationProblemsDialog(message, PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.getShell());
                        modProbDialog.open();
                    }
                }
            }
        });
        new Label(right, 0);
        ActionContributionItem up = new ActionContributionItem((IAction)this.moveCategoryUpAction);
        ActionContributionItem down = new ActionContributionItem((IAction)this.moveCategoryDownAction);
        up.fill(right);
        down.fill(right);
        this.moveCategoryUpAction.update();
        this.moveCategoryDownAction.update();
    }

    private TableViewer createTableViewerForAttributes(Composite parent) {
        Table tblProperties = new Table(parent, 2052);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 200;
        tblProperties.setLayoutData((Object)gd);
        TableViewer viewer = new TableViewer(tblProperties);
        viewer.setContentProvider((IContentProvider)new ContentProviderForAttributes());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderForAttributes());
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer v, Object e1, Object e2) {
                IAttributeType t1 = (IAttributeType)e1;
                IAttributeType t2 = (IAttributeType)e2;
                int result = t1.getSortCriterium().compareTo((Object)t2.getSortCriterium());
                return result;
            }
        });
        viewer.setInput((Object)"start");
        MenuManager menuManager = new MenuManager();
        viewer.getTable().setMenu(menuManager.createContextMenu((Control)viewer.getTable()));
        menuManager.add((IAction)this.moveAttributeUpAction);
        menuManager.add((IAction)this.moveAttributeDownAction);
        return viewer;
    }

    private void createTableViewerForCategories(Composite tableComposite) {
        if (!this.dataType.isSupportingCategories()) {
            return;
        }
        this.objectTypesCategoryTableColumnHeaders.clear();
        this.objectTypesCategoryTable = new TreeViewerWithVerticalHeaders(tableComposite, 130, 130, Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Assignment"), 768);
        List<IAttributeType> allAttributes = this.getCurrentListOfAttributes();
        Collections.sort(allAttributes, new Comparator<IAttributeType>(){

            @Override
            public int compare(IAttributeType o1, IAttributeType o2) {
                return o1.getSortCriterium().compareTo((Object)o2.getSortCriterium());
            }
        });
        CellEditor[] cellEditors = new CellEditor[allAttributes.size() + 2];
        String[] columnProperties = new String[allAttributes.size() + 2];
        this.objectTypesCategoryTable.addColumn(null, 0, false, 0);
        this.objectTypesCategoryTableColumnHeaders.add(null);
        cellEditors[0] = null;
        columnProperties[0] = "";
        int i = 0;
        i = 0;
        while (i < allAttributes.size()) {
            IAttributeType attr = allAttributes.get(i);
            this.objectTypesCategoryTable.addColumn(attr.getDisplayName(), 26, false, 131072);
            this.objectTypesCategoryTableColumnHeaders.add(attr.getAttributeTypeID());
            cellEditors[i + 1] = new CheckboxCellEditor(this.objectTypesCategoryTable.getTreeCompositeForCellEditors());
            columnProperties[i + 1] = attr.getAttributeTypeID().getUID();
            ++i;
        }
        this.objectTypesCategoryTable.addColumn(null, 1, false, 0);
        this.objectTypesCategoryTableColumnHeaders.add(null);
        cellEditors[i + 1] = null;
        columnProperties[i + 1] = "";
        this.objectTypesCategoryTable.setCellEditors(cellEditors);
        this.objectTypesCategoryTable.setColumnProperties(columnProperties);
        this.objectTypesCategoryTable.setLabelProvider((ITableLabelProvider)new LabelProviderForCategories());
        this.objectTypesCategoryTable.setContentProvider((IContentProvider)new ContentProviderForCategories());
        if (this.mayModify) {
            this.objectTypesCategoryTable.setCellModifier(new ICellModifier(){

                public void modify(Object element, String property, Object value) {
                    TableItem tableItem = (TableItem)element;
                    if (tableItem.getData() instanceof ObjectTypeCategory) {
                        ObjectTypeCategory categoryFromTable = (ObjectTypeCategory)tableItem.getData();
                        ObjectTypeCategory modifyableCategory = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyCategory(categoryFromTable);
                        boolean attributeIncludedInCategory = (Boolean)value;
                        for (IAttributeType attr : PropertyAdminUserDefinedAttributeTypesDataType.this.getCurrentListOfAttributes()) {
                            if (!attr.getAttributeTypeID().getUID().equals(property)) continue;
                            HashSet<IAttributeTypeID> newSet = new HashSet<IAttributeTypeID>(modifyableCategory.getAttributeList());
                            if (attributeIncludedInCategory) {
                                newSet.add(attr.getAttributeTypeID());
                            } else {
                                newSet.remove(attr.getAttributeTypeID());
                            }
                            modifyableCategory.setAttributeList(newSet);
                            break;
                        }
                        PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.refresh();
                    }
                }

                public Object getValue(Object element, String property) {
                    if (element instanceof ObjectTypeCategory) {
                        ObjectTypeCategory categoryFromTable = (ObjectTypeCategory)element;
                        for (IAttributeTypeID attrId : categoryFromTable.getAttributeList()) {
                            if (!attrId.getUID().equals(property)) continue;
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                    return null;
                }

                public boolean canModify(Object element, String property) {
                    return element instanceof ObjectTypeCategory;
                }
            });
        }
        this.objectTypesCategoryTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.getSelection();
                boolean categorySelected = selection.getFirstElement() instanceof ObjectTypeCategory;
                PropertyAdminUserDefinedAttributeTypesDataType.this.btnDeleteCategory.setEnabled(PropertyAdminUserDefinedAttributeTypesDataType.this.mayModify && categorySelected);
                PropertyAdminUserDefinedAttributeTypesDataType.this.categoryDetailsGroup.setVisible(categorySelected);
                if (categorySelected) {
                    ObjectTypeCategory selectedCategory = (ObjectTypeCategory)selection.getFirstElement();
                    PropertyAdminUserDefinedAttributeTypesDataType.this.categoryDetailsGroup.setText(NLS.bind((String)Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.Title"), (Object)selectedCategory.getDisplayName()));
                    Control[] controlArray = PropertyAdminUserDefinedAttributeTypesDataType.this.categoryDetailsGroup.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        if (c != null && !c.isDisposed()) {
                            c.dispose();
                        }
                        ++n2;
                    }
                    PropertyAdminUserDefinedAttributeTypesDataType.this.createPropertyContainerForCategory(selectedCategory, (Composite)PropertyAdminUserDefinedAttributeTypesDataType.this.categoryDetailsGroup);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.categoryDetailsGroup.layout();
                }
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveCategoryUpAction.update();
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveCategoryDownAction.update();
            }
        });
    }

    private void recreateTableForCategories() {
        if (this.dataType.isSupportingCategories()) {
            Composite parent = this.objectTypesCategoryTable.getControl().getParent();
            ISelection selection = this.objectTypesCategoryTable.getSelection();
            this.objectTypesCategoryTable.getControl().dispose();
            this.createTableViewerForCategories(parent);
            parent.layout();
            this.objectTypesCategoryTable.setInput(new Object());
            this.objectTypesCategoryTable.setSelection(selection);
        }
    }

    private Control createPropertyContainerForAttribute(final IAttributeType type, Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        base.setLayout((Layout)layout);
        IAttributeType attributeType = type;
        if (this.attributeTypesToModify.containsKey(type.getAttributeTypeID())) {
            attributeType = this.attributeTypesToModify.get(type.getAttributeTypeID());
        }
        final IAttributeType attributeType_final = attributeType;
        final Text txtID = PropertyAdminUserDefinedAttributeTypesDataType.addRow(base, Messages.getString("AttributeTypesRowSetForDialog.ID"), attributeType_final.getHumanReadableID(), false, 1);
        final ObjectWrapper textModifiedWhileFocused = new ObjectWrapper((Object)Boolean.FALSE);
        final Text txtDisplayName = PropertyAdminUserDefinedAttributeTypesDataType.addRow(base, Messages.getString("AttributeTypesRowSetForDialog.display_name_field"), attributeType_final.getDisplayName(), true, 1);
        txtDisplayName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeType attrType = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyAttribute(attributeType_final);
                String newName = txtDisplayName.getText();
                attrType.setDisplayName(newName);
                String msg = PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFrameUserDefinedAttributeTypesManager().isValidIdOrDisplayName(newName, false, (IAttributeTypesModifier)PropertyAdminUserDefinedAttributeTypesDataType.this, type);
                PropertyAdminUserDefinedAttributeTypesDataType.this.setDialogMessage(msg, 3);
                PropertyAdminUserDefinedAttributeTypesDataType.this.dialog.setIsCommitable(msg == null, PropertyAdminUserDefinedAttributeTypesDataType.this);
                PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.refresh();
                textModifiedWhileFocused.setWrappedObject((Object)Boolean.TRUE);
            }
        });
        if (this.dataType.isSupportingCategories()) {
            txtDisplayName.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (((Boolean)textModifiedWhileFocused.getWrappedObject()).booleanValue()) {
                        PropertyAdminUserDefinedAttributeTypesDataType.this.recreateTableForCategories();
                    }
                    textModifiedWhileFocused.setWrappedObject((Object)Boolean.FALSE);
                }
            });
        }
        txtDisplayName.setEditable(this.mayModify);
        PropertyAdminUserDefinedAttributeTypesDataType.addRow(base, Messages.getString("AttributeTypesRowSetForDialog.data_type_field"), attributeType_final.getDataType().getDisplayName(), false, 1);
        final IValueRangeDefiner valueRangeHelper = attributeType_final.getDataType().getValueRangeHelper();
        if (valueRangeHelper != null) {
            Label label = new Label(base, 0);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 128;
            label.setLayoutData((Object)gridData);
            label.setText(Messages.getString("AttributeTypesRowSetForDialog.default_value_field"));
            final Control control = valueRangeHelper.createSWTControl(base, 250, valueRangeHelper.getValueDeletionPolicyForOnlyIfNotInUse((IProjectAgent)this.projectAgent, attributeType_final));
            IValueRange valueRange = attributeType_final.getValueRange();
            valueRangeHelper.setContentForSWTControl(control, valueRange);
            control.setEnabled(this.mayModify);
            valueRangeHelper.addSWTControlModifiedListener(control, new ISWTControlModifiedListener(){

                public void modified(Object newValue, Object additionalInfo) {
                    try {
                        IValueRange vr = valueRangeHelper.getValueRangeFromSWTControl(control);
                        AttributeType attrType = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyAttribute(attributeType_final);
                        attrType.setValueRange(vr);
                    }
                    catch (ExInvalidDataType e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                }

                public void setModificationInProgress(boolean modificationInProgress) {
                }
            });
        }
        String helpContextID = "com.arcway.cockpit.frame.help.properties_dialog";
        if (type.isMigratedFromFixedAttribute()) {
            helpContextID = "com.arcway.cockpit.frame.help.fixed_custom_properties";
            Label dummy = new Label(base, 0);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            dummy.setLayoutData((Object)gridData);
            dummy = new Label(base, 0);
            gridData = new GridData();
            dummy.setLayoutData((Object)gridData);
            Button convertBtn = new Button(base, 0);
            convertBtn.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.convert_button_text"));
            convertBtn.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.convert_button_tooltip"));
            gridData = new GridData();
            convertBtn.setLayoutData((Object)gridData);
            convertBtn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IAttributeType typeToConvert = type;
                    if (PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToModify.containsKey(type.getAttributeTypeID())) {
                        typeToConvert = (IAttributeType)PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToModify.get(type.getAttributeTypeID());
                    }
                    AttributeType playground = new AttributeType(typeToConvert);
                    ConvertUserDefinedAttributeDialog convertDialog = new ConvertUserDefinedAttributeDialog(PropertyAdminUserDefinedAttributeTypesDataType.this.dialog.getShell(), PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent, playground, PropertyAdminUserDefinedAttributeTypesDataType.this);
                    if (convertDialog.open() == 0) {
                        IAttributeType modifiedType = convertDialog.getAttributeType();
                        PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToModify.put(modifiedType.getAttributeTypeID(), modifiedType);
                        txtID.setText(modifiedType.getHumanReadableID());
                        txtDisplayName.setText(modifiedType.getDisplayName());
                        PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.refresh();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            dummy = new Label(base, 0);
            gridData = new GridData();
            dummy.setLayoutData((Object)gridData);
            Text convertMsgTxt = new Text(base, 66);
            convertMsgTxt.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.convert_message_text"));
            convertMsgTxt.setEditable(false);
            gridData = new GridData(4);
            gridData.grabExcessHorizontalSpace = true;
            convertMsgTxt.setLayoutData((Object)gridData);
        }
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp(helpContextID);
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), helpContextID);
            }
        }
        return base;
    }

    private void createPropertyContainerForCategory(ObjectTypeCategory category, Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        base.setLayout((Layout)layout);
        ObjectTypeCategory tmpCategory = category;
        if (category != null && this.categoriesToModify.containsKey(category.getObjectTypeCategoryID())) {
            tmpCategory = this.categoriesToModify.get(category.getObjectTypeCategoryID());
        }
        final ObjectTypeCategory objectTypesCategory_final = tmpCategory;
        String humanReadableId = "";
        if (objectTypesCategory_final != null) {
            humanReadableId = objectTypesCategory_final.getHumanReadableID();
        }
        PropertyAdminUserDefinedAttributeTypesDataType.addRow(base, Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.ID"), humanReadableId, false, 3);
        String displayName = "";
        if (objectTypesCategory_final != null) {
            displayName = objectTypesCategory_final.getDisplayName();
        }
        final Text txtDisplayName = PropertyAdminUserDefinedAttributeTypesDataType.addRow(base, Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.DisplayName"), displayName, true, 3);
        if (objectTypesCategory_final != null) {
            txtDisplayName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newName = txtDisplayName.getText();
                    ObjectTypeCategory modifyableCategory = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyCategory(objectTypesCategory_final);
                    modifyableCategory.setDisplayName(newName);
                    String msg = PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getObjectTypeCategoriesManager().isValidIdOrDisplayName(newName, false, (IObjectTypeCategoryModifier)PropertyAdminUserDefinedAttributeTypesDataType.this, objectTypesCategory_final);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.setDialogMessage(msg, 3);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.dialog.setIsCommitable(msg == null, PropertyAdminUserDefinedAttributeTypesDataType.this);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.refresh();
                }
            });
            txtDisplayName.setEditable(this.mayModify);
        }
        Label label = new Label(base, 0);
        label.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.Icon"));
        final Label iconLabel = new Label(base, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        iconLabel.setLayoutData((Object)gridData);
        if (this.iconForIconLabel != null) {
            this.iconForIconLabel.dispose();
        }
        if (objectTypesCategory_final != null && objectTypesCategory_final.getIcon() != null && !objectTypesCategory_final.getIcon().equals(FileID.NO_FILE)) {
            ImageData iconData = this.projectAgent.getFilesManager().getImageFromFile(objectTypesCategory_final.getIcon(), "Error while retrieving icon file for category from FilesManager");
            if (iconData != null) {
                this.iconForIconLabel = new Image((Device)this.baseComposite.getDisplay(), iconData);
                iconLabel.setImage(this.iconForIconLabel);
            } else {
                logger.error("Icon file from category is missing unexpectedly (name=" + objectTypesCategory_final.getDisplayName() + ", " + "id=" + objectTypesCategory_final.getUID() + ", " + "dataTypId=" + objectTypesCategory_final.getCockpitDataTypeID() + ")");
                iconLabel.setImage(ImageCache.getImage((Display)this.baseComposite.getDisplay(), (IStreamResource)Icons16x16.EMPTY));
            }
        }
        Button btnChooseIcon = new Button(base, 0);
        btnChooseIcon.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.ChooseIcon.Text"));
        btnChooseIcon.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.ChooseIcon.ToolTip"));
        btnChooseIcon.setEnabled(this.mayModify);
        btnChooseIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStreamResource iconStreamResource = IconChooserDialog.selectIcon(PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.getShell(), 16);
                if (iconStreamResource != null) {
                    ObjectTypeCategory categoryToModify = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyCategory(objectTypesCategory_final);
                    if (PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel != null) {
                        iconLabel.setImage(null);
                        PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel.dispose();
                        PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel = null;
                    }
                    try {
                        PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel = new Image((Device)PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.getDisplay(), iconStreamResource.toInputStream());
                        iconLabel.setImage(PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel);
                    }
                    catch (JvmExternalResourceInteractionException e1) {
                        logger.error("Error while displaying icon", (Throwable)e1);
                    }
                    try {
                        FileID newIconFile = PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFilesManager().loadFileIntoTemporaryStorage(iconStreamResource);
                        categoryToModify.setIcon(newIconFile);
                        PropertyAdminUserDefinedAttributeTypesDataType.this.temporaryImages.add(newIconFile);
                        PropertyAdminUserDefinedAttributeTypesDataType.this.btnRemoveIcon.setEnabled(PropertyAdminUserDefinedAttributeTypesDataType.this.mayModify);
                        PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.refresh();
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        logger.error("Could not load file for the category icon into temporary storage", (Throwable)e);
                    }
                }
            }
        });
        this.btnRemoveIcon = new Button(base, 0);
        this.btnRemoveIcon.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.RemoveIcon.Text"));
        this.btnRemoveIcon.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Group.RemoveIcon.ToolTip"));
        this.btnRemoveIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ObjectTypeCategory categoryToModify = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyCategory(objectTypesCategory_final);
                if (PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel != null) {
                    iconLabel.setImage(null);
                    PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel.dispose();
                    PropertyAdminUserDefinedAttributeTypesDataType.this.iconForIconLabel = null;
                }
                categoryToModify.setIcon(FileID.NO_FILE);
                PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.refresh();
                PropertyAdminUserDefinedAttributeTypesDataType.this.btnRemoveIcon.setEnabled(false);
            }
        });
        this.btnRemoveIcon.setEnabled(this.mayModify && objectTypesCategory_final != null && objectTypesCategory_final.getIcon() != null && !objectTypesCategory_final.getIcon().equals(FileID.NO_FILE));
    }

    private static Text addRow(Composite base, String labelText, String textText, boolean editable, int textFieldColumnSpan) {
        Label label = new Label(base, 0);
        label.setText(labelText);
        Text text = new Text(base, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = textFieldColumnSpan;
        text.setLayoutData((Object)gd);
        text.setEditable(editable);
        text.setText(textText);
        return text;
    }

    private AttributeType modifyAttribute(IAttributeType typeToModify) {
        if (!this.attributeTypesToAdd.contains(typeToModify)) {
            if (!this.attributeTypesToModify.containsKey(typeToModify.getAttributeTypeID())) {
                AttributeType type = new AttributeType(typeToModify);
                this.attributeTypesToModify.put(type.getAttributeTypeID(), type);
            }
            return (AttributeType)this.attributeTypesToModify.get(typeToModify.getAttributeTypeID());
        }
        return (AttributeType)typeToModify;
    }

    private ObjectTypeCategory modifyCategory(ObjectTypeCategory categoryToModify) {
        ObjectTypeCategory categoryWhichCanBeModified;
        if (this.categoriesToAdd.contains(categoryToModify)) {
            categoryWhichCanBeModified = categoryToModify;
        } else {
            categoryWhichCanBeModified = this.categoriesToModify.get(categoryToModify.getObjectTypeCategoryID());
            if (categoryWhichCanBeModified == null) {
                categoryWhichCanBeModified = new ObjectTypeCategory(categoryToModify);
                this.categoriesToModify.put(categoryToModify.getObjectTypeCategoryID(), categoryWhichCanBeModified);
                this.objectTypesCategoryTable.refresh();
            }
        }
        return categoryWhichCanBeModified;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return !this.attributeTypesToAdd.isEmpty() || !this.attributeTypesToModify.isEmpty() || !this.attributeTypeIDsToDelete.isEmpty() || !this.categoriesToAdd.isEmpty() || !this.categoriesToModify.isEmpty() || !this.categoriesToDelete.isEmpty();
    }

    public Collection<IModificationProblem> requestCommit() {
        boolean allSaved;
        IFrameUserDefinedAttributeTypesManager typeManagerAttribute = this.projectAgent.getFrameUserDefinedAttributeTypesManager();
        ObjectTypeCategoriesManager typeManagerCategory = this.projectAgent.getObjectTypeCategoriesManager();
        this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        boolean change = false;
        for (IAttributeType type : this.attributeTypesToAdd) {
            typeManagerAttribute.requestAddAttributeTypePermissions(type, this.transactionController, this);
            change = true;
        }
        for (IAttributeType attributeType : this.attributeTypesToModify.values()) {
            typeManagerAttribute.requestModifyAttributeTypePermissions(attributeType, this.transactionController, this);
            change = true;
        }
        for (IAttributeTypeID attributeTypeID : this.attributeTypeIDsToDelete) {
            typeManagerAttribute.requestDeleteAttributeTypePermission(attributeTypeID, this.transactionController);
            change = true;
        }
        for (ObjectTypeCategory toAdd : this.categoriesToAdd) {
            typeManagerCategory.requestAddObjectTypesCategoryPermissions(toAdd, this.transactionController, this);
            change = true;
        }
        for (ObjectTypeCategory toModify : this.categoriesToModify.values()) {
            typeManagerCategory.requestModifyObjectTypesCategoryPermissions(toModify, this.transactionController, this);
            change = true;
        }
        for (ObjectTypeCategory toDelete : this.categoriesToDelete) {
            typeManagerCategory.requestDeleteObjectTypesCategoryPermission(toDelete, this.transactionController);
            change = true;
        }
        if (change && !(allSaved = this.projectAgent.saveAllEditors(this.baseComposite.getShell(), Messages.getString("PropertyAdminUserDefinedAttributeTypesDataType.save"), false, true, false))) {
            this.transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("Formeditors.cancelSaveing"), Messages.getString("PropertyAdminUserDefinedAttributeTypesDataType.canceled"), 4));
        }
        return this.transactionController.execute();
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
            this.transactionController = null;
        }
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.hasChanges()) {
            final IFrameUserDefinedAttributeTypesManager typeManagerAttributes = this.projectAgent.getFrameUserDefinedAttributeTypesManager();
            final ObjectTypeCategoriesManager typeManagerCategories = this.projectAgent.getObjectTypeCategoriesManager();
            this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFramePermissionChecker().hasPermission("defineAttributeTypes", (String)null, PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent)) {
                            throw new EXNoPermission((IPermissionOperand)PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent, "defineAttributeTypes");
                        }
                        for (ObjectTypeCategory categoryToDelete : PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToDelete) {
                            if (typeManagerCategories.getAllAttributeOwnerUsingCategory(categoryToDelete).isEmpty()) continue;
                            throw new EXInvalidValue("Trying to delete a category which is still in use (name=" + categoryToDelete.getDisplayName() + ", " + "id=" + categoryToDelete.getUID() + ", " + "dataTypeId=" + categoryToDelete.getCockpitDataTypeID() + ")");
                        }
                        PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFrameLockManager().checkIfClientAlreadyHasProjectLock();
                        ArrayList<ObjectTypeCategory> categoriesWithPossiblyNewIcons = new ArrayList<ObjectTypeCategory>(PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToAdd.size() + PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToModify.size());
                        ArrayList<ObjectTypeCategory> categoriesWithPossiblyObsoleteIcons = new ArrayList<ObjectTypeCategory>(PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToDelete.size() + PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToModify.size());
                        categoriesWithPossiblyNewIcons.addAll(PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToAdd);
                        categoriesWithPossiblyObsoleteIcons.addAll(PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToDelete);
                        for (ObjectTypeCategory savedCategory : PropertyAdminUserDefinedAttributeTypesDataType.this.allSavedCategories) {
                            ObjectTypeCategory modifiedCategory = (ObjectTypeCategory)PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToModify.get(savedCategory.getObjectTypeCategoryID());
                            if (modifiedCategory == null || Equals.equals((Object)modifiedCategory.getIcon(), (Object)savedCategory.getIcon())) continue;
                            categoriesWithPossiblyObsoleteIcons.add(savedCategory);
                            categoriesWithPossiblyNewIcons.add(modifiedCategory);
                        }
                        for (ObjectTypeCategory singleCategory : categoriesWithPossiblyNewIcons) {
                            if (singleCategory.getIcon() == null || singleCategory.getIcon().equals(FileID.NO_FILE) || !PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFilesManager().hasFileInTemporaryStorage(singleCategory.getIcon())) continue;
                            PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFilesManager().markFileAsBeeingReferenced(singleCategory.getIcon());
                        }
                        for (ObjectTypeCategory singleCategory : categoriesWithPossiblyObsoleteIcons) {
                            if (singleCategory.getIcon() == null || singleCategory.getIcon().equals(FileID.NO_FILE) || !PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFilesManager().hasFile(singleCategory.getIcon())) continue;
                            PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFilesManager().markFileAsBeeingNotReferenced(singleCategory.getIcon());
                        }
                        if (!PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToDelete.isEmpty()) {
                            typeManagerCategories.removeItems(PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToDelete);
                        }
                        if (!PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypeIDsToDelete.isEmpty()) {
                            typeManagerAttributes.deleteUserDefinedAttributeTypes(PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypeIDsToDelete);
                        }
                        for (IAttributeType modifiedType : PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToModify.values()) {
                            IAttributeType originalType = PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFrameUserDefinedAttributeTypesManager().getUserDefinedAttributeType(modifiedType.getAttributeTypeID());
                            if (!originalType.getHumanReadableID().equals(modifiedType.getHumanReadableID()) || !originalType.getDisplayName().equals(modifiedType.getDisplayName())) {
                                typeManagerAttributes.setHumanReadableIDAndDisplayName(modifiedType.getAttributeTypeID(), modifiedType.getHumanReadableID(), modifiedType.getDisplayName());
                            }
                            if (originalType.getValueRange() == null && modifiedType.getValueRange() != null || originalType.getValueRange() != null && modifiedType.getValueRange() == null || originalType.getValueRange() != null && modifiedType.getValueRange() != null && !originalType.getValueRange().equals(modifiedType.getValueRange())) {
                                typeManagerAttributes.setValueRange(modifiedType.getAttributeTypeID(), modifiedType.getValueRange());
                            }
                            if (originalType.getSortCriterium().equals(modifiedType.getSortCriterium())) continue;
                            typeManagerAttributes.setSortCriterium(modifiedType.getAttributeTypeID(), modifiedType.getSortCriterium());
                        }
                        if (!PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToModify.isEmpty()) {
                            typeManagerCategories.itemPropertiesModified(PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToModify.values().toArray(new ObjectTypeCategory[PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToModify.size()]));
                        }
                        if (!PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToAdd.isEmpty()) {
                            typeManagerAttributes.addUserDefinedAttributeTypes(PropertyAdminUserDefinedAttributeTypesDataType.this.attributeTypesToAdd);
                        }
                        for (ObjectTypeCategory singleCategoryToAdd : PropertyAdminUserDefinedAttributeTypesDataType.this.categoriesToAdd) {
                            typeManagerCategories.addItem(singleCategoryToAdd);
                        }
                    }
                    catch (EXNoLock e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXNoPermission e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXInvalidValue e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    if (PropertyAdminUserDefinedAttributeTypesDataType.this.transactionController != null) {
                        typeManagerAttributes.modificationFinished(PropertyAdminUserDefinedAttributeTypesDataType.this.dataType.getCockpitDataTypeID(), PropertyAdminUserDefinedAttributeTypesDataType.this.transactionController);
                        PropertyAdminUserDefinedAttributeTypesDataType.this.transactionController = null;
                    }
                }
            });
        }
    }

    @Override
    public void cancelPropertyChanges1() {
        if (this.transactionController != null) {
            this.projectAgent.getFrameUserDefinedAttributeTypesManager().modificationFinished(this.dataType.getCockpitDataTypeID(), this.transactionController);
        }
    }

    @Override
    public void disposeResources() {
        PropertyAdminUserDefinedAttributeTypesDataType.disposeImage(this.iconForIconLabel);
        for (FileID singleTempImage : this.temporaryImages) {
            if (singleTempImage == null || !this.projectAgent.getFilesManager().hasFileInTemporaryStorage(singleTempImage)) continue;
            this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(singleTempImage);
        }
    }

    private static void disposeImage(Image singleImageToDispose) {
        if (singleImageToDispose != null) {
            singleImageToDispose.dispose();
        }
    }

    @Override
    public int getTypeOfPage() {
        return 0;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return this.modificationProblems;
    }

    @Override
    public IAttributeType getModifiedAttributeType(IAttributeTypeID attributeTypeUID) {
        return this.attributeTypesToModify.get(attributeTypeUID);
    }

    @Override
    public boolean isDeleted(IAttributeTypeID attributeTypeID) {
        return this.attributeTypeIDsToDelete.contains(attributeTypeID);
    }

    @Override
    public Collection<? extends IAttributeType> getAddedAttributeTypes() {
        return this.attributeTypesToAdd;
    }

    @Override
    public Collection<? extends IAttributeType> getModifiedAttributeTypes() {
        return this.attributeTypesToModify.values();
    }

    @Override
    public ObjectTypeCategory getModifiedObjectTypeCategory(ObjectTypeCategoryID objectTypeCategoryID) {
        return this.categoriesToModify.get(objectTypeCategoryID);
    }

    @Override
    public Collection<? extends ObjectTypeCategory> getAddedObjectTypeCategories() {
        return this.categoriesToAdd;
    }

    @Override
    public Collection<? extends ObjectTypeCategory> getModifiedObjectTypeCategories() {
        return this.categoriesToModify.values();
    }

    @Override
    public boolean isDeleted(ObjectTypeCategory objectTypeCategoryID) {
        return this.categoriesToDelete.contains(objectTypeCategoryID);
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeCustomProperties.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeCustomPropertiesAdministrate.getInstance();
    }

    private List<IAttributeType> getCurrentListOfAttributes() {
        ArrayList<IAttributeType> types = new ArrayList<IAttributeType>();
        types.addAll(this.allSavedUserDefinedAttributeTypes);
        types.addAll(this.attributeTypesToAdd);
        for (IAttributeType type : this.attributeTypesToModify.values()) {
            PropertyAdminUserDefinedAttributeTypesDataType.removeAttributeTypeById(type.getAttributeTypeID(), types);
            types.add(type);
        }
        for (IAttributeTypeID id : this.attributeTypeIDsToDelete) {
            PropertyAdminUserDefinedAttributeTypesDataType.removeAttributeTypeById(id, types);
        }
        return types;
    }

    private static void removeAttributeTypeById(IAttributeTypeID attributeTypeID, Collection<IAttributeType> collection) {
        Iterator<IAttributeType> i = collection.iterator();
        while (i.hasNext()) {
            IAttributeType type = i.next();
            if (!type.getAttributeTypeID().equals(attributeTypeID)) continue;
            i.remove();
        }
    }

    private List<ObjectTypeCategory> getCurrentListOfCategories(boolean sort) {
        ArrayList<ObjectTypeCategory> categories = new ArrayList<ObjectTypeCategory>();
        categories.addAll(this.allSavedCategories);
        categories.addAll(this.categoriesToAdd);
        for (ObjectTypeCategory type : this.categoriesToModify.values()) {
            PropertyAdminUserDefinedAttributeTypesDataType.removeCategoryById(type.getObjectTypeCategoryID(), categories);
            categories.add(type);
        }
        categories.removeAll(this.categoriesToDelete);
        if (sort) {
            Collections.sort(categories, new Comparator<ObjectTypeCategory>(){

                @Override
                public int compare(ObjectTypeCategory o1, ObjectTypeCategory o2) {
                    return o1.getSortPosition() - o2.getSortPosition();
                }
            });
        }
        return categories;
    }

    private static void removeCategoryById(ObjectTypeCategoryID objectTypeCategoryId, Collection<ObjectTypeCategory> collection) {
        Iterator<ObjectTypeCategory> i = collection.iterator();
        while (i.hasNext()) {
            ObjectTypeCategory type = i.next();
            if (!type.getObjectTypeCategoryID().equals((Object)objectTypeCategoryId)) continue;
            i.remove();
        }
    }

    private void setDialogMessage(String message, int severity) {
        if (message != null) {
            this.dialog.setMessage(message, severity, this);
        } else {
            this.dialog.setMessage(String.valueOf(Messages.getString("PropertyAdminUserDefinedAttributeTypes.add_and_change_custom_properties")) + this.dataType.getDisplayName() + ".", 0, this);
        }
    }

    private class ContentProviderForAttributes
    implements IStructuredContentProvider {
        private ContentProviderForAttributes() {
        }

        public Object[] getElements(Object inputElement) {
            return PropertyAdminUserDefinedAttributeTypesDataType.this.getCurrentListOfAttributes().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ContentProviderForCategories
    implements ITreeContentProvider {
        private ContentProviderForCategories() {
        }

        public Object[] getElements(Object inputElement) {
            List categories = PropertyAdminUserDefinedAttributeTypesDataType.this.getCurrentListOfCategories(true);
            if (categories.size() > 0) {
                return categories.toArray();
            }
            return new Object[]{new Object()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class LabelProviderForAttributes
    implements ITableLabelProvider {
        private LabelProviderForAttributes() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IAttributeType type = (IAttributeType)element;
            String columnText = type.getDisplayName();
            if (type.isMigratedFromFixedAttribute()) {
                columnText = String.valueOf(columnText) + Messages.getString("PropertyAdminUserDefinedAttributeTypes.fixed_attribute");
            }
            return columnText;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class LabelProviderForCategories
    implements ITableWithRowHeadingsLabelProvider {
        private final HashMap<FileID, Tuple<Image, Boolean>> imageCache = new HashMap();
        private final Image imgCheckboxTrue;
        private final Image imgCheckboxFalse;

        private LabelProviderForCategories() {
            this.imgCheckboxTrue = CheckboxImages.getCheckboxImage((Display)PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.getDisplay(), (boolean)true, (boolean)false, (boolean)PropertyAdminUserDefinedAttributeTypesDataType.this.mayModify, (int)26);
            this.imgCheckboxFalse = CheckboxImages.getCheckboxImage((Display)PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.getDisplay(), (boolean)false, (boolean)false, (boolean)PropertyAdminUserDefinedAttributeTypesDataType.this.mayModify, (int)26);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image img = null;
            if (element instanceof ObjectTypeCategory) {
                IAttributeTypeID attr;
                ObjectTypeCategory category = (ObjectTypeCategory)element;
                if (columnIndex < PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTableColumnHeaders.size() && (attr = (IAttributeTypeID)PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTableColumnHeaders.get(columnIndex)) != null) {
                    img = category.getAttributeList().contains(attr) ? this.imgCheckboxTrue : this.imgCheckboxFalse;
                }
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            for (Tuple<Image, Boolean> imageTuple : this.imageCache.values()) {
                if (imageTuple.getT1() == null || !((Boolean)imageTuple.getT2()).booleanValue()) continue;
                ((Image)imageTuple.getT1()).dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public String getRowHeadingText(Object element) {
            if (element instanceof ObjectTypeCategory) {
                return ((ObjectTypeCategory)element).getDisplayName();
            }
            return null;
        }

        public Image getRowHeadingImage(Object element) {
            ObjectTypeCategory category;
            Image icon = null;
            if (element instanceof ObjectTypeCategory && !(category = (ObjectTypeCategory)element).getIcon().equals(FileID.NO_FILE)) {
                Tuple<Image, Boolean> iconTuple = this.imageCache.get(category.getIcon());
                if (iconTuple != null) {
                    icon = (Image)iconTuple.getT1();
                } else {
                    ImageData iconData = PropertyAdminUserDefinedAttributeTypesDataType.this.projectAgent.getFilesManager().getImageFromFile(category.getIcon(), "Error while retrieving icon file for category from FilesManager");
                    if (iconData != null) {
                        icon = new Image((Device)PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.getDisplay(), iconData);
                        this.imageCache.put(category.getIcon(), (Tuple<Image, Boolean>)new Tuple((Object)icon, (Object)Boolean.TRUE));
                    } else {
                        logger.error("Icon file from category is missing unexpectedly (name=" + category.getDisplayName() + ", " + "id=" + category.getUID() + ", " + "dataTypId=" + category.getCockpitDataTypeID() + ")");
                        icon = ImageCache.getImage((Display)PropertyAdminUserDefinedAttributeTypesDataType.this.baseComposite.getDisplay(), (IStreamResource)Icons16x16.EMPTY);
                        this.imageCache.put(category.getIcon(), (Tuple<Image, Boolean>)new Tuple((Object)icon, (Object)Boolean.FALSE));
                    }
                }
            }
            return icon;
        }
    }

    private class MoveAttributeAction
    extends Action {
        private final int positionsToMove;
        private IAttributeType selectedAttributeType;
        private int index;

        public MoveAttributeAction(int positions) {
            this.positionsToMove = -positions;
            if (this.positionsToMove > 0) {
                this.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.up"));
                this.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.up_desc"));
                this.setImageDescriptor(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/arrow_up.gif"));
            } else {
                this.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.down"));
                this.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.down_desc"));
                this.setImageDescriptor(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/arrow_down.gif"));
            }
        }

        private boolean validPosition() {
            return this.positionsToMove > 0 && this.index > this.positionsToMove - 1 || this.positionsToMove < 0 && this.index < PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.getTable().getItemCount() + this.positionsToMove;
        }

        public void update() {
            this.selectedAttributeType = null;
            if (PropertyAdminUserDefinedAttributeTypesDataType.this.mayModify && PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.getTable().getSelectionCount() == 1) {
                this.index = PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.getTable().getSelectionIndex();
                if (this.validPosition()) {
                    TableItem tableItem = PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.getTable().getItem(this.index);
                    this.selectedAttributeType = (IAttributeType)tableItem.getData();
                }
            }
            this.setEnabled(this.selectedAttributeType != null);
        }

        public void run() {
            if (this.selectedAttributeType != null && this.validPosition()) {
                int indexToSwitchWith = this.index - this.positionsToMove;
                IAttributeType attrTypeToSwitchWith = (IAttributeType)PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.getTable().getItem(indexToSwitchWith).getData();
                IAttributeTypeSortCriterium selectedAttrTypeSortCriterium = this.selectedAttributeType.getSortCriterium();
                IAttributeTypeSortCriterium attrTypeToSwitchWithSortCriterium = attrTypeToSwitchWith.getSortCriterium();
                AttributeType attrTypeToSwitchWith_modified = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyAttribute(attrTypeToSwitchWith);
                AttributeType selectedAttributeType_modified = PropertyAdminUserDefinedAttributeTypesDataType.this.modifyAttribute(this.selectedAttributeType);
                selectedAttributeType_modified.setSortCriterium(attrTypeToSwitchWithSortCriterium);
                attrTypeToSwitchWith_modified.setSortCriterium(selectedAttrTypeSortCriterium);
                PropertyAdminUserDefinedAttributeTypesDataType.this.tableViewer.refresh();
                this.selectedAttributeType = null;
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveAttributeUpAction.update();
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveAttributeDownAction.update();
                PropertyAdminUserDefinedAttributeTypesDataType.this.recreateTableForCategories();
            }
        }
    }

    private class MoveCategoryAction
    extends Action {
        private final int positionsToMove;
        private ObjectTypeCategory selectedCategory;

        public MoveCategoryAction(int positions) {
            this.positionsToMove = positions;
            if (positions < 0) {
                this.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Up.ToolTip"));
                this.setImageDescriptor(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/arrow_up.gif"));
            } else {
                this.setToolTipText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.Category.Down.ToolTip"));
                this.setImageDescriptor(ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), (String)"icons/arrow_down.gif"));
            }
        }

        public void update() {
            IStructuredSelection selection;
            this.selectedCategory = null;
            boolean enable = false;
            if (PropertyAdminUserDefinedAttributeTypesDataType.this.mayModify && PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.getSelection()).size() == 1 && selection.getFirstElement() instanceof ObjectTypeCategory) {
                this.selectedCategory = (ObjectTypeCategory)selection.getFirstElement();
                List sortedCategories = PropertyAdminUserDefinedAttributeTypesDataType.this.getCurrentListOfCategories(true);
                int indexOfSelectedCategory = sortedCategories.indexOf(this.selectedCategory);
                if (this.positionsToMove < 0 && indexOfSelectedCategory > 0 || this.positionsToMove > 0 && indexOfSelectedCategory < sortedCategories.size() - 1) {
                    enable = true;
                }
            }
            this.setEnabled(enable);
        }

        public void run() {
            if (this.selectedCategory != null) {
                int direction;
                int end;
                int start;
                List sortedCategories = PropertyAdminUserDefinedAttributeTypesDataType.this.getCurrentListOfCategories(true);
                if (this.positionsToMove > 0) {
                    start = sortedCategories.indexOf(this.selectedCategory);
                    end = Math.min(start + this.positionsToMove + 1, sortedCategories.size());
                    direction = -1;
                } else {
                    end = sortedCategories.indexOf(this.selectedCategory) + 1;
                    start = Math.max(0, end + this.positionsToMove - 1);
                    direction = 1;
                }
                Collections.rotate(sortedCategories.subList(start, end), direction);
                int i = 0;
                while (i < sortedCategories.size()) {
                    ObjectTypeCategory category = (ObjectTypeCategory)sortedCategories.get(i);
                    if (category.getSortPosition() != i) {
                        PropertyAdminUserDefinedAttributeTypesDataType.this.modifyCategory(category).setSortPosition(i);
                    }
                    ++i;
                }
                PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.refresh();
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveCategoryUpAction.update();
                PropertyAdminUserDefinedAttributeTypesDataType.this.moveCategoryDownAction.update();
                PropertyAdminUserDefinedAttributeTypesDataType.this.objectTypesCategoryTable.revealSelection();
            }
        }
    }
}

