/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.dialogs.stakeholder.AddRoleDialog;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRoleAttributeTypesProvider;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHFileNewStakeholderRole
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHFileNewStakeholderRole.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        AddRoleDialog addRoleDialog;
        int answer;
        ProjectAgent projectAgent;
        String projectUID;
        IStructuredSelection selection;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell != null && (selection = CommandHandlerHelper.getRelevantSelection(event)) != null && (projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection)) != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null && projectAgent.isOpened() && (answer = (addRoleDialog = new AddRoleDialog(shell, projectAgent)).open()) == 0) {
            IStakeholderRoleAddID addID;
            String name = addRoleDialog.getNewName();
            ObjectTypeCategoryID categoryID = addRoleDialog.getObjectTypeCategoryID();
            ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
            String description = addRoleDialog.getNewDescription();
            if (description != null) {
                attributes.add(new Attribute(StakeholderRoleAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null)));
            }
            if ((addID = projectAgent.getFrameStakeholderManager().requestStakeholderRoleAddPermission(name, categoryID, attributes)).permissionGranted()) {
                try {
                    projectAgent.getFrameStakeholderManager().addRole(addID);
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
            } else {
                ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(Collections.singletonList(addID.getModificationProblem()), Messages.getString("CreateStakeholderRoleAction.could_not_create_role"), shell);
                problemsDialog.open();
            }
        }
        return null;
    }
}

