/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.frame.client.global.gui.views.project.contextmenus.GlobalSelectionTranslationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.datainterchange.plan.PlanCopyManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHEditCopyPlanAsImage
extends AbstractHandler {
    private static final ILogger LOGGER = Logger.getLogger(CHEditCopyPlanAsImage.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final ArrayList<IPlan> selectedPlans = new ArrayList<IPlan>();
        if (selection instanceof IStructuredSelection) {
            String projectUID = null;
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object o : sel) {
                GlobalSelectionTranslationManager translationManager;
                Object translatedO;
                if (o instanceof IPlan) {
                    IPlan plan = (IPlan)o;
                    if (projectUID == null || plan.getProjectUID().equals(projectUID)) {
                        selectedPlans.add((IPlan)o);
                        projectUID = plan.getProjectUID();
                        continue;
                    }
                }
                if ((translatedO = (translationManager = GlobalSelectionTranslationManager.getTranslationManager()).translate(new Class[]{IPlan.class}, o)) == null) break;
                IPlan plan = (IPlan)translatedO;
                if (projectUID != null && !plan.getProjectUID().equals(projectUID)) break;
                selectedPlans.add((IPlan)translatedO);
                projectUID = plan.getProjectUID();
            }
        }
        if (!selectedPlans.isEmpty()) {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(window.getShell());
            progressDialog.setOpenOnRun(true);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    JFaceProgressMonitorToProgressDisplayAdapter monitorAdapter = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                    PlanCopyManager copyAndPasteManager = new PlanCopyManager(window.getWorkbench().getDisplay());
                    copyAndPasteManager.copyAsPNG(selectedPlans, (IProgressDisplay)monitorAdapter);
                }
            };
            try {
                progressDialog.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("could not execute", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOGGER.error("could not execute", (Throwable)e);
            }
        }
        return null;
    }
}

