/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs.locking;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringPairKey;
import java.util.HashMap;
import java.util.HashSet;

public class LockingAdminProjectDictionary {
    private static final ILogger logger = Logger.getLogger(LockingAdminProjectDictionary.class);
    private final HashSet<String> initialisedServerIDs = new HashSet();
    private final HashMap<StringPairKey, String> projectIDAndServerID2ProjectName = new HashMap();

    public String getProjectName(String projectID, String serverID) {
        if (!this.initialisedServerIDs.contains(serverID)) {
            this.fillHashMapWithProjectNames(serverID);
            this.initialisedServerIDs.add(serverID);
        }
        StringPairKey pairKey = new StringPairKey(projectID, serverID);
        return this.projectIDAndServerID2ProjectName.get(pairKey);
    }

    private void fillHashMapWithProjectNames(String serverID) {
        try {
            EOProject[] projects;
            EOProject[] eOProjectArray = projects = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID).getAvailableProjectsFromServer(null);
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                EOProject project = eOProjectArray[n2];
                this.projectIDAndServerID2ProjectName.put(new StringPairKey(project.getProjectUID(), serverID), Project.getProjectName(project));
                ++n2;
            }
        }
        catch (Throwable ta) {
            logger.error("could not retrieve projects", ta);
        }
    }
}

