/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.AbstractOpenPlanAction;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPage;

public class OpenPlanWithPlanDisplayParametersAction
extends AbstractOpenPlanAction {
    private final String projectUID;

    public static String getAttributeName(String projectUID, IAttributeTypeID uniqueElementAttributeTypeIDforPlanElementName) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        IAttributeTypesProvider uniqueElementAttributeTypesProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
        IAttributeType attributeType = uniqueElementAttributeTypesProvider.getAttributeType(uniqueElementAttributeTypeIDforPlanElementName);
        String attributeName = attributeType.getDisplayName();
        return attributeName;
    }

    public static String getNameAttributeLanguage(String projectUID, IAttributeTypeID uniqueElementAttributeTypeIDforPlanElementName) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        IAttributeTypesProvider uniqueElementAttributeTypesProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
        IAttributeType attributeType = uniqueElementAttributeTypesProvider.getAttributeType(uniqueElementAttributeTypeIDforPlanElementName);
        String languageOfNameAttributeType = PlanAgentManager.getLanguageOfNameAttributeType(attributeType);
        return languageOfNameAttributeType;
    }

    public static String getDescriptionAttributeLanguage(String projectUID, IAttributeTypeID uniqueElementAttributeTypeIDforPlanElementDescription) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        IAttributeTypesProvider uniqueElementAttributeTypesProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
        IAttributeType attributeType = uniqueElementAttributeTypesProvider.getAttributeType(uniqueElementAttributeTypeIDforPlanElementDescription);
        String languageOfDescriptionAttributeType = PlanAgentManager.getLanguageOfDescriptionAttributeType(attributeType);
        return languageOfDescriptionAttributeType;
    }

    public static String getCommentAttributeLanguage(String projectUID, IAttributeTypeID uniqueElementAttributeTypeIDforPlanElementComment) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        IAttributeTypesProvider uniqueElementAttributeTypesProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.uniqueelement");
        IAttributeType attributeType = uniqueElementAttributeTypesProvider.getAttributeType(uniqueElementAttributeTypeIDforPlanElementComment);
        String languageOfCommentAttributeType = PlanAgentManager.getLanguageOfCommentAttributeType(attributeType);
        return languageOfCommentAttributeType;
    }

    public OpenPlanWithPlanDisplayParametersAction(ISelectionProvider selectionProvider, IWorkbenchPage page, String projectUID, PlanDisplayParameters planDisplayParameters) {
        super(selectionProvider, page, page.getWorkbenchWindow().getShell(), planDisplayParameters);
        this.projectUID = projectUID;
        List<IPlan> selectedPlans = this.getSelectedPlans(projectUID);
        boolean enable = true;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        for (IPlan selectedPlan : selectedPlans) {
            String errorMsg = projectAgent.getPlanEditorManager().checkPlanAgentAvailability(selectedPlan.getPlantypeUID());
            if (errorMsg != null && this.getToolTipText() == null) {
                this.setToolTipText(errorMsg);
            }
            enable &= errorMsg == null;
        }
        this.setEnabled(enable &= !selectedPlans.isEmpty());
        this.setText(planDisplayParameters.calculateLabelExtension(projectUID));
        this.setToolTipText(Messages.getString("OpenPlanTranslaction.Open_with_FMC_Viewer_2"));
        this.setDescription(Messages.getString("OpenPlanTranslaction.Open_with_FMC_Viewer_3"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("open_plan.gif"));
    }

    public void run() {
        for (IPlan selectedPlan : this.getSelectedPlans(this.projectUID)) {
            this.launchPlan(selectedPlan);
        }
    }

    @Override
    protected String getPreferredPerspectiveID() {
        return "com.arcway.cockpit.frame.mainperspective";
    }

    @Override
    protected String getSwitchPreferenceKey() {
        return "SwitchToMainPerspective";
    }
}

