/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractGraphicsProvidingDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.PlanDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElement;
import com.arcway.cockpit.docgen.provider.interfaces.IPlan;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.docgen.provider.utils.PlanComparator;
import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelementrelationview.UniqueElementRelationGraphDependencyModel;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelementrelationview.UniqueElementRelationGraphLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.GraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationGraphProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewViewPartFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.ITextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.RelationViewGraphicProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.RelationViewViewPartFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.ViewPartTextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.dependencynet.DependencyNetGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.dependencynet.IDependencyModel;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementComparator;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementRelationshipHelper;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipProviderManager;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class UniqueElementDocGenProxy
extends AbstractGraphicsProvidingDocGenProxy
implements IModelElement {
    private final IDocGeneratorProjectAgent projectAgent;
    private final IUniqueElement uniqueElement;
    private final Collection<AbstractFilter> filters;
    private final Locale locale;
    private RelationViewViewPartFactory viewPartFactory;
    private RelationViewGraphicProvider graphicProvider;
    private final IWorkbenchPage currentPage;

    public UniqueElementDocGenProxy(IUniqueElement uniqueElement, IDocGeneratorProjectAgent projectAgent, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper fileAttributeProvider, Locale locale, IWorkbenchPage currentPage) {
        super((IAttributeOwner)uniqueElement, fileAttributeProvider, (IFrameProjectAgent)projectAgent.getProjectAgent(), locale);
        this.uniqueElement = uniqueElement;
        this.projectAgent = projectAgent;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.uniqueElement.getUID();
    }

    @Override
    public String getTypeID() {
        return "uniqueElement";
    }

    @Override
    public String getTypeName() {
        return ((IFrameDataTypeDescription)FrameDataTypes.getDataType((String)"com.arcway.cockpit.uniqueelement")).getDisplayName(this.locale);
    }

    @Override
    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.uniqueElement.getElementName());
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.uniqueElement.getElementName());
    }

    @Override
    public boolean hasDescription() {
        return this.uniqueElement.getDescription().length() > 0;
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.uniqueElement.getDescription());
        List<String> result = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput(descriptionList);
        return result;
    }

    @Override
    public String getElementTypeName() {
        try {
            return HTMLEncoder.encode((String)ExtensionMgr.getDefault().getConstructionElementNameForType(this.uniqueElement.getElementTypeID(), this.locale));
        }
        catch (EXConstructionElementTypeUnknown e) {
            return "";
        }
    }

    @Override
    public String getElementTypeID() {
        return this.uniqueElement.getElementTypeID();
    }

    @Override
    public List<? extends IPlan> getOccurrences() {
        ArrayList plans = new ArrayList(this.projectAgent.getPlansForUniqueElement(this.uniqueElement, this.filters));
        Collections.sort(plans, new PlanComparator());
        ArrayList<PlanDocGenProxy> result = new ArrayList<PlanDocGenProxy>(plans.size());
        for (com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan plan : plans) {
            PlanDocGenProxy planDescription = new PlanDocGenProxy(plan, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
            result.add(planDescription);
        }
        return result;
    }

    public List<IModelElement> getContainedModelElements() {
        ArrayList<IUniqueElement> containedUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getAllNextUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containedUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getContainedModelElementsOnPlan(IPlan plan) {
        return this.getContainedModelElementsOnPlan_internal(plan.getUniqueIdentifier());
    }

    private List<IModelElement> getContainedModelElementsOnPlan_internal(String planUID) {
        ArrayList<IUniqueElement> containedUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getAllNextUniqueElementsOnPlan(this.uniqueElement.getUID(), planUID));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containedUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getContainerModelElements() {
        ArrayList<IUniqueElement> containerUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getAllPreviousUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containerUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getContainerModelElementsOnPlan(IPlan plan) {
        ArrayList<IUniqueElement> containerUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getAllPreviousUniqueElementsOnPlan(this.uniqueElement.getUID(), plan.getUniqueIdentifier()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containerUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getDirectContainerModelElements() {
        ArrayList<IUniqueElement> containerUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getPreviousUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containerUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getDirectContainerModelElementsOnPlan(IPlan plan) {
        ArrayList<IUniqueElement> containerUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getPreviousUniqueElementsOnPlan(this.uniqueElement.getUID(), plan.getUniqueIdentifier()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containerUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getDirectlyContainedModelElements() {
        ArrayList<IUniqueElement> containedUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getNextUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containedUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getDirectlyContainedModelElementsOnPlan(IPlan plan) {
        return this.getDirectlyContainedModelElementsOnPlan_internal(plan.getUniqueIdentifier());
    }

    private List<IModelElement> getDirectlyContainedModelElementsOnPlan_internal(String planUID) {
        ArrayList<IUniqueElement> containedUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().getNextUniqueElementsOnPlan(this.uniqueElement.getUID(), planUID));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(containedUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    @Override
    public boolean isPartOfContainmentCycle() {
        return this.projectAgent.getUERelationshipProviderManager().getContainmentRelationshipProvider().isPartOfCycle(this.uniqueElement.getUID());
    }

    @Deprecated
    public List<IModelElement> getContainedUniqueElements(String planUID) {
        return this.getContainedModelElementsOnPlan_internal(planUID);
    }

    @Deprecated
    public List<IModelElement> getDirectlyContainedUniqueElements(String planUID) {
        return this.getDirectlyContainedModelElementsOnPlan_internal(planUID);
    }

    @Deprecated
    public List<IModelElement> getContainedUniqueElements() {
        return this.getContainedModelElements();
    }

    @Deprecated
    public List<IModelElement> getContainerUniqueElements() {
        return this.getContainerModelElements();
    }

    @Deprecated
    public boolean hasContainedUniqueElements() {
        return !this.getContainedUniqueElements().isEmpty();
    }

    @Deprecated
    public boolean hasContainerUniqueElements() {
        return !this.getContainerUniqueElements().isEmpty();
    }

    public List<IModelElement> getCommunicatingFunctions() {
        return this.getCommunicatingFunctionsOnPlan(null);
    }

    public List<IModelElement> getCommunicatingFunctionsOnPlan(IPlan plan) {
        if (this.isActiveElement()) {
            List communicatingFunctions = (List)UniqueElementRelationshipHelper.getActiveAndPassiveBidirectionallyRelatedElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT1();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(communicatingFunctions, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getInfluencedInfos() {
        return this.getInfluencedInfosOnPlan(null);
    }

    public List<IModelElement> getInfluencedInfosOnPlan(IPlan plan) {
        if (this.isPassiveElement()) {
            List influencedInfos = (List)UniqueElementRelationshipHelper.getActiveAndPassiveSuccessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT2();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(influencedInfos, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getInfluencingInfos() {
        return this.getInfluencingInfosOnPlan(null);
    }

    public List<IModelElement> getInfluencingInfosOnPlan(IPlan plan) {
        if (this.isPassiveElement()) {
            List influencingInfos = (List)UniqueElementRelationshipHelper.getActiveAndPassivePredecessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT2();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(influencingInfos, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getModifiedInfos() {
        return this.getModifiedInfosOnPlan(null);
    }

    public List<IModelElement> getModifiedInfosOnPlan(IPlan plan) {
        if (this.isActiveElement()) {
            List modifiedInfos = (List)UniqueElementRelationshipHelper.getActiveAndPassiveBidirectionallyRelatedElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT2();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(modifiedInfos, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getModifyingFunctions() {
        return this.getModifyingFunctionsOnPlan(null);
    }

    public List<IModelElement> getModifyingFunctionsOnPlan(IPlan plan) {
        if (this.isPassiveElement()) {
            List modifyingFunctions = (List)UniqueElementRelationshipHelper.getActiveAndPassiveBidirectionallyRelatedElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT1();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(modifyingFunctions, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getReadInfos() {
        return this.getReadInfosOnPlan(null);
    }

    public List<IModelElement> getReadInfosOnPlan(IPlan plan) {
        if (this.isActiveElement()) {
            List readInfos = (List)UniqueElementRelationshipHelper.getActiveAndPassivePredecessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT2();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(readInfos, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getReadingFunctions() {
        return this.getReadingFunctionsOnPlan(null);
    }

    public List<IModelElement> getReadingFunctionsOnPlan(IPlan plan) {
        if (this.isPassiveElement()) {
            List readingFunctions = (List)UniqueElementRelationshipHelper.getActiveAndPassiveSuccessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT1();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(readingFunctions, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getReceivingFunctions() {
        return this.getReceivingFunctionsOnPlan(null);
    }

    @Override
    public List<IModelElement> getReceivingFunctionsOnPlan(IPlan plan) {
        if (this.isActiveElement()) {
            List receivingFunctions = (List)UniqueElementRelationshipHelper.getActiveAndPassiveSuccessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT1();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(receivingFunctions, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getRelatedInfos() {
        return this.getRelatedInfosOnPlan(null);
    }

    public List<IModelElement> getRelatedInfosOnPlan(IPlan plan) {
        if (this.isPassiveElement()) {
            List relatedInfos = (List)UniqueElementRelationshipHelper.getActiveAndPassiveBidirectionallyRelatedElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT2();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(relatedInfos, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getSendingFunctions() {
        return this.getSendingFunctionsOnPlan(null);
    }

    public List<IModelElement> getSendingFunctionsOnPlan(IPlan plan) {
        if (this.isActiveElement()) {
            List sendingFunctions = (List)UniqueElementRelationshipHelper.getActiveAndPassivePredecessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT1();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(sendingFunctions, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    public List<IModelElement> getWritingFunctions() {
        return this.getWritingFunctionsOnPlan(null);
    }

    public List<IModelElement> getWritingFunctionsOnPlan(IPlan plan) {
        if (this.isPassiveElement()) {
            List writingFunctions = (List)UniqueElementRelationshipHelper.getActiveAndPassivePredecessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT1();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(writingFunctions, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    @Override
    public List<IModelElement> getWrittenInfos() {
        return this.getWrittenInfosOnPlan(null);
    }

    public List<IModelElement> getWrittenInfosOnPlan(IPlan plan) {
        if (this.isActiveElement()) {
            List writtenInfos = (List)UniqueElementRelationshipHelper.getActiveAndPassiveSuccessorElements((String)this.uniqueElement.getUID(), (String)(plan != null ? plan.getUniqueIdentifier() : null), (IUniqueElementRelationshipProvider)this.projectAgent.getUERelationshipProviderManager().getAccessRelationshipProvider()).getT2();
            return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(writtenInfos, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
        }
        return Collections.emptyList();
    }

    @Override
    public List<IModelElement> getCausallyDirectlyPrecedingModelElements() {
        ArrayList<IUniqueElement> causallyPrecedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getPreviousUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallyPrecedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getCausallyDirectlyPrecedingModelElementsOnPlan(IPlan plan) {
        ArrayList<IUniqueElement> causallyPrecedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getPreviousUniqueElementsOnPlan(this.uniqueElement.getUID(), plan.getUniqueIdentifier()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallyPrecedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    @Override
    public List<IModelElement> getCausallyDirectlySucceedingModelElements() {
        ArrayList<IUniqueElement> causallySucceedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getNextUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallySucceedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getCausallyDirectlySucceedingModelElementsOnPlan(IPlan plan) {
        ArrayList<IUniqueElement> causallySucceedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getNextUniqueElementsOnPlan(this.uniqueElement.getUID(), plan.getUniqueIdentifier()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallySucceedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getCausallyPrecedingModelElements() {
        ArrayList<IUniqueElement> causallyPrecedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getAllPreviousUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallyPrecedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getCausallyPrecedingModelElementsOnPlan(IPlan plan) {
        ArrayList<IUniqueElement> causallyPrecedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getAllPreviousUniqueElementsOnPlan(this.uniqueElement.getUID(), plan.getUniqueIdentifier()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallyPrecedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getCausallySucceedingModelElements() {
        ArrayList<IUniqueElement> causallySucceedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getAllNextUniqueElements(this.uniqueElement.getUID()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallySucceedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    public List<IModelElement> getCausallySucceedingModelElementsOnPlan(IPlan plan) {
        ArrayList<IUniqueElement> causallySucceedingUniqueElements = new ArrayList<IUniqueElement>(this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().getAllNextUniqueElementsOnPlan(this.uniqueElement.getUID(), plan.getUniqueIdentifier()));
        return UniqueElementDocGenProxy.transformListOfUniqueElementsToDocGenProxies(causallySucceedingUniqueElements, null, this.projectAgent, this.filters, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
    }

    @Override
    public boolean isPartOfCausalityCycle() {
        return this.projectAgent.getUERelationshipProviderManager().getCausalityRelationshipProvider().isPartOfCycle(this.uniqueElement.getUID());
    }

    @Override
    protected IGraphicProvider createGraphicProvider() {
        if (this.graphicProvider == null) {
            ViewPartTextExtendCalculator textExtendCalculator = new ViewPartTextExtendCalculator();
            UniqueElementRelationGraphLayoutProvider relationGraphProvider = new UniqueElementRelationGraphLayoutProvider();
            GraphNodeLayoutProvider layoutProvider = new GraphNodeLayoutProvider((ITextExtendCalculator)textExtendCalculator, (IRelationGraphProvider)relationGraphProvider);
            LabelCreator labelCreator = new LabelCreator((IGraphNodeLayoutProvider)layoutProvider);
            DependencyNetGraphBuilder graphBuilder = new DependencyNetGraphBuilder((IDependencyModel)new UniqueElementRelationGraphDependencyModel(){

                protected IUniqueElementRelationshipProvider fetchRelationshipProvider(UniqueElementRelationshipProviderManager relationshipProviderManager) {
                    return relationshipProviderManager.getContainmentRelationshipProvider();
                }
            }, labelCreator);
            this.viewPartFactory = new RelationViewViewPartFactory();
            this.graphicProvider = new RelationViewGraphicProvider((IRelationViewGraphBuilder)graphBuilder, (IRelationViewViewPartFactory)this.viewPartFactory, labelCreator, (ICockpitProjectData)this.uniqueElement, this.uniqueElement.getElementName());
        }
        return this.graphicProvider;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.viewPartFactory != null) {
            this.viewPartFactory.dispose();
        }
    }

    public static List<IModelElement> transformListOfUniqueElementsToDocGenProxies(List<IUniqueElement> uniqueElements, String typeID, IDocGeneratorProjectAgent projectAgent, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper graphicsAndFilesHelper, Locale projectLocale, IWorkbenchPage currentPage) {
        Collections.sort(uniqueElements, new UniqueElementComparator(1));
        ArrayList<IModelElement> docGenProxies = new ArrayList<IModelElement>(uniqueElements.size());
        for (IUniqueElement uniqueElement : uniqueElements) {
            if (typeID != null && !typeID.equals(uniqueElement.getElementTypeID())) continue;
            UniqueElementDocGenProxy ueDocGenProxy = new UniqueElementDocGenProxy(uniqueElement, projectAgent, filters, graphicsAndFilesHelper, projectLocale, currentPage);
            docGenProxies.add(ueDocGenProxy);
        }
        return docGenProxies;
    }

    private boolean isActiveElement() {
        try {
            IConstructionElementTypeDescription typeDescription = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(this.uniqueElement.getElementTypeID());
            return typeDescription.getActiveOrPassiveConstructionElementType() == 0;
        }
        catch (EXConstructionElementTypeUnknown eCETU) {
            return false;
        }
    }

    private boolean isPassiveElement() {
        try {
            IConstructionElementTypeDescription typeDescription = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(this.uniqueElement.getElementTypeID());
            return typeDescription.getActiveOrPassiveConstructionElementType() == 1;
        }
        catch (EXConstructionElementTypeUnknown eCETU) {
            return false;
        }
    }

    @Override
    public String getCommitVersion() {
        int commitCount = this.uniqueElement.getCommitCount();
        return HistoryEntry.getVersionForCommitCount(commitCount);
    }

    @Override
    public String getDateOfLastModification() {
        String lastModDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return lastModDateHTML;
    }

    @Override
    public Long getDateOfLastModification_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("lastEditDate");
    }

    @Override
    public String getLastModifier() {
        String lastModifierHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        return lastModifierHTML;
    }

    @Override
    public String getCreationDate() {
        String creationDateHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return creationDateHTML;
    }

    @Override
    public Long getCreationDate_MilliSecondsSince_01_01_1970() {
        return this.getDateTimeProperty_MilliSecondsSince_01_01_1970("creationDate");
    }

    @Override
    public String getCreator() {
        String creatorHTML = this.getHTMLEncodeSingleLineAttributeValue(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        return creatorHTML;
    }

    private String getHTMLEncodeSingleLineAttributeValue(IAttributeTypeID attrType) {
        IAttributeType attributeType;
        String htmlString = "-";
        IAttribute attribute = this.uniqueElement.getAttribute(attrType);
        if (attribute != null && (attributeType = this.uniqueElement.getAttributeType(attrType)) != null) {
            htmlString = HTMLEncoder.encode((String)attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), null, this.locale));
        }
        return htmlString;
    }

    @Override
    public String getModificationCount() {
        return String.valueOf(this.uniqueElement.getModificationCount());
    }

    @Override
    protected <T> Map<String, T> createMapOfPresentationElements(Map<String, T> mapOfRepresentedElements, boolean representedElementsArePresentationElements) {
        return mapOfRepresentedElements;
    }

    @Override
    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", this.getName());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

