/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.graphicsandfiles;

import com.arcway.cockpit.docgen.Messages;
import com.arcway.cockpit.docgen.provider.ReportDataProviderException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.IFileValidator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.stringtools.StringPairKey;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class GraphicsAndFilesStore {
    private static final ILogger logger = Logger.getLogger(GraphicsAndFilesStore.class);
    private static final String FILES_AND_IMAGES_PREFIX_NAME = "VRep_GaF";
    private final SessionTempDirectoryManager.SessionTempDirectory tempImageDirectory;
    private final Map<String, File> map_tempFileName_tempFile = new HashMap<String, File>(50, 0.5f);
    private final Map<StringPairKey, Integer> map_tempFileNamePattern_counters = new HashMap<StringPairKey, Integer>(50, 0.5f);

    public GraphicsAndFilesStore() throws ReportGenerationException {
        try {
            this.tempImageDirectory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)FILES_AND_IMAGES_PREFIX_NAME);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            throw new ReportGenerationException(Messages.getString("GraphicsAndFilesStore.CantCreateTempDirectory.Title"), Messages.getString("GraphicsAndFilesStore.CantCreateTempDirectory.Message"), (Throwable)jeriE);
        }
    }

    public File createTemporaryFileForGraphicOrFileObject(String prefix, String extension) throws ReportDataProviderException {
        StringPairKey countersKey = new StringPairKey(prefix, extension);
        Integer oldValue = this.map_tempFileNamePattern_counters.get(countersKey);
        int counterStartValue = oldValue != null ? oldValue + 1 : 1;
        boolean filenameFound = false;
        File tempFile = null;
        int counter = counterStartValue;
        while (!filenameFound && counter < Integer.MAX_VALUE) {
            StringBuilder tempFileNameBuilder = new StringBuilder(prefix.length() + 1 + 11 + extension.length());
            tempFileNameBuilder.append(prefix);
            if (counter != 1) {
                tempFileNameBuilder.append("_");
                tempFileNameBuilder.append(counter);
            }
            tempFileNameBuilder.append(extension);
            tempFile = new File((File)this.tempImageDirectory, tempFileNameBuilder.toString());
            if (!tempFile.exists()) {
                this.map_tempFileNamePattern_counters.put(countersKey, counter);
                filenameFound = true;
            } else assert (false);
            ++counter;
        }
        if (filenameFound && tempFile != null) {
            this.map_tempFileName_tempFile.put(tempFile.getName(), tempFile);
            return tempFile;
        }
        logger.warn(String.valueOf(Messages.getString("GraphicsAndFilesStore.CantCreateTempFile.Title")) + " - " + Messages.getString("GraphicsAndFilesStore.CantCreateTempFile.Message") + " (" + prefix + extension + ")");
        throw new ReportDataProviderException(Messages.getString("GraphicsAndFilesStore.CantCreateTempFile.Message"));
    }

    public File storeFileInTemporaryDirectory(File file, String fileNamePrefix) {
        String fileName = file.getName();
        int lastDotIndex = fileName.lastIndexOf(46);
        String prefix = String.valueOf(fileNamePrefix == null ? "" : fileNamePrefix) + (lastDotIndex != -1 ? fileName.substring(0, lastDotIndex) : fileName);
        String extension = lastDotIndex != -1 ? fileName.substring(lastDotIndex) : "";
        File fileInTempDirectory = this.createTemporaryFileForGraphicOrFileObject(prefix, extension);
        try {
            FileHelper.moveFile((File)file, (File)fileInTempDirectory);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.warn("Can't move file into temporary directory.", (Throwable)jeriE);
            throw new ReportDataProviderException(Messages.getString("GraphicsAndFilesStore.CantMoveFileIntoTemporary.Message"));
        }
        return fileInTempDirectory;
    }

    public void copyAllGraphicsAndFilesToTargetDirectory(ReportJob baseReportJob, File graphicsAndFilesTargetDirectory, IFileValidator fileValidator) throws ReportGenerationException {
        try {
            if (this.hasUnfilteredGraphicsAndFiles(fileValidator)) {
                baseReportJob.registerReportResultFiles(FileHelper.ensureDirectoryExistance((File)graphicsAndFilesTargetDirectory));
                baseReportJob.registerReportResultFiles(FileHelper.copyDirectoryContent((File)this.tempImageDirectory, (File)graphicsAndFilesTargetDirectory, (IFileValidator)fileValidator));
            }
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            throw new ReportGenerationException(Messages.getString("AbstractDocumentationWriter.CantCopyGraphicsAndFileObjects.Title"), Messages.getString("AbstractDocumentationWriter.CantCopyGraphicsAndFileObjects.Message"), (Throwable)jeriE);
        }
    }

    private boolean hasUnfilteredGraphicsAndFiles(IFileValidator fileValidator) {
        for (File graphicOrFile : this.map_tempFileName_tempFile.values()) {
            if (!fileValidator.isValid(graphicOrFile)) continue;
            return true;
        }
        return false;
    }

    public File getGraphicOrFileObjectFile(String filename) {
        return this.map_tempFileName_tempFile.get(filename);
    }

    public void dispose() {
        this.map_tempFileName_tempFile.clear();
        try {
            FileHelper.deleteExistingFileOrDirectory((File)this.tempImageDirectory);
        }
        catch (JvmExternalResourceInteractionException jeri) {
            logger.warn("Failed to delete obsolete temporary directory/files ", (Throwable)jeri);
        }
    }
}

