/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.dom;

import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.dom.AnchorWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.EmphasisWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.IAnchorParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IEmphasisParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ILinkParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IMediaObjectParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IParagraphParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IPhraseParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ISimpleListParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.IUlinkParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ImageObjectWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.LinkWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.MediaObjectWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.ParagraphWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.PhraseWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.SimpleListWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.UlinkWrapper;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableWrapper
implements IAnchorParent,
ILinkParent,
IParagraphParent,
ISimpleListParent,
ITableParent,
IUlinkParent,
IMediaObjectParent,
IEmphasisParent,
IPhraseParent {
    private Document document = null;
    private Node table = null;
    private Node tablePr = null;
    private Node tableGrid = null;
    private Element tableStyle = null;
    private Node row = null;
    private Node cell = null;
    private final Locale projectLocale;
    private final StyleMap styleMap;
    private ParagraphWrapper paragraphWrapper = null;

    public TableWrapper(Document document, Node parent, Locale projectLocale, StyleMap styleMap) {
        this.document = document;
        this.projectLocale = projectLocale;
        this.styleMap = styleMap;
        this.table = document.createElement("w:tbl");
        this.table = parent.appendChild(this.table);
        this.tablePr = document.createElement("w:tblPr");
        this.tablePr = this.table.appendChild(this.tablePr);
        this.tableStyle = document.createElement("w:tblStyle");
        this.tableStyle.setAttribute("w:val", "TableNormal");
        this.tablePr.appendChild(this.tableStyle);
        Element tableW = document.createElement("w:tblW");
        tableW.setAttribute("w:w", "0");
        tableW.setAttribute("w:type", "auto");
        this.tablePr.appendChild(tableW);
        Element tableLayout = document.createElement("w:tblLayout");
        tableLayout.setAttribute("w:type", "Fixed");
        this.tablePr.appendChild(tableLayout);
        Element tableLook = document.createElement("w:tblLook");
        tableLook.setAttribute("w:val", "01E0");
        this.tablePr.appendChild(tableLook);
        this.tableGrid = document.createElement("w:tblGrid");
        this.tableGrid = this.table.appendChild(this.tableGrid);
    }

    public void setStyle(String style) {
        this.tableStyle.setAttribute("w:val", style);
    }

    public void addColumn(double colWidthInPoints) {
        int colWidthInTwips = Double.valueOf(20.0 * colWidthInPoints).intValue();
        Element column = this.document.createElement("w:gridCol");
        column.setAttribute("w:w", Integer.toString(colWidthInTwips));
        this.tableGrid.appendChild(column);
    }

    public void addRow() {
        this.addRow(false);
    }

    public void addRow(boolean header) {
        this.row = this.document.createElement("w:tr");
        this.row = this.table.appendChild(this.row);
        Node rowPr = this.document.createElement("w:trPr");
        rowPr = this.row.appendChild(rowPr);
        Element cantSplit = this.document.createElement("w:cantSplit");
        rowPr.appendChild(cantSplit);
        if (header) {
            Element tableHeader = this.document.createElement("w:tblHeader");
            tableHeader.setAttribute("w:val", "on");
            rowPr.appendChild(tableHeader);
        }
    }

    public void controlRow() {
        NodeList list2;
        int cols;
        NodeList list = this.row.getChildNodes();
        int cells = list.getLength() - 1;
        if (cells < (cols = (list2 = this.tableGrid.getChildNodes()).getLength())) {
            int i = 0;
            while (i < cols - cells) {
                this.addCell();
                this.controlCell();
                ++i;
            }
        }
    }

    public void addCell() {
        this.cell = this.document.createElement("w:tc");
        this.row.appendChild(this.cell);
        this.paragraphWrapper = null;
    }

    public void addCellWithHMergeStart() {
        this.cell = this.document.createElement("w:tc");
        this.row.appendChild(this.cell);
        Node cellPr = this.document.createElement("w:tcPr");
        cellPr = this.cell.appendChild(cellPr);
        Element hmerge = this.document.createElement("w:hmerge");
        hmerge.setAttribute("w:val", "restart");
        cellPr.appendChild(hmerge);
    }

    public void addCellWithHMergeEnd() {
        this.cell = this.document.createElement("w:tc");
        this.row.appendChild(this.cell);
        Node cellPr = this.document.createElement("w:tcPr");
        cellPr = this.cell.appendChild(cellPr);
        Element hmerge = this.document.createElement("w:hmerge");
        cellPr.appendChild(hmerge);
    }

    public void controlCell() {
        Node lastChild = this.cell.getLastChild();
        if (lastChild == null) {
            this.addParagraph();
            this.paragraphWrapper.hideParagraph();
        } else if (!lastChild.getNodeName().equals("w:p")) {
            this.addParagraph();
            this.paragraphWrapper.hideParagraph();
        }
    }

    public void addText(String text) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        this.paragraphWrapper.addText(text);
    }

    @Override
    public SimpleListWrapper addSimpleList() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addSimpleList();
    }

    @Override
    public AnchorWrapper addAnchor(String anchorId, String anchorName) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addAnchor(anchorId, anchorName);
    }

    @Override
    public LinkWrapper addLink(String anchorName) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addLink(anchorName);
    }

    public void hideMergedParagraph() {
        if (this.paragraphWrapper != null) {
            this.paragraphWrapper.hideParagraph();
        }
    }

    @Override
    public ParagraphWrapper addParagraph() {
        return this.addParagraph(null);
    }

    @Override
    public ParagraphWrapper addParagraph(String style) {
        this.paragraphWrapper = new ParagraphWrapper(this.document, this.cell, style, this.styleMap, this.projectLocale);
        return this.paragraphWrapper;
    }

    @Override
    public TableWrapper addTable() {
        TableWrapper t = new TableWrapper(this.document, this.cell, this.projectLocale, this.styleMap);
        this.addParagraph();
        this.paragraphWrapper.hideParagraph();
        return t;
    }

    @Override
    public UlinkWrapper addUlink(String url) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addUlink(url);
    }

    @Override
    public EmphasisWrapper addEmphasis() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addEmphasis();
    }

    @Override
    public PhraseWrapper addPhrase() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addPhrase();
    }

    @Override
    public MediaObjectWrapper addMediaObject() {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addMediaObject();
    }

    @Override
    public ImageObjectWrapper addImageObject(String name, String format, float width, float height, boolean newImage, int imageCounter, String filename) {
        if (this.paragraphWrapper == null) {
            this.addParagraph("Table");
        }
        return this.paragraphWrapper.addImageObject(name, format, width, height, newImage, imageCounter, filename);
    }
}

