/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.dom;

import com.arcway.cockpit.docgen.writer.wordML.StyleMap;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.dom.ChapterWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.IParagraphParent;
import com.arcway.cockpit.docgen.writer.wordML.dom.ParagraphWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.WordMLReader;
import com.arcway.lib.java.dom.DOMHelper;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BodyNodeWrapper
implements IParagraphParent {
    private WordMLReader reader = null;
    private final StyleMap styleMap;
    private Node body = null;

    public BodyNodeWrapper(WordMLReader reader, StyleMap styleMap) {
        assert (reader != null) : "WordMLReader reader must not be null";
        this.reader = reader;
        this.styleMap = styleMap;
        Document doc = reader.getDocument();
        NodeList nl = doc.getElementsByTagName("w:body");
        if (nl.getLength() > 0) {
            this.body = nl.item(0);
        }
    }

    public Collection<Node> getTemplateContent() {
        ArrayList<Node> additionalContent = new ArrayList<Node>();
        NodeList potentialContent = this.body.getChildNodes();
        while (potentialContent.getLength() > 0) {
            Node potentialContentItem = potentialContent.item(0);
            additionalContent.add(potentialContentItem.cloneNode(true));
            this.body.removeChild(potentialContentItem);
        }
        return additionalContent;
    }

    public void appendTemplateContent(Collection<Node> additionalContent) {
        for (Node node : additionalContent) {
            this.body.appendChild(node);
        }
    }

    public void extractRelevantSectionPropertiesAndNormaliseSectionPropertiesOfLastSection(DocBook2WordMLGenerationContext context) {
        Node mainSectionProperties = DOMHelper.getLastChild((Node)this.body, (String)"w:sectPr");
        if (mainSectionProperties != null) {
            this.body.removeChild(mainSectionProperties);
        } else {
            mainSectionProperties = this.reader.getDocument().createElement("w:sectPr");
        }
        Node firstParagraph = DOMHelper.getFirstChild((Node)this.body, (String)"w:p");
        Node lastParagraph = DOMHelper.getLastChild((Node)this.body, (String)"w:p");
        if (lastParagraph != null && (lastParagraph != firstParagraph || lastParagraph.getChildNodes().getLength() > 0)) {
            Node paragraphProperties = DOMHelper.getFirstChild((Node)lastParagraph, (String)"w:pPr");
            if (paragraphProperties == null) {
                paragraphProperties = this.reader.getDocument().createElement("w:pPr");
                lastParagraph.appendChild(paragraphProperties);
            }
            paragraphProperties.appendChild(mainSectionProperties.cloneNode(true));
        } else if (lastParagraph != null) {
            this.body.removeChild(lastParagraph);
        }
        Node coverSectionProperties = null;
        for (Node paragraph : DOMHelper.getChildren((Node)this.body, (String)"w:p")) {
            Node paragraphPropertiesOfFirstSection = DOMHelper.getFirstChild((Node)paragraph, (String)"w:pPr");
            if (paragraphPropertiesOfFirstSection != null && (coverSectionProperties = DOMHelper.getFirstChild((Node)paragraphPropertiesOfFirstSection, (String)"w:sectPr")) != null) break;
        }
        if (coverSectionProperties == null) {
            coverSectionProperties = mainSectionProperties;
        }
        context.setMainSectionProperties(mainSectionProperties);
        context.setCoverSectionProperties(coverSectionProperties);
    }

    public void adjustSectionPropertiesOfLastSection(DocBook2WordMLGenerationContext context) {
        Node paragraphProperties;
        Node sectionProperties = null;
        Node lastParagraph = DOMHelper.getLastChild((Node)this.body, (String)"w:p");
        if (lastParagraph != null && (paragraphProperties = DOMHelper.getFirstChild((Node)lastParagraph, (String)"w:pPr")) != null && (sectionProperties = DOMHelper.getFirstChild((Node)paragraphProperties, (String)"w:sectPr")) != null) {
            paragraphProperties.removeChild(sectionProperties);
            if (paragraphProperties.getChildNodes().getLength() == 0) {
                lastParagraph.removeChild(paragraphProperties);
                if (lastParagraph.getChildNodes().getLength() == 0) {
                    this.body.removeChild(lastParagraph);
                }
            }
        }
        if (sectionProperties == null) {
            sectionProperties = context.getMainSectionProperties().cloneNode(true);
        }
        this.body.appendChild(sectionProperties);
    }

    public void removeAuxHintTags() {
        this.removeAuxHintTags(this.body);
    }

    private void removeAuxHintTags(Node rootNode) {
        int childIndex = 0;
        while (childIndex < rootNode.getChildNodes().getLength()) {
            Node currentChild = rootNode.getChildNodes().item(childIndex);
            if (currentChild.getNodeType() == 1) {
                if (currentChild.getNamespaceURI().equals("http://schemas.microsoft.com/office/word/2003/auxHint")) {
                    int childToCopyIndex = 0;
                    while (childToCopyIndex < currentChild.getChildNodes().getLength()) {
                        rootNode.insertBefore(currentChild.getChildNodes().item(childToCopyIndex).cloneNode(true), currentChild);
                        ++childToCopyIndex;
                    }
                    rootNode.removeChild(currentChild);
                    continue;
                }
                this.removeAuxHintTags(currentChild);
                ++childIndex;
                continue;
            }
            ++childIndex;
        }
    }

    public ChapterWrapper addChapter() {
        if (this.body != null) {
            return new ChapterWrapper(this.reader.getDocument(), this.body, this.reader.getProjectLocale(), this.styleMap);
        }
        return null;
    }

    @Override
    public ParagraphWrapper addParagraph() {
        ParagraphWrapper p = new ParagraphWrapper(this.reader.getDocument(), this.body, this.reader.getProjectLocale(), this.styleMap);
        return p;
    }

    @Override
    public ParagraphWrapper addParagraph(String style) {
        ParagraphWrapper p = new ParagraphWrapper(this.reader.getDocument(), this.body, style, this.styleMap, this.reader.getProjectLocale());
        return p;
    }
}

