/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.docbook2wordml;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.AnchorWriter;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.DocBook2WordMLGenerationContext;
import com.arcway.cockpit.docgen.writer.wordML.docbook2wordml.LinkWriter;
import com.arcway.cockpit.docgen.writer.wordML.dom.EmphasisWrapper;
import com.arcway.cockpit.docgen.writer.wordML.dom.IEmphasisParent;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.List;

public class EmphasisWriter {
    private static ILogger logger = Logger.getLogger(EmphasisWriter.class);
    private static EmphasisWriter writer;

    public static EmphasisWriter getInstance() {
        if (writer == null) {
            writer = new EmphasisWriter();
        }
        return writer;
    }

    private EmphasisWriter() {
    }

    public void write(EOEmphasis para, IEmphasisParent parent, DocBook2WordMLGenerationContext context) {
        List contentList = para.getContent(context.getReportJob());
        boolean setStyleExplicitly = false;
        String style = null;
        if (para.getRole() != null) {
            style = para.getRole();
            setStyleExplicitly = true;
        }
        EmphasisWrapper wrapper = parent.addEmphasis();
        for (Object obj : contentList) {
            if (obj instanceof String) {
                if (!setStyleExplicitly) {
                    wrapper.addEmphasizedText((String)obj, null);
                } else {
                    wrapper.addEmphasizedText((String)obj, style);
                }
                if (!logger.isDebugEnabled(180)) continue;
                logger.debug(180, "[write paragraph] inserted text " + (String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, parent, context);
                continue;
            }
            if (!(obj instanceof EOLink)) continue;
            LinkWriter.getInstance().write((EOLink)obj, parent, context);
        }
    }
}

