/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.dom;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;

public class CRLFLineBreaksXmlFileWriter
extends Writer {
    private static final ILogger LOGGER = Logger.getLogger(CRLFLineBreaksXmlFileWriter.class);
    public static final char[] CRLF_SEQUENCE = new char[]{'\r', '\n'};
    private final OutputStreamWriter outputStreamWriter;
    private boolean lastCharWasCR;

    public static boolean isCRLFPatchingNecessary() {
        try {
            String systemLineSeparator = System.getProperty("line.separator");
            if (systemLineSeparator != null && !Arrays.equals(systemLineSeparator.toCharArray(), CRLF_SEQUENCE)) {
                return true;
            }
        }
        catch (SecurityException e) {
            LOGGER.error("Unable to read system property \"line.separator\" - assuming XML Serialisation will produce Word2003XML style line separators by default.", (Throwable)e);
        }
        return false;
    }

    public CRLFLineBreaksXmlFileWriter(File file, String charsetName) throws UnsupportedEncodingException, FileNotFoundException {
        this.outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetName);
        this.lastCharWasCR = false;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int sectionOff = off;
        int sectionLen = 0;
        int i = off;
        while (i < off + len) {
            char cbuf_i = cbuf[i];
            if (cbuf_i == '\n' && !this.lastCharWasCR) {
                if (sectionLen > 0) {
                    this.outputStreamWriter.write(cbuf, sectionOff, sectionLen);
                }
                this.outputStreamWriter.write(CRLF_SEQUENCE, 0, CRLF_SEQUENCE.length);
                sectionOff = i + 1;
                sectionLen = 0;
            } else {
                ++sectionLen;
            }
            this.lastCharWasCR = cbuf_i == '\r';
            ++i;
        }
        if (sectionLen > 0) {
            this.outputStreamWriter.write(cbuf, sectionOff, sectionLen);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStreamWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStreamWriter.close();
    }
}

