/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.docbook.model.EOAnchor;
import com.arcway.cockpit.docgen.writer.docbook.model.EOColSpec;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEmphasis;
import com.arcway.cockpit.docgen.writer.docbook.model.EOEntry;
import com.arcway.cockpit.docgen.writer.docbook.model.EOLink;
import com.arcway.cockpit.docgen.writer.docbook.model.EOMediaObject;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPara;
import com.arcway.cockpit.docgen.writer.docbook.model.EOPhrase;
import com.arcway.cockpit.docgen.writer.docbook.model.EORow;
import com.arcway.cockpit.docgen.writer.docbook.model.EOSimpleList;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTBody;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTFoot;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTGroup;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTHead;
import com.arcway.cockpit.docgen.writer.docbook.model.EOTable;
import com.arcway.cockpit.docgen.writer.docbook.model.EOUlink;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.AnchorWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.EmphasisWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.LinkWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.MediaObjectWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.ParagraphWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.PhraseWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.SimpleListWriter;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.TableRowType;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.UlinkWriter;
import com.arcway.cockpit.docgen.writer.odt.dom.ITableParent;
import com.arcway.cockpit.docgen.writer.odt.dom.TableWrapper;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.util.HashMap;
import java.util.List;

public class TableWriter {
    private static final ILogger logger = Logger.getLogger(TableWriter.class);
    private static TableWriter writer;

    public static TableWriter getInstance() {
        if (writer == null) {
            writer = new TableWriter();
        }
        return writer;
    }

    private TableWriter() {
    }

    public void write(EOTable eotable, ITableParent parent, DocBook2ODTGenerationContext context) throws ReportGenerationException, JvmExternalResourceInteractionException {
        int numHeaderRows;
        EOColSpec colSpec;
        List tgroupList = eotable.getTGroup();
        EOTGroup tgroup = (EOTGroup)tgroupList.get(0);
        int numColumns = tgroup.getCols();
        List colSpecs = tgroup.getColspec();
        EOTHead tHead = tgroup.getTableHead();
        EOTBody tBody = tgroup.getTableBody();
        EOTFoot tFoot = tgroup.getTableFoot();
        TableWrapper wrapper = parent.addTable(eotable.getAttrTabstyle(), context);
        if (numColumns != colSpecs.size()) {
            logger.warn("The specified number of table columns differs from the number of column specifications (numColumns=" + numColumns + ", numColSpecs.size()=" + colSpecs.size() + ").");
        }
        double totalTableWithInMm = 0.0;
        int i = 0;
        while (i < colSpecs.size() && i < numColumns) {
            colSpec = (EOColSpec)colSpecs.get(i);
            totalTableWithInMm += colSpec.getColumnwidthInMm();
            ++i;
        }
        wrapper.setStyle(totalTableWithInMm);
        if (logger.isDebugEnabled(185)) {
            logger.debug(185, "[write table] added table ");
        }
        i = 0;
        while (i < colSpecs.size() && i < numColumns) {
            colSpec = (EOColSpec)colSpecs.get(i);
            double colWidthInMm = colSpec.getColumnwidthInMm();
            wrapper.addColumn(colWidthInMm);
            ++i;
        }
        if (tHead != null) {
            List headerRowList = tHead.getRows();
            numHeaderRows = headerRowList.size();
            int headerRowIndex = 0;
            while (headerRowIndex < numHeaderRows) {
                EORow row = (EORow)headerRowList.get(headerRowIndex);
                wrapper.addRow(TableRowType.HEADER_ROW);
                this.write(row, wrapper, colSpecs, true, context);
                wrapper.controlRow();
                ++headerRowIndex;
            }
        } else {
            numHeaderRows = 0;
        }
        List bodyRowList = tBody.getRows();
        int numBodyRows = bodyRowList.size();
        int bodyRowIndex = 0;
        while (bodyRowIndex < numBodyRows) {
            EORow row = (EORow)bodyRowList.get(bodyRowIndex);
            wrapper.addRow(TableRowType.BODY_ROW);
            this.write(row, wrapper, colSpecs, false, context);
            wrapper.controlRow();
            ++bodyRowIndex;
        }
        if (tFoot != null) {
            List footerRowList = tFoot.getRows();
            int numFooterRows = footerRowList.size();
            int footerRowIndex = 0;
            while (footerRowIndex < numFooterRows) {
                EORow row = (EORow)footerRowList.get(footerRowIndex);
                wrapper.addRow(TableRowType.BODY_ROW);
                this.write(row, wrapper, colSpecs, false, context);
                wrapper.controlRow();
                ++footerRowIndex;
            }
        } else {
            boolean numFooterRows = false;
        }
    }

    private void write(EORow eoRow, TableWrapper wrapper, List<?> colspecs, boolean forceBold, DocBook2ODTGenerationContext context) throws ReportGenerationException, JvmExternalResourceInteractionException {
        HashMap<String, Integer> map_columnName_columnIndex = new HashMap<String, Integer>();
        int i = 0;
        while (i < colspecs.size()) {
            EOColSpec colSpec = (EOColSpec)colspecs.get(i);
            map_columnName_columnIndex.put(colSpec.getColname(), i);
            ++i;
        }
        List entries = eoRow.getEntryList();
        for (Object name : entries) {
            EOEntry entry = (EOEntry)name;
            String colnameStart = entry.getNamest();
            String colnameEnd = entry.getNameend();
            if (colnameStart != null && colnameEnd != null) {
                int startColIndex = (Integer)map_columnName_columnIndex.get(colnameStart);
                int endColIndex = (Integer)map_columnName_columnIndex.get(colnameEnd);
                wrapper.addCell(1 + endColIndex - startColIndex);
                this.write(entry, wrapper, forceBold, context);
                wrapper.controlCell();
                continue;
            }
            wrapper.addCell(1);
            this.write(entry, wrapper, forceBold, context);
            wrapper.controlCell();
        }
        if (logger.isDebugEnabled(185)) {
            logger.debug(185, "[write table] wrote table row");
        }
    }

    private void write(EOEntry entry, TableWrapper wrapper, boolean forceBold, DocBook2ODTGenerationContext context) throws ReportGenerationException, JvmExternalResourceInteractionException {
        List content = entry.getContent(context.getReportJob());
        String style = entry.getRole();
        if ((style == null || style.length() == 0) && forceBold) {
            style = "TableBold";
        }
        if (style != null && style.length() > 0) {
            wrapper.addParagraph(style);
        }
        for (Object obj : content) {
            if (obj instanceof String) {
                wrapper.addText((String)obj);
                continue;
            }
            if (obj instanceof EOAnchor) {
                AnchorWriter.getInstance().write((EOAnchor)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOLink) {
                LinkWriter.getInstance().write((EOLink)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOUlink) {
                UlinkWriter.getInstance().write((EOUlink)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOEmphasis) {
                EmphasisWriter.getInstance().write((EOEmphasis)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOPhrase) {
                PhraseWriter.getInstance().write((EOPhrase)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOPara) {
                ParagraphWriter.getInstance().write((EOPara)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOTable) {
                this.write((EOTable)obj, wrapper, context);
                continue;
            }
            if (obj instanceof EOSimpleList) {
                SimpleListWriter.getInstance().write((EOSimpleList)obj, wrapper, context);
                continue;
            }
            if (!(obj instanceof EOMediaObject)) continue;
            MediaObjectWriter.getInstance().write((EOMediaObject)obj, wrapper, context);
        }
        if (logger.isDebugEnabled(185)) {
            logger.debug(185, "[write table] wrote table entry");
        }
    }
}

